# coding: utf-8

"""
    Seldon Deploy API

    API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.  # noqa: E501

    OpenAPI spec version: v1alpha1
    Contact: hello@seldon.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from seldon_deploy_sdk.api_client import ApiClient


class MonitorApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def seldon_deployment_feature_distributions(self, name, namespace, feature_data, **kwargs):  # noqa: E501
        """seldon_deployment_feature_distributions  # noqa: E501

        Get the specified Seldon Deployment predictions feature distribution  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.seldon_deployment_feature_distributions(name, namespace, feature_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param DeploymentFeatureData feature_data: Deployment Feature Data (required)
        :return: FeatureDistributionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.seldon_deployment_feature_distributions_with_http_info(name, namespace, feature_data, **kwargs)  # noqa: E501
        else:
            (data) = self.seldon_deployment_feature_distributions_with_http_info(name, namespace, feature_data, **kwargs)  # noqa: E501
            return data

    def seldon_deployment_feature_distributions_with_http_info(self, name, namespace, feature_data, **kwargs):  # noqa: E501
        """seldon_deployment_feature_distributions  # noqa: E501

        Get the specified Seldon Deployment predictions feature distribution  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.seldon_deployment_feature_distributions_with_http_info(name, namespace, feature_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param DeploymentFeatureData feature_data: Deployment Feature Data (required)
        :return: FeatureDistributionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'feature_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method seldon_deployment_feature_distributions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `seldon_deployment_feature_distributions`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `seldon_deployment_feature_distributions`")  # noqa: E501
        # verify the required parameter 'feature_data' is set
        if ('feature_data' not in params or
                params['feature_data'] is None):
            raise ValueError("Missing the required parameter `feature_data` when calling `seldon_deployment_feature_distributions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'feature_data' in params:
            body_params = params['feature_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/seldondeployments/{name}/monitor/featuredistributions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeatureDistributionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def seldon_deployment_feature_statistics(self, name, namespace, feature_data, **kwargs):  # noqa: E501
        """seldon_deployment_feature_statistics  # noqa: E501

        Get the specified Seldon Deployment predictions feature statistics  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.seldon_deployment_feature_statistics(name, namespace, feature_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param DeploymentFeatureData feature_data: Deployment Feature Data (required)
        :return: FeatureStatisticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.seldon_deployment_feature_statistics_with_http_info(name, namespace, feature_data, **kwargs)  # noqa: E501
        else:
            (data) = self.seldon_deployment_feature_statistics_with_http_info(name, namespace, feature_data, **kwargs)  # noqa: E501
            return data

    def seldon_deployment_feature_statistics_with_http_info(self, name, namespace, feature_data, **kwargs):  # noqa: E501
        """seldon_deployment_feature_statistics  # noqa: E501

        Get the specified Seldon Deployment predictions feature statistics  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.seldon_deployment_feature_statistics_with_http_info(name, namespace, feature_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param DeploymentFeatureData feature_data: Deployment Feature Data (required)
        :return: FeatureStatisticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'feature_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method seldon_deployment_feature_statistics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `seldon_deployment_feature_statistics`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `seldon_deployment_feature_statistics`")  # noqa: E501
        # verify the required parameter 'feature_data' is set
        if ('feature_data' not in params or
                params['feature_data'] is None):
            raise ValueError("Missing the required parameter `feature_data` when calling `seldon_deployment_feature_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'feature_data' in params:
            body_params = params['feature_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/seldondeployments/{name}/monitor/featurestatistics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeatureStatisticsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def seldon_pipeline_feature_distributions(self, name, namespace, feature_data, **kwargs):  # noqa: E501
        """seldon_pipeline_feature_distributions  # noqa: E501

        Get the specified Seldon Deployment predictions feature distribution  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.seldon_pipeline_feature_distributions(name, namespace, feature_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param DeploymentFeatureData feature_data: Deployment Feature Data (required)
        :return: FeatureDistributionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.seldon_pipeline_feature_distributions_with_http_info(name, namespace, feature_data, **kwargs)  # noqa: E501
        else:
            (data) = self.seldon_pipeline_feature_distributions_with_http_info(name, namespace, feature_data, **kwargs)  # noqa: E501
            return data

    def seldon_pipeline_feature_distributions_with_http_info(self, name, namespace, feature_data, **kwargs):  # noqa: E501
        """seldon_pipeline_feature_distributions  # noqa: E501

        Get the specified Seldon Deployment predictions feature distribution  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.seldon_pipeline_feature_distributions_with_http_info(name, namespace, feature_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param DeploymentFeatureData feature_data: Deployment Feature Data (required)
        :return: FeatureDistributionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'feature_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method seldon_pipeline_feature_distributions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `seldon_pipeline_feature_distributions`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `seldon_pipeline_feature_distributions`")  # noqa: E501
        # verify the required parameter 'feature_data' is set
        if ('feature_data' not in params or
                params['feature_data'] is None):
            raise ValueError("Missing the required parameter `feature_data` when calling `seldon_pipeline_feature_distributions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'feature_data' in params:
            body_params = params['feature_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/pipelines/{name}/monitor/featuredistributions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeatureDistributionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def seldon_pipeline_feature_statistics(self, name, namespace, feature_data, **kwargs):  # noqa: E501
        """seldon_pipeline_feature_statistics  # noqa: E501

        Get the specified Seldon Deployment predictions feature statistics  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.seldon_pipeline_feature_statistics(name, namespace, feature_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param DeploymentFeatureData feature_data: Deployment Feature Data (required)
        :return: FeatureStatisticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.seldon_pipeline_feature_statistics_with_http_info(name, namespace, feature_data, **kwargs)  # noqa: E501
        else:
            (data) = self.seldon_pipeline_feature_statistics_with_http_info(name, namespace, feature_data, **kwargs)  # noqa: E501
            return data

    def seldon_pipeline_feature_statistics_with_http_info(self, name, namespace, feature_data, **kwargs):  # noqa: E501
        """seldon_pipeline_feature_statistics  # noqa: E501

        Get the specified Seldon Deployment predictions feature statistics  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.seldon_pipeline_feature_statistics_with_http_info(name, namespace, feature_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param DeploymentFeatureData feature_data: Deployment Feature Data (required)
        :return: FeatureStatisticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'feature_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method seldon_pipeline_feature_statistics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `seldon_pipeline_feature_statistics`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `seldon_pipeline_feature_statistics`")  # noqa: E501
        # verify the required parameter 'feature_data' is set
        if ('feature_data' not in params or
                params['feature_data'] is None):
            raise ValueError("Missing the required parameter `feature_data` when calling `seldon_pipeline_feature_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'feature_data' in params:
            body_params = params['feature_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/pipelines/{name}/monitor/featurestatistics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeatureStatisticsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
