# coding: utf-8

"""
    Seldon Deploy API

    API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.  # noqa: E501

    OpenAPI spec version: v1alpha1
    Contact: hello@seldon.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from seldon_deploy_sdk.api_client import ApiClient


class ModelsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_model(self, namespace, model, **kwargs):  # noqa: E501
        """create_model  # noqa: E501

        Create a Seldon Model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_model(namespace, model, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param Model model: Seldon Model (required)
        :param str action: Action
        :param str message: Message
        :return: SeldonModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_model_with_http_info(namespace, model, **kwargs)  # noqa: E501
        else:
            (data) = self.create_model_with_http_info(namespace, model, **kwargs)  # noqa: E501
            return data

    def create_model_with_http_info(self, namespace, model, **kwargs):  # noqa: E501
        """create_model  # noqa: E501

        Create a Seldon Model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_model_with_http_info(namespace, model, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param Model model: Seldon Model (required)
        :param str action: Action
        :param str message: Message
        :return: SeldonModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'model', 'action', 'message']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_model" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_model`")  # noqa: E501
        # verify the required parameter 'model' is set
        if ('model' not in params or
                params['model'] is None):
            raise ValueError("Missing the required parameter `model` when calling `create_model`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []
        if 'action' in params:
            query_params.append(('action', params['action']))  # noqa: E501
        if 'message' in params:
            query_params.append(('message', params['message']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model' in params:
            body_params = params['model']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/models', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SeldonModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_model(self, name, namespace, **kwargs):  # noqa: E501
        """delete_model  # noqa: E501

        Delete the specified Seldon Model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_model(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param str action: Action
        :param str message: Message
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_model_with_http_info(name, namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_model_with_http_info(name, namespace, **kwargs)  # noqa: E501
            return data

    def delete_model_with_http_info(self, name, namespace, **kwargs):  # noqa: E501
        """delete_model  # noqa: E501

        Delete the specified Seldon Model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_model_with_http_info(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param str action: Action
        :param str message: Message
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'action', 'message']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_model" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_model`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_model`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []
        if 'action' in params:
            query_params.append(('action', params['action']))  # noqa: E501
        if 'message' in params:
            query_params.append(('message', params['message']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/models/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read_model(self, name, namespace, **kwargs):  # noqa: E501
        """read_model  # noqa: E501

        Read the specified Seldon Model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_model(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: SeldonModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.read_model_with_http_info(name, namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.read_model_with_http_info(name, namespace, **kwargs)  # noqa: E501
            return data

    def read_model_with_http_info(self, name, namespace, **kwargs):  # noqa: E501
        """read_model  # noqa: E501

        Read the specified Seldon Model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_model_with_http_info(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: SeldonModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_model" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_model`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_model`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/models/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SeldonModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_model(self, name, namespace, model, **kwargs):  # noqa: E501
        """update_model  # noqa: E501

        Update the specified Seldon Model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_model(name, namespace, model, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param Model model: Seldon Model (required)
        :param str action: Action
        :param str message: Message
        :return: SeldonModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_model_with_http_info(name, namespace, model, **kwargs)  # noqa: E501
        else:
            (data) = self.update_model_with_http_info(name, namespace, model, **kwargs)  # noqa: E501
            return data

    def update_model_with_http_info(self, name, namespace, model, **kwargs):  # noqa: E501
        """update_model  # noqa: E501

        Update the specified Seldon Model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_model_with_http_info(name, namespace, model, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param Model model: Seldon Model (required)
        :param str action: Action
        :param str message: Message
        :return: SeldonModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'model', 'action', 'message']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_model" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `update_model`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `update_model`")  # noqa: E501
        # verify the required parameter 'model' is set
        if ('model' not in params or
                params['model'] is None):
            raise ValueError("Missing the required parameter `model` when calling `update_model`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []
        if 'action' in params:
            query_params.append(('action', params['action']))  # noqa: E501
        if 'message' in params:
            query_params.append(('message', params['message']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model' in params:
            body_params = params['model']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/models/{name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SeldonModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
