# coding: utf-8

"""
    Seldon Deploy API

    API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.  # noqa: E501

    OpenAPI spec version: v1alpha1
    Contact: hello@seldon.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from seldon_deploy_sdk.api_client import ApiClient


class LoadtestJobsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_loadtest_pipeline(self, name, namespace, load_file, **kwargs):  # noqa: E501
        """create_loadtest_pipeline  # noqa: E501

        Create Pipeline load test multipart/form-data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_loadtest_pipeline(name, namespace, load_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param file load_file: Prediction contains predict payload (required)
        :param str connections_number: Connections Number provides number of allowed connections
        :param str requests_number: Requests Number provides number of allowed requests
        :param str duration: Duration of load test in seconds
        :return: Message
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_loadtest_pipeline_with_http_info(name, namespace, load_file, **kwargs)  # noqa: E501
        else:
            (data) = self.create_loadtest_pipeline_with_http_info(name, namespace, load_file, **kwargs)  # noqa: E501
            return data

    def create_loadtest_pipeline_with_http_info(self, name, namespace, load_file, **kwargs):  # noqa: E501
        """create_loadtest_pipeline  # noqa: E501

        Create Pipeline load test multipart/form-data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_loadtest_pipeline_with_http_info(name, namespace, load_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param file load_file: Prediction contains predict payload (required)
        :param str connections_number: Connections Number provides number of allowed connections
        :param str requests_number: Requests Number provides number of allowed requests
        :param str duration: Duration of load test in seconds
        :return: Message
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'load_file', 'connections_number', 'requests_number', 'duration']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_loadtest_pipeline" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_loadtest_pipeline`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_loadtest_pipeline`")  # noqa: E501
        # verify the required parameter 'load_file' is set
        if ('load_file' not in params or
                params['load_file'] is None):
            raise ValueError("Missing the required parameter `load_file` when calling `create_loadtest_pipeline`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'load_file' in params:
            local_var_files['loadFile'] = params['load_file']  # noqa: E501
        if 'connections_number' in params:
            form_params.append(('connectionsNumber', params['connections_number']))  # noqa: E501
        if 'requests_number' in params:
            form_params.append(('requestsNumber', params['requests_number']))  # noqa: E501
        if 'duration' in params:
            form_params.append(('duration', params['duration']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/pipelines/{name}/loadtestjobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Message',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_loadtest_seldon_deployment(self, name, namespace, load_file, **kwargs):  # noqa: E501
        """create_loadtest_seldon_deployment  # noqa: E501

        Create Seldon Deployment load test multipart/form-data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_loadtest_seldon_deployment(name, namespace, load_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param file load_file: Prediction contains predict payload (required)
        :param str connections_number: Connections Number provides number of allowed connections
        :param str requests_number: Requests Number provides number of allowed requests
        :param str duration: Duration of load test in seconds
        :return: Message
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_loadtest_seldon_deployment_with_http_info(name, namespace, load_file, **kwargs)  # noqa: E501
        else:
            (data) = self.create_loadtest_seldon_deployment_with_http_info(name, namespace, load_file, **kwargs)  # noqa: E501
            return data

    def create_loadtest_seldon_deployment_with_http_info(self, name, namespace, load_file, **kwargs):  # noqa: E501
        """create_loadtest_seldon_deployment  # noqa: E501

        Create Seldon Deployment load test multipart/form-data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_loadtest_seldon_deployment_with_http_info(name, namespace, load_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param file load_file: Prediction contains predict payload (required)
        :param str connections_number: Connections Number provides number of allowed connections
        :param str requests_number: Requests Number provides number of allowed requests
        :param str duration: Duration of load test in seconds
        :return: Message
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'load_file', 'connections_number', 'requests_number', 'duration']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_loadtest_seldon_deployment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_loadtest_seldon_deployment`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_loadtest_seldon_deployment`")  # noqa: E501
        # verify the required parameter 'load_file' is set
        if ('load_file' not in params or
                params['load_file'] is None):
            raise ValueError("Missing the required parameter `load_file` when calling `create_loadtest_seldon_deployment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'load_file' in params:
            local_var_files['loadFile'] = params['load_file']  # noqa: E501
        if 'connections_number' in params:
            form_params.append(('connectionsNumber', params['connections_number']))  # noqa: E501
        if 'requests_number' in params:
            form_params.append(('requestsNumber', params['requests_number']))  # noqa: E501
        if 'duration' in params:
            form_params.append(('duration', params['duration']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/seldondeployments/{name}/loadtestjobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Message',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_loadtest_pipeline(self, job_name, name, namespace, **kwargs):  # noqa: E501
        """delete_loadtest_pipeline  # noqa: E501

        Delete Pipeline load test jobs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_loadtest_pipeline(job_name, name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_name: JobName identifies a job name (required)
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: Message
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_loadtest_pipeline_with_http_info(job_name, name, namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_loadtest_pipeline_with_http_info(job_name, name, namespace, **kwargs)  # noqa: E501
            return data

    def delete_loadtest_pipeline_with_http_info(self, job_name, name, namespace, **kwargs):  # noqa: E501
        """delete_loadtest_pipeline  # noqa: E501

        Delete Pipeline load test jobs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_loadtest_pipeline_with_http_info(job_name, name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_name: JobName identifies a job name (required)
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: Message
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_name', 'name', 'namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_loadtest_pipeline" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_name' is set
        if ('job_name' not in params or
                params['job_name'] is None):
            raise ValueError("Missing the required parameter `job_name` when calling `delete_loadtest_pipeline`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_loadtest_pipeline`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_loadtest_pipeline`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_name' in params:
            path_params['jobName'] = params['job_name']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/pipelines/{name}/loadtestjobs/{jobName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Message',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_loadtest_seldon_deployment(self, job_name, name, namespace, **kwargs):  # noqa: E501
        """delete_loadtest_seldon_deployment  # noqa: E501

        Delete Seldon Deployment load test jobs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_loadtest_seldon_deployment(job_name, name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_name: JobName identifies a job name (required)
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: Message
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_loadtest_seldon_deployment_with_http_info(job_name, name, namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_loadtest_seldon_deployment_with_http_info(job_name, name, namespace, **kwargs)  # noqa: E501
            return data

    def delete_loadtest_seldon_deployment_with_http_info(self, job_name, name, namespace, **kwargs):  # noqa: E501
        """delete_loadtest_seldon_deployment  # noqa: E501

        Delete Seldon Deployment load test jobs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_loadtest_seldon_deployment_with_http_info(job_name, name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_name: JobName identifies a job name (required)
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: Message
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_name', 'name', 'namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_loadtest_seldon_deployment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_name' is set
        if ('job_name' not in params or
                params['job_name'] is None):
            raise ValueError("Missing the required parameter `job_name` when calling `delete_loadtest_seldon_deployment`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_loadtest_seldon_deployment`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_loadtest_seldon_deployment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_name' in params:
            path_params['jobName'] = params['job_name']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/seldondeployments/{name}/loadtestjobs/{jobName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Message',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_loadtest_pipeline(self, name, namespace, **kwargs):  # noqa: E501
        """list_loadtest_pipeline  # noqa: E501

        List Pipeline load test jobs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_loadtest_pipeline(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: Message
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_loadtest_pipeline_with_http_info(name, namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.list_loadtest_pipeline_with_http_info(name, namespace, **kwargs)  # noqa: E501
            return data

    def list_loadtest_pipeline_with_http_info(self, name, namespace, **kwargs):  # noqa: E501
        """list_loadtest_pipeline  # noqa: E501

        List Pipeline load test jobs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_loadtest_pipeline_with_http_info(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: Message
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_loadtest_pipeline" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `list_loadtest_pipeline`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_loadtest_pipeline`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/pipelines/{name}/loadtestjobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Message',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_loadtest_seldon_deployment(self, name, namespace, **kwargs):  # noqa: E501
        """list_loadtest_seldon_deployment  # noqa: E501

        List Seldon Deployment load test jobs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_loadtest_seldon_deployment(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: Message
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_loadtest_seldon_deployment_with_http_info(name, namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.list_loadtest_seldon_deployment_with_http_info(name, namespace, **kwargs)  # noqa: E501
            return data

    def list_loadtest_seldon_deployment_with_http_info(self, name, namespace, **kwargs):  # noqa: E501
        """list_loadtest_seldon_deployment  # noqa: E501

        List Seldon Deployment load test jobs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_loadtest_seldon_deployment_with_http_info(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: Message
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_loadtest_seldon_deployment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `list_loadtest_seldon_deployment`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_loadtest_seldon_deployment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/seldondeployments/{name}/loadtestjobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Message',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
