# seldon-deploy-sdk
API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v1alpha1
- Package version: 2.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.6+

## Installation & Usage
### pip install

You can install from PyPI:

```sh
pip install seldon-deploy-sdk
```

or directly from Github:

```sh
pip install git+https://github.com/SeldonIO/seldon-deploy-sdk.git
```

Then import the package:
```python
import seldon_deploy_sdk 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import seldon_deploy_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import seldon_deploy_sdk
from seldon_deploy_sdk.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: OAuth2
configuration = seldon_deploy_sdk.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = seldon_deploy_sdk.AlertingServiceApi(seldon_deploy_sdk.ApiClient(configuration))

try:
    # List currently firing alerts.
    api_response = api_instance.alerting_service_list_alerts()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AlertingServiceApi->alerting_service_list_alerts: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://X.X.X.X/seldon-deploy/api/v1alpha1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlertingServiceApi* | [**alerting_service_list_alerts**](docs/AlertingServiceApi.md#alerting_service_list_alerts) | **GET** /alerting/alerts | List currently firing alerts.
*AlertingServiceApi* | [**alerting_service_trigger_test_alert**](docs/AlertingServiceApi.md#alerting_service_trigger_test_alert) | **POST** /alerting/test | Triggers a test alert to check alerting workflow.
*ApplicationLogsApi* | [**read_application_logs**](docs/ApplicationLogsApi.md#read_application_logs) | **POST** /applicationlogs | Read application container logs from elastic search.
*BatchJobsApi* | [**create_pipeline_batch_job**](docs/BatchJobsApi.md#create_pipeline_batch_job) | **POST** /namespaces/{namespace}/pipelines/{name}/batchjobs | 
*BatchJobsApi* | [**create_seldon_deployment_batch_job**](docs/BatchJobsApi.md#create_seldon_deployment_batch_job) | **POST** /namespaces/{namespace}/seldondeployments/{name}/batchjobs | 
*BatchJobsApi* | [**get_deployment_batch_job**](docs/BatchJobsApi.md#get_deployment_batch_job) | **GET** /namespaces/{namespace}/seldondeployments/{name}/batchjobs/{jobName} | 
*BatchJobsApi* | [**get_pipeline_batch_job**](docs/BatchJobsApi.md#get_pipeline_batch_job) | **GET** /namespaces/{namespace}/pipelines/{name}/batchjobs/{jobName} | 
*BatchJobsApi* | [**list_pipeline_batch_jobs**](docs/BatchJobsApi.md#list_pipeline_batch_jobs) | **GET** /namespaces/{namespace}/pipelines/{name}/batchjobs | 
*BatchJobsApi* | [**list_seldon_deployment_batch_jobs**](docs/BatchJobsApi.md#list_seldon_deployment_batch_jobs) | **GET** /namespaces/{namespace}/seldondeployments/{name}/batchjobs | 
*DriftDetectorApi* | [**create_drift_detector_seldon_deployment**](docs/DriftDetectorApi.md#create_drift_detector_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments/{name}/monitor/drift-detector | 
*DriftDetectorApi* | [**create_drift_detector_seldon_pipeline**](docs/DriftDetectorApi.md#create_drift_detector_seldon_pipeline) | **POST** /namespaces/{namespace}/pipelines/{name}/monitor/drift-detector | 
*DriftDetectorApi* | [**delete_drift_detector_seldon_deployment**](docs/DriftDetectorApi.md#delete_drift_detector_seldon_deployment) | **DELETE** /namespaces/{namespace}/seldondeployments/{name}/monitor/drift-detector/{detectorName} | 
*DriftDetectorApi* | [**delete_drift_detector_seldon_pipeline**](docs/DriftDetectorApi.md#delete_drift_detector_seldon_pipeline) | **DELETE** /namespaces/{namespace}/pipelines/{name}/monitor/drift-detector/{detectorName} | 
*DriftDetectorApi* | [**list_drift_detector_seldon_deployment**](docs/DriftDetectorApi.md#list_drift_detector_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/{name}/monitor/drift-detector | 
*DriftDetectorApi* | [**list_drift_detector_seldon_pipeline**](docs/DriftDetectorApi.md#list_drift_detector_seldon_pipeline) | **GET** /namespaces/{namespace}/pipelines/{name}/monitor/drift-detector | 
*DriftDetectorApi* | [**read_drift_detector_seldon_deployment**](docs/DriftDetectorApi.md#read_drift_detector_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/{name}/monitor/drift-detector/{detectorName} | 
*DriftDetectorApi* | [**read_drift_detector_seldon_pipeline**](docs/DriftDetectorApi.md#read_drift_detector_seldon_pipeline) | **GET** /namespaces/{namespace}/pipelines/{name}/monitor/drift-detector/{detectorName} | 
*EnvironmentApi* | [**read_cluster**](docs/EnvironmentApi.md#read_cluster) | **GET** /cluster | 
*EnvironmentApi* | [**read_health_check**](docs/EnvironmentApi.md#read_health_check) | **GET** /healthcheck | 
*EnvironmentApi* | [**read_user**](docs/EnvironmentApi.md#read_user) | **GET** /user | 
*EnvironmentApi* | [**read_version**](docs/EnvironmentApi.md#read_version) | **GET** /version | 
*ExperimentsApi* | [**create_canary_experiment**](docs/ExperimentsApi.md#create_canary_experiment) | **POST** /namespaces/{namespace}/pipelines/{name}/experiment/canary | 
*ExperimentsApi* | [**create_pipeline_experiment**](docs/ExperimentsApi.md#create_pipeline_experiment) | **POST** /namespaces/{namespace}/pipelines/{name}/experiment | 
*ExperimentsApi* | [**create_shadow_experiment**](docs/ExperimentsApi.md#create_shadow_experiment) | **POST** /namespaces/{namespace}/pipelines/{name}/experiment/shadow | 
*ExperimentsApi* | [**delete_pipeline_experiment**](docs/ExperimentsApi.md#delete_pipeline_experiment) | **DELETE** /namespaces/{namespace}/pipelines/{name}/experiment | 
*ExperimentsApi* | [**get_pipeline_experiment**](docs/ExperimentsApi.md#get_pipeline_experiment) | **GET** /namespaces/{namespace}/pipelines/{name}/experiment | 
*ExperimentsApi* | [**promote_canary**](docs/ExperimentsApi.md#promote_canary) | **PUT** /namespaces/{namespace}/pipelines/{name}/experiment/canary | 
*ExperimentsApi* | [**promote_shadow**](docs/ExperimentsApi.md#promote_shadow) | **PUT** /namespaces/{namespace}/pipelines/{name}/experiment/shadow | 
*ExperimentsApi* | [**remove_canary**](docs/ExperimentsApi.md#remove_canary) | **DELETE** /namespaces/{namespace}/pipelines/{name}/experiment/canary | 
*ExperimentsApi* | [**remove_shadow**](docs/ExperimentsApi.md#remove_shadow) | **DELETE** /namespaces/{namespace}/pipelines/{name}/experiment/shadow | 
*ExperimentsApi* | [**update_pipeline_experiment**](docs/ExperimentsApi.md#update_pipeline_experiment) | **PUT** /namespaces/{namespace}/pipelines/{name}/experiment | 
*ExplainApi* | [**explain_seldon_deployment**](docs/ExplainApi.md#explain_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments/{name}/explain | 
*ExplainApi* | [**explain_seldon_pipeline**](docs/ExplainApi.md#explain_seldon_pipeline) | **POST** /namespaces/{namespace}/pipelines/{name}/explain | 
*GitOpsApi* | [**read_git_ops_status**](docs/GitOpsApi.md#read_git_ops_status) | **GET** /namespaces/{namespace}/gitops-status | 
*GitOpsApi* | [**read_pipeline_git_diff**](docs/GitOpsApi.md#read_pipeline_git_diff) | **GET** /namespaces/{namespace}/pipelines/{name}/gitdiff | 
*GitOpsApi* | [**read_pipeline_git_logs**](docs/GitOpsApi.md#read_pipeline_git_logs) | **GET** /namespaces/{namespace}/pipelines/{name}/gitlogs | 
*GitOpsApi* | [**read_seldon_deployment_git_diff**](docs/GitOpsApi.md#read_seldon_deployment_git_diff) | **GET** /namespaces/{namespace}/seldondeployments/{name}/gitdiff | 
*GitOpsApi* | [**read_seldon_deployment_git_logs**](docs/GitOpsApi.md#read_seldon_deployment_git_logs) | **GET** /namespaces/{namespace}/seldondeployments/{name}/gitlogs | 
*GitOpsApi* | [**seldon_deployment_git_restore**](docs/GitOpsApi.md#seldon_deployment_git_restore) | **GET** /namespaces/{namespace}/seldondeployments/{name}/gitrestore | 
*GitOpsApi* | [**seldon_deployment_git_revert**](docs/GitOpsApi.md#seldon_deployment_git_revert) | **GET** /namespaces/{namespace}/seldondeployments/{name}/gitrevert | 
*KubernetesResourcesApi* | [**list_seldon_deployment_resources**](docs/KubernetesResourcesApi.md#list_seldon_deployment_resources) | **GET** /namespaces/{namespace}/seldondeployments/{name}/resources | 
*LoadtestJobsApi* | [**create_loadtest_pipeline**](docs/LoadtestJobsApi.md#create_loadtest_pipeline) | **POST** /namespaces/{namespace}/pipelines/{name}/loadtestjobs | 
*LoadtestJobsApi* | [**create_loadtest_seldon_deployment**](docs/LoadtestJobsApi.md#create_loadtest_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments/{name}/loadtestjobs | 
*LoadtestJobsApi* | [**delete_loadtest_pipeline**](docs/LoadtestJobsApi.md#delete_loadtest_pipeline) | **DELETE** /namespaces/{namespace}/pipelines/{name}/loadtestjobs/{jobName} | 
*LoadtestJobsApi* | [**delete_loadtest_seldon_deployment**](docs/LoadtestJobsApi.md#delete_loadtest_seldon_deployment) | **DELETE** /namespaces/{namespace}/seldondeployments/{name}/loadtestjobs/{jobName} | 
*LoadtestJobsApi* | [**list_loadtest_pipeline**](docs/LoadtestJobsApi.md#list_loadtest_pipeline) | **GET** /namespaces/{namespace}/pipelines/{name}/loadtestjobs | 
*LoadtestJobsApi* | [**list_loadtest_seldon_deployment**](docs/LoadtestJobsApi.md#list_loadtest_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/{name}/loadtestjobs | 
*MetricsServerApi* | [**create_metrics_server_seldon_deployment**](docs/MetricsServerApi.md#create_metrics_server_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments/{name}/monitor/metrics-server | 
*MetricsServerApi* | [**delete_metrics_server_seldon_deployment**](docs/MetricsServerApi.md#delete_metrics_server_seldon_deployment) | **DELETE** /namespaces/{namespace}/seldondeployments/{name}/monitor/metrics-server/{detectorName} | 
*MetricsServerApi* | [**list_metrics_server_seldon_deployment**](docs/MetricsServerApi.md#list_metrics_server_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/{name}/monitor/metrics-server | 
*MetricsServerApi* | [**read_metrics_server_seldon_deployment**](docs/MetricsServerApi.md#read_metrics_server_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/{name}/monitor/metrics-server/{detectorName} | 
*ModelMetadataServiceApi* | [**model_metadata_service_create_model_metadata**](docs/ModelMetadataServiceApi.md#model_metadata_service_create_model_metadata) | **POST** /model/metadata | Create a Model Metadata entry.
*ModelMetadataServiceApi* | [**model_metadata_service_delete_model_metadata**](docs/ModelMetadataServiceApi.md#model_metadata_service_delete_model_metadata) | **DELETE** /model/metadata | Delete a Model Metadata entry.
*ModelMetadataServiceApi* | [**model_metadata_service_list_model_metadata**](docs/ModelMetadataServiceApi.md#model_metadata_service_list_model_metadata) | **GET** /model/metadata | List Model Metadata entries.
*ModelMetadataServiceApi* | [**model_metadata_service_list_runtime_metadata_for_model**](docs/ModelMetadataServiceApi.md#model_metadata_service_list_runtime_metadata_for_model) | **GET** /model/metadata/runtime | List Runtime Metadata for all deployments associated with a model.
*ModelMetadataServiceApi* | [**model_metadata_service_update_model_metadata**](docs/ModelMetadataServiceApi.md#model_metadata_service_update_model_metadata) | **PUT** /model/metadata | Update a Model Metadata entry.
*ModelsApi* | [**create_model**](docs/ModelsApi.md#create_model) | **POST** /namespaces/{namespace}/models | 
*ModelsApi* | [**delete_model**](docs/ModelsApi.md#delete_model) | **DELETE** /namespaces/{namespace}/models/{name} | 
*ModelsApi* | [**read_model**](docs/ModelsApi.md#read_model) | **GET** /namespaces/{namespace}/models/{name} | 
*ModelsApi* | [**update_model**](docs/ModelsApi.md#update_model) | **PUT** /namespaces/{namespace}/models/{name} | 
*MonitorApi* | [**seldon_deployment_feature_distributions**](docs/MonitorApi.md#seldon_deployment_feature_distributions) | **POST** /namespaces/{namespace}/seldondeployments/{name}/monitor/featuredistributions | 
*MonitorApi* | [**seldon_deployment_feature_statistics**](docs/MonitorApi.md#seldon_deployment_feature_statistics) | **POST** /namespaces/{namespace}/seldondeployments/{name}/monitor/featurestatistics | 
*MonitorApi* | [**seldon_pipeline_feature_distributions**](docs/MonitorApi.md#seldon_pipeline_feature_distributions) | **POST** /namespaces/{namespace}/pipelines/{name}/monitor/featuredistributions | 
*MonitorApi* | [**seldon_pipeline_feature_statistics**](docs/MonitorApi.md#seldon_pipeline_feature_statistics) | **POST** /namespaces/{namespace}/pipelines/{name}/monitor/featurestatistics | 
*OutlierDetectorApi* | [**create_outlier_detector_seldon_deployment**](docs/OutlierDetectorApi.md#create_outlier_detector_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments/{name}/monitor/outlier-detector | 
*OutlierDetectorApi* | [**create_outlier_detector_seldon_pipeline**](docs/OutlierDetectorApi.md#create_outlier_detector_seldon_pipeline) | **POST** /namespaces/{namespace}/pipelines/{name}/monitor/outlier-detector | 
*OutlierDetectorApi* | [**delete_outlier_detector_seldon_deployment**](docs/OutlierDetectorApi.md#delete_outlier_detector_seldon_deployment) | **DELETE** /namespaces/{namespace}/seldondeployments/{name}/monitor/outlier-detector/{detectorName} | 
*OutlierDetectorApi* | [**delete_outlier_detector_seldon_pipeline**](docs/OutlierDetectorApi.md#delete_outlier_detector_seldon_pipeline) | **DELETE** /namespaces/{namespace}/pipelines/{name}/monitor/outlier-detector/{detectorName} | 
*OutlierDetectorApi* | [**list_outlier_detector_seldon_deployment**](docs/OutlierDetectorApi.md#list_outlier_detector_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/{name}/monitor/outlier-detector | 
*OutlierDetectorApi* | [**list_outlier_detector_seldon_pipeline**](docs/OutlierDetectorApi.md#list_outlier_detector_seldon_pipeline) | **GET** /namespaces/{namespace}/pipelines/{name}/monitor/outlier-detector | 
*OutlierDetectorApi* | [**read_outlier_detector_seldon_deployment**](docs/OutlierDetectorApi.md#read_outlier_detector_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/{name}/monitor/outlier-detector/{detectorName} | 
*OutlierDetectorApi* | [**read_outlier_detector_seldon_pipeline**](docs/OutlierDetectorApi.md#read_outlier_detector_seldon_pipeline) | **GET** /namespaces/{namespace}/pipelines/{name}/monitor/outlier-detector/{detectorName} | 
*PermissionManagementServiceApi* | [**permission_management_service_add_user_to_group**](docs/PermissionManagementServiceApi.md#permission_management_service_add_user_to_group) | **PUT** /iam/users/{username}/groups/{group} | Endpoint is available only when user management is enabled configured - refer to the docs for how to do this. Add user to a group. The caller must have &#x60;write&#x60; permission on &#x60;system/iam&#x60;.
*PermissionManagementServiceApi* | [**permission_management_service_create_group**](docs/PermissionManagementServiceApi.md#permission_management_service_create_group) | **POST** /iam/groups | Endpoint is available only when user management is enabled configured - refer to the docs for how to do this. Create a group. The caller must have &#x60;write&#x60; permission on &#x60;system/iam&#x60;.
*PermissionManagementServiceApi* | [**permission_management_service_create_policy**](docs/PermissionManagementServiceApi.md#permission_management_service_create_policy) | **POST** /iam/policy | Create an authorization policy. The user must have &#x60;grant&#x60; permissions on the resource in the policy.
*PermissionManagementServiceApi* | [**permission_management_service_create_user**](docs/PermissionManagementServiceApi.md#permission_management_service_create_user) | **POST** /iam/users | Endpoint is available only when user management is enabled configured - refer to the docs for how to do this. Create a user. The caller must have &#x60;write&#x60; permission on &#x60;system/iam&#x60;.
*PermissionManagementServiceApi* | [**permission_management_service_delete_group**](docs/PermissionManagementServiceApi.md#permission_management_service_delete_group) | **DELETE** /iam/groups/{name} | Endpoint is available only when user management is enabled configured - refer to the docs for how to do this. Delete a group. The caller must have &#x60;write&#x60; permission on &#x60;system/iam&#x60;.
*PermissionManagementServiceApi* | [**permission_management_service_delete_policy**](docs/PermissionManagementServiceApi.md#permission_management_service_delete_policy) | **DELETE** /iam/policy | Delete an authorization policy. The user must have &#x60;grant&#x60; permissions on the resource in the policy.
*PermissionManagementServiceApi* | [**permission_management_service_delete_user**](docs/PermissionManagementServiceApi.md#permission_management_service_delete_user) | **DELETE** /iam/users/{username} | Endpoint is available only when user management is enabled configured - refer to the docs for how to do this. Delete a user. The caller must have &#x60;write&#x60; permission on &#x60;system/iam&#x60;.
*PermissionManagementServiceApi* | [**permission_management_service_delete_user_from_group**](docs/PermissionManagementServiceApi.md#permission_management_service_delete_user_from_group) | **DELETE** /iam/users/{username}/groups/{group} | Endpoint is available only when user management is enabled configured - refer to the docs for how to do this. Delete user from a group. The caller must have &#x60;write&#x60; permission on &#x60;system/iam&#x60;.
*PermissionManagementServiceApi* | [**permission_management_service_get_group_members**](docs/PermissionManagementServiceApi.md#permission_management_service_get_group_members) | **GET** /iam/groups/{groupName}/members | Endpoint is available only when user management is enabled configured - refer to the docs for how to do this. List all members of a group. The caller must have &#x60;read&#x60; permission on &#x60;system/iam&#x60;.
*PermissionManagementServiceApi* | [**permission_management_service_get_groups**](docs/PermissionManagementServiceApi.md#permission_management_service_get_groups) | **GET** /iam/groups | Endpoint is available only when user management is enabled configured - refer to the docs for how to do this. List all groups. The caller must have &#x60;read&#x60; permission on &#x60;system/iam&#x60;.
*PermissionManagementServiceApi* | [**permission_management_service_get_permissions**](docs/PermissionManagementServiceApi.md#permission_management_service_get_permissions) | **GET** /iam/policy/permissions | List all permissions associated with the given users and groups. A regular user will be able to see only their permissions and the permissions of their groups. A user with &#x60;read&#x60; permission on &#x60;system/iam&#x60; can see all permissions.
*PermissionManagementServiceApi* | [**permission_management_service_get_policy_targets**](docs/PermissionManagementServiceApi.md#permission_management_service_get_policy_targets) | **GET** /iam/policy/targets | List all users and groups who have access to the given resource/action pair. The user calling this endpoint must have &#x60;grant&#x60; access to the given resource.
*PermissionManagementServiceApi* | [**permission_management_service_get_user_groups**](docs/PermissionManagementServiceApi.md#permission_management_service_get_user_groups) | **GET** /iam/users/{username}/groups | Endpoint is available only when user management is enabled configured - refer to the docs for how to do this. List all groups of a user. The caller must have &#x60;read&#x60; permission on &#x60;system/iam&#x60;.
*PermissionManagementServiceApi* | [**permission_management_service_get_users**](docs/PermissionManagementServiceApi.md#permission_management_service_get_users) | **GET** /iam/users | Endpoint is available only when user management is enabled configured - refer to the docs for how to do this. List users. The caller must have &#x60;read&#x60; permission on &#x60;system/iam&#x60;.
*PermissionManagementServiceApi* | [**permission_management_service_reset_user_password**](docs/PermissionManagementServiceApi.md#permission_management_service_reset_user_password) | **POST** /iam/users/{username}/resetPassword | Endpoint is available only when user management is enabled configured - refer to the docs for how to do this. Sends an email to the user with a link to reset their password. The caller must have &#x60;write&#x60; permission on &#x60;system/iam&#x60;.
*PipelinesApi* | [**create_pipeline**](docs/PipelinesApi.md#create_pipeline) | **POST** /namespaces/{namespace}/pipelines | 
*PipelinesApi* | [**create_pipeline_explainer**](docs/PipelinesApi.md#create_pipeline_explainer) | **POST** /namespaces/{namespace}/pipelines/{name}/explainer | 
*PipelinesApi* | [**delete_pipeline**](docs/PipelinesApi.md#delete_pipeline) | **DELETE** /namespaces/{namespace}/pipelines/{name} | 
*PipelinesApi* | [**delete_pipeline_explainer**](docs/PipelinesApi.md#delete_pipeline_explainer) | **DELETE** /namespaces/{namespace}/pipelines/{name}/explainer | 
*PipelinesApi* | [**list_pipeline_models**](docs/PipelinesApi.md#list_pipeline_models) | **GET** /namespaces/{namespace}/pipelines/{name}/models | 
*PipelinesApi* | [**list_pipelines**](docs/PipelinesApi.md#list_pipelines) | **GET** /namespaces/{namespace}/pipelines | 
*PipelinesApi* | [**read_pipeline**](docs/PipelinesApi.md#read_pipeline) | **GET** /namespaces/{namespace}/pipelines/{name} | 
*PipelinesApi* | [**read_pipeline_explainer**](docs/PipelinesApi.md#read_pipeline_explainer) | **GET** /namespaces/{namespace}/pipelines/{name}/explainer | 
*PipelinesApi* | [**update_pipeline**](docs/PipelinesApi.md#update_pipeline) | **PUT** /namespaces/{namespace}/pipelines/{name} | 
*PredictApi* | [**predict_file_seldon_deployment**](docs/PredictApi.md#predict_file_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments/{name}/predictfile | 
*PredictApi* | [**predict_file_seldon_pipeline**](docs/PredictApi.md#predict_file_seldon_pipeline) | **POST** /namespaces/{namespace}/pipelines/{name}/predictfile | 
*PredictApi* | [**predict_seldon_deployment**](docs/PredictApi.md#predict_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments/{name}/predict | 
*PredictApi* | [**read_predict_curl_seldon_deployment**](docs/PredictApi.md#read_predict_curl_seldon_deployment) | **PUT** /namespaces/{namespace}/seldondeployments/{name}/predictcurl | 
*PredictApi* | [**read_predict_curl_seldon_pipeline**](docs/PredictApi.md#read_predict_curl_seldon_pipeline) | **PUT** /namespaces/{namespace}/pipelines/{name}/predictcurl | 
*SecretsServiceApi* | [**secrets_service_create_gcs_bucket_secret**](docs/SecretsServiceApi.md#secrets_service_create_gcs_bucket_secret) | **POST** /secrets/{namespace}/bucket/gcs/{remote} | Creates a GCS bucket secret according to specified parameters.
*SecretsServiceApi* | [**secrets_service_create_rclone_bucket_secret**](docs/SecretsServiceApi.md#secrets_service_create_rclone_bucket_secret) | **POST** /secrets/{namespace}/bucket/rclone/{remote} | Creates a generic rclone bucket secret according to specified parameters.
*SecretsServiceApi* | [**secrets_service_create_registry_secret**](docs/SecretsServiceApi.md#secrets_service_create_registry_secret) | **POST** /secrets/{namespace}/registry/{name} | Creates a registry secret according to specified parameters.
*SecretsServiceApi* | [**secrets_service_create_s3_bucket_secret**](docs/SecretsServiceApi.md#secrets_service_create_s3_bucket_secret) | **POST** /secrets/{namespace}/bucket/s3/{remote} | Creates a S3 bucket secret according to specified parameters.
*SecretsServiceApi* | [**secrets_service_delete_secret**](docs/SecretsServiceApi.md#secrets_service_delete_secret) | **DELETE** /secrets/{namespace}/{secretType}/{name} | Deletes the specified secret.
*SecretsServiceApi* | [**secrets_service_list_secrets**](docs/SecretsServiceApi.md#secrets_service_list_secrets) | **GET** /secrets/{namespace}/{secretType} | Lists the names and metadata of secrets used by Seldon Deploy.
*SeldonDeploymentsApi* | [**create_seldon_deployment**](docs/SeldonDeploymentsApi.md#create_seldon_deployment) | **POST** /namespaces/{namespace}/seldondeployments | 
*SeldonDeploymentsApi* | [**delete_seldon_deployment**](docs/SeldonDeploymentsApi.md#delete_seldon_deployment) | **DELETE** /namespaces/{namespace}/seldondeployments/{name} | 
*SeldonDeploymentsApi* | [**list_seldon_deployments**](docs/SeldonDeploymentsApi.md#list_seldon_deployments) | **GET** /namespaces/{namespace}/seldondeployments | 
*SeldonDeploymentsApi* | [**read_seldon_deployment**](docs/SeldonDeploymentsApi.md#read_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/{name} | 
*SeldonDeploymentsApi* | [**update_seldon_deployment**](docs/SeldonDeploymentsApi.md#update_seldon_deployment) | **PUT** /namespaces/{namespace}/seldondeployments/{name} | 
*SeldonDeploymentsApi* | [**validate_seldon_deployment**](docs/SeldonDeploymentsApi.md#validate_seldon_deployment) | **GET** /namespaces/{namespace}/seldondeployments/validate | 


## Documentation For Models

 - [AWSElasticBlockStoreVolumeSource](docs/AWSElasticBlockStoreVolumeSource.md)
 - [AdvancedConfig](docs/AdvancedConfig.md)
 - [Affinity](docs/Affinity.md)
 - [AlibiExplainerType](docs/AlibiExplainerType.md)
 - [ApplicationLog](docs/ApplicationLog.md)
 - [ApplicationLogsParams](docs/ApplicationLogsParams.md)
 - [ApplicationLogsResponse](docs/ApplicationLogsResponse.md)
 - [AuditLog](docs/AuditLog.md)
 - [AzureDataDiskCachingMode](docs/AzureDataDiskCachingMode.md)
 - [AzureDataDiskKind](docs/AzureDataDiskKind.md)
 - [AzureDiskVolumeSource](docs/AzureDiskVolumeSource.md)
 - [AzureFileVolumeSource](docs/AzureFileVolumeSource.md)
 - [BasicDetectorConfiguration](docs/BasicDetectorConfiguration.md)
 - [BatchJobDefinition](docs/BatchJobDefinition.md)
 - [BatchJobDescription](docs/BatchJobDescription.md)
 - [BatchJobDescriptionList](docs/BatchJobDescriptionList.md)
 - [BatchJobGetResponse](docs/BatchJobGetResponse.md)
 - [BatchJobPostResponse](docs/BatchJobPostResponse.md)
 - [BatchJobsListResponse](docs/BatchJobsListResponse.md)
 - [CSIVolumeSource](docs/CSIVolumeSource.md)
 - [Capabilities](docs/Capabilities.md)
 - [Capability](docs/Capability.md)
 - [CephFSVolumeSource](docs/CephFSVolumeSource.md)
 - [CinderVolumeSource](docs/CinderVolumeSource.md)
 - [ClientIPConfig](docs/ClientIPConfig.md)
 - [ClusterInfo](docs/ClusterInfo.md)
 - [Component](docs/Component.md)
 - [ConditionStatus](docs/ConditionStatus.md)
 - [Conditions](docs/Conditions.md)
 - [ConfigMapEnvSource](docs/ConfigMapEnvSource.md)
 - [ConfigMapKeySelector](docs/ConfigMapKeySelector.md)
 - [ConfigMapProjection](docs/ConfigMapProjection.md)
 - [ConfigMapVolumeSource](docs/ConfigMapVolumeSource.md)
 - [Container](docs/Container.md)
 - [ContainerPort](docs/ContainerPort.md)
 - [ContainerState](docs/ContainerState.md)
 - [ContainerStateRunning](docs/ContainerStateRunning.md)
 - [ContainerStateTerminated](docs/ContainerStateTerminated.md)
 - [ContainerStateWaiting](docs/ContainerStateWaiting.md)
 - [ContainerStatus](docs/ContainerStatus.md)
 - [CrossVersionObjectReference](docs/CrossVersionObjectReference.md)
 - [DNSPolicy](docs/DNSPolicy.md)
 - [Deployment](docs/Deployment.md)
 - [DeploymentFeatureData](docs/DeploymentFeatureData.md)
 - [DeploymentList](docs/DeploymentList.md)
 - [DeploymentSpec](docs/DeploymentSpec.md)
 - [DeploymentStatus](docs/DeploymentStatus.md)
 - [DeploymentStrategy](docs/DeploymentStrategy.md)
 - [DeploymentStrategyType](docs/DeploymentStrategyType.md)
 - [DetectorConfigData](docs/DetectorConfigData.md)
 - [DetectorConfiguration](docs/DetectorConfiguration.md)
 - [DetectorData](docs/DetectorData.md)
 - [DetectorDeploymentConfiguration](docs/DetectorDeploymentConfiguration.md)
 - [DetectorStatus](docs/DetectorStatus.md)
 - [DownwardAPIProjection](docs/DownwardAPIProjection.md)
 - [DownwardAPIVolumeFile](docs/DownwardAPIVolumeFile.md)
 - [DownwardAPIVolumeSource](docs/DownwardAPIVolumeSource.md)
 - [EmptyDirVolumeSource](docs/EmptyDirVolumeSource.md)
 - [Endpoint](docs/Endpoint.md)
 - [EndpointType](docs/EndpointType.md)
 - [EnvFromSource](docs/EnvFromSource.md)
 - [EnvVar](docs/EnvVar.md)
 - [EnvVarSource](docs/EnvVarSource.md)
 - [EphemeralContainer](docs/EphemeralContainer.md)
 - [EphemeralVolumeSource](docs/EphemeralVolumeSource.md)
 - [Error](docs/Error.md)
 - [ExecAction](docs/ExecAction.md)
 - [Experiment](docs/Experiment.md)
 - [ExperimentCandidate](docs/ExperimentCandidate.md)
 - [ExperimentMirror](docs/ExperimentMirror.md)
 - [ExperimentSpec](docs/ExperimentSpec.md)
 - [ExperimentStatus](docs/ExperimentStatus.md)
 - [Explainer](docs/Explainer.md)
 - [ExplainerSpec](docs/ExplainerSpec.md)
 - [ExternalMetricSource](docs/ExternalMetricSource.md)
 - [FCVolumeSource](docs/FCVolumeSource.md)
 - [Fallback](docs/Fallback.md)
 - [FeatureDistribution](docs/FeatureDistribution.md)
 - [FeatureDistributionBucket](docs/FeatureDistributionBucket.md)
 - [FeatureDistributionParameters](docs/FeatureDistributionParameters.md)
 - [FeatureDistributionResponse](docs/FeatureDistributionResponse.md)
 - [FeatureFilter](docs/FeatureFilter.md)
 - [FeatureInteraction](docs/FeatureInteraction.md)
 - [FeatureStatisticsResponse](docs/FeatureStatisticsResponse.md)
 - [FeatureStats](docs/FeatureStats.md)
 - [FeatureStatsBucket](docs/FeatureStatsBucket.md)
 - [FieldsV1](docs/FieldsV1.md)
 - [FileDiff](docs/FileDiff.md)
 - [FinalizerName](docs/FinalizerName.md)
 - [FlexVolumeSource](docs/FlexVolumeSource.md)
 - [FlockerVolumeSource](docs/FlockerVolumeSource.md)
 - [GCEPersistentDiskVolumeSource](docs/GCEPersistentDiskVolumeSource.md)
 - [GitRepoVolumeSource](docs/GitRepoVolumeSource.md)
 - [GlusterfsVolumeSource](docs/GlusterfsVolumeSource.md)
 - [HPAScalingPolicy](docs/HPAScalingPolicy.md)
 - [HPAScalingPolicyType](docs/HPAScalingPolicyType.md)
 - [HPAScalingRules](docs/HPAScalingRules.md)
 - [HTTPGetAction](docs/HTTPGetAction.md)
 - [HTTPHeader](docs/HTTPHeader.md)
 - [Handler](docs/Handler.md)
 - [HealthCheckInfo](docs/HealthCheckInfo.md)
 - [HorizontalPodAutoscalerBehavior](docs/HorizontalPodAutoscalerBehavior.md)
 - [HorizontalPodAutoscalerConfig](docs/HorizontalPodAutoscalerConfig.md)
 - [HostAlias](docs/HostAlias.md)
 - [HostPathType](docs/HostPathType.md)
 - [HostPathVolumeSource](docs/HostPathVolumeSource.md)
 - [IPFamily](docs/IPFamily.md)
 - [ISCSIVolumeSource](docs/ISCSIVolumeSource.md)
 - [IntOrString](docs/IntOrString.md)
 - [JoinType](docs/JoinType.md)
 - [KeyToPath](docs/KeyToPath.md)
 - [LabelSelector](docs/LabelSelector.md)
 - [LabelSelectorOperator](docs/LabelSelectorOperator.md)
 - [LabelSelectorRequirement](docs/LabelSelectorRequirement.md)
 - [Lifecycle](docs/Lifecycle.md)
 - [ListMeta](docs/ListMeta.md)
 - [LocalObjectReference](docs/LocalObjectReference.md)
 - [Logger](docs/Logger.md)
 - [LoggerMode](docs/LoggerMode.md)
 - [LoggingSpec](docs/LoggingSpec.md)
 - [ManagedFieldsEntry](docs/ManagedFieldsEntry.md)
 - [ManagedFieldsOperationType](docs/ManagedFieldsOperationType.md)
 - [Message](docs/Message.md)
 - [MetricSourceType](docs/MetricSourceType.md)
 - [MetricSpec](docs/MetricSpec.md)
 - [MetricTargetType](docs/MetricTargetType.md)
 - [Model](docs/Model.md)
 - [ModelSpec](docs/ModelSpec.md)
 - [ModelStatus](docs/ModelStatus.md)
 - [MonitorInputData](docs/MonitorInputData.md)
 - [MountPropagationMode](docs/MountPropagationMode.md)
 - [NFSVolumeSource](docs/NFSVolumeSource.md)
 - [Namespace](docs/Namespace.md)
 - [NamespaceCondition](docs/NamespaceCondition.md)
 - [NamespaceConditionType](docs/NamespaceConditionType.md)
 - [NamespacePhase](docs/NamespacePhase.md)
 - [NamespaceSpec](docs/NamespaceSpec.md)
 - [NamespaceStatus](docs/NamespaceStatus.md)
 - [NodeAffinity](docs/NodeAffinity.md)
 - [NodePhase](docs/NodePhase.md)
 - [NodeSelector](docs/NodeSelector.md)
 - [NodeSelectorOperator](docs/NodeSelectorOperator.md)
 - [NodeSelectorRequirement](docs/NodeSelectorRequirement.md)
 - [NodeSelectorTerm](docs/NodeSelectorTerm.md)
 - [ObjectFieldSelector](docs/ObjectFieldSelector.md)
 - [ObjectMeta](docs/ObjectMeta.md)
 - [ObjectMetricSource](docs/ObjectMetricSource.md)
 - [OwnerReference](docs/OwnerReference.md)
 - [Parameter](docs/Parameter.md)
 - [ParameterSpec](docs/ParameterSpec.md)
 - [ParmeterType](docs/ParmeterType.md)
 - [PersistentVolumeAccessMode](docs/PersistentVolumeAccessMode.md)
 - [PersistentVolumeClaimSpec](docs/PersistentVolumeClaimSpec.md)
 - [PersistentVolumeClaimTemplate](docs/PersistentVolumeClaimTemplate.md)
 - [PersistentVolumeClaimVolumeSource](docs/PersistentVolumeClaimVolumeSource.md)
 - [PersistentVolumeMode](docs/PersistentVolumeMode.md)
 - [PhotonPersistentDiskVolumeSource](docs/PhotonPersistentDiskVolumeSource.md)
 - [Pipeline](docs/Pipeline.md)
 - [PipelineBatch](docs/PipelineBatch.md)
 - [PipelineOutput](docs/PipelineOutput.md)
 - [PipelineSpec](docs/PipelineSpec.md)
 - [PipelineStatus](docs/PipelineStatus.md)
 - [PipelineStep](docs/PipelineStep.md)
 - [Pod](docs/Pod.md)
 - [PodAffinity](docs/PodAffinity.md)
 - [PodAffinityTerm](docs/PodAffinityTerm.md)
 - [PodAntiAffinity](docs/PodAntiAffinity.md)
 - [PodCondition](docs/PodCondition.md)
 - [PodConditionType](docs/PodConditionType.md)
 - [PodDNSConfig](docs/PodDNSConfig.md)
 - [PodDNSConfigOption](docs/PodDNSConfigOption.md)
 - [PodFSGroupChangePolicy](docs/PodFSGroupChangePolicy.md)
 - [PodIP](docs/PodIP.md)
 - [PodList](docs/PodList.md)
 - [PodPhase](docs/PodPhase.md)
 - [PodQOSClass](docs/PodQOSClass.md)
 - [PodReadinessGate](docs/PodReadinessGate.md)
 - [PodSecurityContext](docs/PodSecurityContext.md)
 - [PodSpec](docs/PodSpec.md)
 - [PodStatus](docs/PodStatus.md)
 - [PodTemplateSpec](docs/PodTemplateSpec.md)
 - [PodsMetricSource](docs/PodsMetricSource.md)
 - [PortworxVolumeSource](docs/PortworxVolumeSource.md)
 - [PredictiveUnit](docs/PredictiveUnit.md)
 - [PredictiveUnitImplementation](docs/PredictiveUnitImplementation.md)
 - [PredictiveUnitMethod](docs/PredictiveUnitMethod.md)
 - [PredictiveUnitType](docs/PredictiveUnitType.md)
 - [PredictorSpec](docs/PredictorSpec.md)
 - [PreemptionPolicy](docs/PreemptionPolicy.md)
 - [PreferredSchedulingTerm](docs/PreferredSchedulingTerm.md)
 - [Probe](docs/Probe.md)
 - [ProcMountType](docs/ProcMountType.md)
 - [ProjectedVolumeSource](docs/ProjectedVolumeSource.md)
 - [ProtobufAny](docs/ProtobufAny.md)
 - [ProtobufNullValue](docs/ProtobufNullValue.md)
 - [Protocol](docs/Protocol.md)
 - [PullPolicy](docs/PullPolicy.md)
 - [Quantity](docs/Quantity.md)
 - [QuobyteVolumeSource](docs/QuobyteVolumeSource.md)
 - [RBDVolumeSource](docs/RBDVolumeSource.md)
 - [ResourceFieldSelector](docs/ResourceFieldSelector.md)
 - [ResourceList](docs/ResourceList.md)
 - [ResourceMetricSource](docs/ResourceMetricSource.md)
 - [ResourceName](docs/ResourceName.md)
 - [ResourceRequirements](docs/ResourceRequirements.md)
 - [ResourceType](docs/ResourceType.md)
 - [RestartPolicy](docs/RestartPolicy.md)
 - [RollingUpdateDeployment](docs/RollingUpdateDeployment.md)
 - [RpcStatus](docs/RpcStatus.md)
 - [SELinuxOptions](docs/SELinuxOptions.md)
 - [SSL](docs/SSL.md)
 - [ScaleIOVolumeSource](docs/ScaleIOVolumeSource.md)
 - [ScaleTriggers](docs/ScaleTriggers.md)
 - [ScaledObjectAuthRef](docs/ScaledObjectAuthRef.md)
 - [ScalingPolicySelect](docs/ScalingPolicySelect.md)
 - [SeccompProfile](docs/SeccompProfile.md)
 - [SeccompProfileType](docs/SeccompProfileType.md)
 - [SecretEnvSource](docs/SecretEnvSource.md)
 - [SecretKeySelector](docs/SecretKeySelector.md)
 - [SecretProjection](docs/SecretProjection.md)
 - [SecretVolumeSource](docs/SecretVolumeSource.md)
 - [SecurityContext](docs/SecurityContext.md)
 - [SeldonAddressable](docs/SeldonAddressable.md)
 - [SeldonDeployment](docs/SeldonDeployment.md)
 - [SeldonDeploymentList](docs/SeldonDeploymentList.md)
 - [SeldonDeploymentSpec](docs/SeldonDeploymentSpec.md)
 - [SeldonDeploymentStatus](docs/SeldonDeploymentStatus.md)
 - [SeldonExperiment](docs/SeldonExperiment.md)
 - [SeldonHpaSpec](docs/SeldonHpaSpec.md)
 - [SeldonModel](docs/SeldonModel.md)
 - [SeldonModelList](docs/SeldonModelList.md)
 - [SeldonPdbSpec](docs/SeldonPdbSpec.md)
 - [SeldonPipeline](docs/SeldonPipeline.md)
 - [SeldonPipelineList](docs/SeldonPipelineList.md)
 - [SeldonPodSpec](docs/SeldonPodSpec.md)
 - [SeldonScaledObjectSpec](docs/SeldonScaledObjectSpec.md)
 - [ServerType](docs/ServerType.md)
 - [Service](docs/Service.md)
 - [ServiceAccountTokenProjection](docs/ServiceAccountTokenProjection.md)
 - [ServiceAffinity](docs/ServiceAffinity.md)
 - [ServiceExternalTrafficPolicyType](docs/ServiceExternalTrafficPolicyType.md)
 - [ServiceList](docs/ServiceList.md)
 - [ServicePort](docs/ServicePort.md)
 - [ServiceSpec](docs/ServiceSpec.md)
 - [ServiceStatus](docs/ServiceStatus.md)
 - [ServiceType](docs/ServiceType.md)
 - [SessionAffinityConfig](docs/SessionAffinityConfig.md)
 - [StatusState](docs/StatusState.md)
 - [StorageMedium](docs/StorageMedium.md)
 - [StorageOSVolumeSource](docs/StorageOSVolumeSource.md)
 - [SvcOrchSpec](docs/SvcOrchSpec.md)
 - [Sysctl](docs/Sysctl.md)
 - [TCPSocketAction](docs/TCPSocketAction.md)
 - [TaintEffect](docs/TaintEffect.md)
 - [TerminationMessagePolicy](docs/TerminationMessagePolicy.md)
 - [Time](docs/Time.md)
 - [Toleration](docs/Toleration.md)
 - [TolerationOperator](docs/TolerationOperator.md)
 - [TopologySpreadConstraint](docs/TopologySpreadConstraint.md)
 - [Transport](docs/Transport.md)
 - [Type](docs/Type.md)
 - [TypedLocalObjectReference](docs/TypedLocalObjectReference.md)
 - [UID](docs/UID.md)
 - [URIScheme](docs/URIScheme.md)
 - [UnsatisfiableConstraintAction](docs/UnsatisfiableConstraintAction.md)
 - [UserInfo](docs/UserInfo.md)
 - [V1AddUserToGroupResponse](docs/V1AddUserToGroupResponse.md)
 - [V1ArtifactType](docs/V1ArtifactType.md)
 - [V1CreateGCSBucketSecretResponse](docs/V1CreateGCSBucketSecretResponse.md)
 - [V1CreateGroupRequest](docs/V1CreateGroupRequest.md)
 - [V1CreateGroupResponse](docs/V1CreateGroupResponse.md)
 - [V1CreatePolicyResponse](docs/V1CreatePolicyResponse.md)
 - [V1CreateRcloneBucketSecretResponse](docs/V1CreateRcloneBucketSecretResponse.md)
 - [V1CreateRegistrySecretResponse](docs/V1CreateRegistrySecretResponse.md)
 - [V1CreateS3BucketSecretResponse](docs/V1CreateS3BucketSecretResponse.md)
 - [V1CreateUserRequest](docs/V1CreateUserRequest.md)
 - [V1CreateUserResponse](docs/V1CreateUserResponse.md)
 - [V1DataType](docs/V1DataType.md)
 - [V1DefaultProtocol](docs/V1DefaultProtocol.md)
 - [V1DeleteGroupResponse](docs/V1DeleteGroupResponse.md)
 - [V1DeletePolicyResponse](docs/V1DeletePolicyResponse.md)
 - [V1DeleteSecretResponse](docs/V1DeleteSecretResponse.md)
 - [V1DeleteUserFromGroupResponse](docs/V1DeleteUserFromGroupResponse.md)
 - [V1DeleteUserResponse](docs/V1DeleteUserResponse.md)
 - [V1DeploymentStatus](docs/V1DeploymentStatus.md)
 - [V1DeploymentType](docs/V1DeploymentType.md)
 - [V1FeatureCategorySchema](docs/V1FeatureCategorySchema.md)
 - [V1FeatureSchema](docs/V1FeatureSchema.md)
 - [V1FeatureType](docs/V1FeatureType.md)
 - [V1FiringAlert](docs/V1FiringAlert.md)
 - [V1GetGroupMembersResponse](docs/V1GetGroupMembersResponse.md)
 - [V1GetGroupsResponse](docs/V1GetGroupsResponse.md)
 - [V1GetPermissionsResponse](docs/V1GetPermissionsResponse.md)
 - [V1GetPolicyTargetsResponse](docs/V1GetPolicyTargetsResponse.md)
 - [V1GetUserGroupsResponse](docs/V1GetUserGroupsResponse.md)
 - [V1GetUsersResponse](docs/V1GetUsersResponse.md)
 - [V1Group](docs/V1Group.md)
 - [V1GroupPolicy](docs/V1GroupPolicy.md)
 - [V1ListAlertsResponse](docs/V1ListAlertsResponse.md)
 - [V1ListSecretsResponse](docs/V1ListSecretsResponse.md)
 - [V1Model](docs/V1Model.md)
 - [V1ModelMetadataCreateResponse](docs/V1ModelMetadataCreateResponse.md)
 - [V1ModelMetadataDeleteResponse](docs/V1ModelMetadataDeleteResponse.md)
 - [V1ModelMetadataListResponse](docs/V1ModelMetadataListResponse.md)
 - [V1ModelMetadataUpdateResponse](docs/V1ModelMetadataUpdateResponse.md)
 - [V1Policy](docs/V1Policy.md)
 - [V1PredictionSchema](docs/V1PredictionSchema.md)
 - [V1RcloneConfig](docs/V1RcloneConfig.md)
 - [V1ResetUserPasswordResponse](docs/V1ResetUserPasswordResponse.md)
 - [V1ResourceActionPair](docs/V1ResourceActionPair.md)
 - [V1RuntimeDefaults](docs/V1RuntimeDefaults.md)
 - [V1RuntimeMetadata](docs/V1RuntimeMetadata.md)
 - [V1RuntimeMetadataListResponse](docs/V1RuntimeMetadataListResponse.md)
 - [V1S3Credentials](docs/V1S3Credentials.md)
 - [V1Secret](docs/V1Secret.md)
 - [V1SecretType](docs/V1SecretType.md)
 - [V1TriggerTestAlertResponse](docs/V1TriggerTestAlertResponse.md)
 - [V1User](docs/V1User.md)
 - [V1UserPolicy](docs/V1UserPolicy.md)
 - [VersionInfo](docs/VersionInfo.md)
 - [Volume](docs/Volume.md)
 - [VolumeDevice](docs/VolumeDevice.md)
 - [VolumeMount](docs/VolumeMount.md)
 - [VolumeProjection](docs/VolumeProjection.md)
 - [VsphereVirtualDiskVolumeSource](docs/VsphereVirtualDiskVolumeSource.md)
 - [WeightedPodAffinityTerm](docs/WeightedPodAffinityTerm.md)
 - [WindowsSecurityContextOptions](docs/WindowsSecurityContextOptions.md)


## Documentation For Authorization


## OAuth2

- **Type**: OAuth
- **Flow**: password
- **Authorization URL**: 
- **Scopes**: 
 - **email**: 
 - **groups**: 
 - **openid**: 
 - **profile**: 


## Author

hello@seldon.io

