import openai 
import os
from dotenv import load_dotenv

# API Key
load_dotenv()
OPEN_API_KEY = os.getenv("OPEN_API_KEY") 
openai.api_key = OPEN_API_KEY


def generate_prompt(input: str) -> str:
    prompt_template = (
        f"""You will be given a string generated by AI. Reformat to make it more human-like. 
        % AI INPUT: {input} \n\n % YOUR RESPONSE: """
    )
    return prompt_template


def make_more_human(input: str, model="text-davinci-003", max_tokens=300, temperature=0.6):
    
    prompt1 = generate_prompt(input)
    response = openai.Completion.create(
        model=model,
        prompt=prompt1,
        max_tokens=max_tokens,
        temperature=temperature
    )

    result1 = response["choices"][0]["text"]

    # Run it through again to make it even more human-like (lol)
    prompt2 = generate_prompt(result1)

    response2 = openai.Completion.create(
        model=model,
        prompt=prompt2,
        max_tokens=max_tokens,
        temperature=temperature
    )

    with open("clean_gpt_output.txt", "w") as f:
        f.write(response2["choices"][0].get("text"))
