from typing import Any

from googleapiclient.errors import HttpError as HttpError

LOGGER: Any
dump_request_response: bool

class Model:
    def request(
        self, headers: Any, path_params: Any, query_params: Any, body_value: Any
    ) -> None: ...
    def response(self, resp: Any, content: Any) -> None: ...

class BaseModel(Model):
    accept: Any = ...
    content_type: Any = ...
    no_content_response: Any = ...
    alt_param: Any = ...
    def request(
        self, headers: Any, path_params: Any, query_params: Any, body_value: Any
    ): ...
    def response(self, resp: Any, content: Any): ...
    def serialize(self, body_value: Any) -> None: ...
    def deserialize(self, content: Any) -> None: ...

class JsonModel(BaseModel):
    accept: str = ...
    content_type: str = ...
    alt_param: str = ...
    def __init__(self, data_wrapper: bool = ...) -> None: ...
    def serialize(self, body_value: Any): ...
    def deserialize(self, content: Any): ...
    @property
    def no_content_response(self): ...

class RawModel(JsonModel):
    accept: str = ...
    content_type: str = ...
    alt_param: Any = ...
    def deserialize(self, content: Any): ...
    @property
    def no_content_response(self): ...

class MediaModel(JsonModel):
    accept: str = ...
    content_type: str = ...
    alt_param: str = ...
    def deserialize(self, content: Any): ...
    @property
    def no_content_response(self): ...

class ProtocolBufferModel(BaseModel):
    accept: str = ...
    content_type: str = ...
    alt_param: str = ...
    def __init__(self, protocol_buffer: Any) -> None: ...
    def serialize(self, body_value: Any): ...
    def deserialize(self, content: Any): ...
    @property
    def no_content_response(self): ...

def makepatch(original: Any, modified: Any): ...
