'''
MIT License

Copyright (c) [2022] [Temitope Ajayi]

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

'''

t2solute_format_specification = {
    'title': [['title'], ['82s']],
    'options': [['ISPIA', 'itersfa', 'ISOLVC', 'NGAMM', 'NGAS1', 'ichdump', 'kcpl', 'Ico2h2o', 'nu'], ['6.1d'] * 9],
    'constraints': [['SL1MIN', 'rcour', 'STIMAX', 'CNFACT'], ['1.2e', '12.1f', '10.1d', '10.1d']],
    'readio': [['name', 'nad', 'density', 'porosity',
                'k1', 'k2', 'k3', 'conductivity', 'specific_heat'],
               ['5s', '5d'] + ['10.4e'] * 7],
    'weight_diffu': [['ITIME', 'WUPC', 'DFFUN', 'DFFUNG'],
                     ['6.1f', '9.1f', '12.4e', '12.4e']],
    'tolerance': [['MAXITPTR', 'TOLTR', 'MAXITPCH', 'TOLCH', 'NOT-USED', 'NOT-USED', 'TOLDC', 'TOLDR'],
                  ['6d', '15.4e', '8d'] + ['15.4e'] * 5],
    'printout': [
        ['NWTI', 'NWNOD', 'NWCOM', 'NWMIN', 'NWAQ', 'NWADS', 'NWEXC', 'iconflag', 'minflag', 'igasflag'],
        ['6d'] * 10],
    'nodes': [
        ['ELEM(a5)'],
        ['5s']],
    'primary_species': [
        ['number_pH'],
        ['20.1d']],
    'minerals': [
        ['rate_constant', 'activationEnergy', 'number_of_species', 'specie_name', 'species_exp'],
        ['30.4e', '5.1f', '5.1d', '10s', '5.1f']],
    'aqueous_species': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['10.3e'] * 7],
    'adsorption_species': [['max_iterations', 'print_level', 'max_timesteps',
                            'max_duration', 'print_interval',
                            '_option_str', 'diff0', 'texp', 'be'],
                           ['2d'] * 2 + ['4d'] * 3 + ['24s'] + ['10.3e'] * 3],
    'exchange_species': [['max_iterations', 'print_level', 'max_timesteps',
                          'max_duration', 'print_interval', '_option_str', 'texp', 'be'],
                         ['2d'] * 2 + ['4d'] * 3 + ['24s'] + ['10.3e'] * 2],
    'chemical_zones': [['IZIWDF', 'IZBWDF', 'IZMIDF', 'IZGSDF', 'IZADDF', 'IZEXDF', 'IZPPDF', 'IZKDDF', 'IZBGDF'],
                       ['4.1d'] + ['10.1d'] * 8],
    'chemical_zones_to_nodes': [
        ['ELEM(a5)', 'NSEQ', 'NADD', 'IZIWDF', 'IZBWDF', 'IZMIDF', 'IZGSDF', 'IZADDF', 'IZEXDF', 'IZPPDF', 'IZKDDF',
         'IZBGDF'],
        ['5s', '10.1d', '13.1d', '14.1d', '8.1d', '8.1d', '10.1d', '10.1d', '10.1d', '10.1d', '10.1d', '10.1d']],
}

t2chemical_format_specification = {
    'title': [['title'], ['80s']],
    'primary_aqueous': [['specie', 'diffusion_status'], ['8.8s', '8.1d']],
    'aqueous_kinetics': [['name', 'nad', 'density', 'porosity',
                          'k1', 'k2', 'k3', 'conductivity', 'specific_heat'],
                         ['5s', '5d'] + ['10.4e'] * 7],
    'aqueous_complex': [['compressibility', 'expansivity', 'dry_conductivity',
                         'tortuosity', 'klinkenberg', 'xkd3', 'xkd4'],
                        ['10.4e'] * 7],
    'minerals': [['name', 'type_of_mineral', 'type_of_KC', 'solid_solution', 'dry_grid'], ['25.25s'] + ['10.1d'] * 4],
    'minerals1.1': [
        ['rate_constant', 'ratepH', 'exponentN', 'exponentTheta', 'activationEnergy', 'coefA', 'coefB', 'coefC',
         'init_volume', 'prep_law'],
        ['20.4e', '5.1d', '7.3f', '7.3f', '5.1f'] + ['5.1d'] * 3 + ['10.e', '5.1d']],
    'minerals1.1.1a': [
        ['logQKgap', 'tempGap1', 'tempGap2'],
        ['5.1f'] * 3],
    'minerals1.1.2a': [
        ['number_pH'],
        ['20.1d']],
    'minerals1.1.2': [
        ['rate_constant', 'activationEnergy', 'number_of_species', 'specie_name', 'species_exp'],
        ['30.4e', '5.1f', '5.1d', '10s', '10.3f']],
    'gases': [['name', 'fugacity_flag'], ['6s', '4.1d']],
    'surface_complexes': [['max_iterations', 'print_level', 'max_timesteps',
                           'max_duration', 'print_interval',
                           '_option_str', 'diff0', 'texp', 'be'],
                          ['2d'] * 2 + ['4d'] * 3 + ['24s'] + ['10.3e'] * 3],
    'decay': [['max_iterations', 'print_level', 'max_timesteps',
               'max_duration', 'print_interval', '_option_str', 'texp', 'be'],
              ['2d'] * 2 + ['4d'] * 3 + ['24s'] + ['10.3e'] * 2],
    'exchange_cations': [['tstart', 'tstop', 'const_timestep', 'max_timestep',
                          'print_block', '', 'gravity', 'timestep_reduction', 'scale'],
                         ['10.3e'] * 4 + ['5s', '5x'] + ['10.4e'] * 3],
    'water_comp': [['num_initial_water', 'num_boundary_water'],
                   ['1.1d', '5.1d']],
    'water_comp1': [['water_index', 'water_temp', 'water_pressure'],
                    ['1.1d', '10.3f', '15.3f']],
    'water_comp2': [['species_name', 'icon', 'nrguess', 'ctot', 'nameq', 'qksat'],
                    ['1.8s', '10.1d', '15.4e', '15.4e', '10.2s', '10.2f']],
    'mineral_zone': [['number_of_zones'],
                     ['1d']],
    'mineral_zone1': [['zone_index'],
                      ['1d']],
    'mineral_zone2': [['mineral_name', 'initial_volume_fraction', 'mineral_condition'],
                      ['1.25s', '10.4f', '5d']],
    'mineral_zone2.1': [['radius', 'reactive_surface_area', 'units'],
                        ['10.1e', '10.2f', '5d']],
    'gas_zone': [['num_initial_gas', 'num_boundary_gas'],
                 ['1.1d', '5.1d']],
    'gas_zone1': [['gas_index'],
                  ['1.1d', ]],
    'gas_zone2': [['name', 'partial_pressure'], ['6s', '15.2f']],
    'perm_poro_zone': [['law', 'aparam', 'bparam'], ['4.1d', '15.3e', '15.3e']],
    'surface_adsorption_zone': [['num_components', 'num_equations', 'num_phases',
                                 'num_secondary_parameters', 'num_inc'], ['5d'] * 5],
    'linear_equilibrium_zone': [['num_components', 'num_equations', 'num_phases',
                                 'num_secondary_parameters', 'eos'], ['5d'] * 4 + ['4s']],
    'cation_exchange_zone': [['type', 'epsilon', 'max_iterations', 'gauss', 'num_orthog'],
                             ['2d', '10.4e', '4d', '1d', '4d']]
}

t2bio_format_specification = {
    'title': [['title'], ['80s']],
    'simulator': [['simulator'], ['80s']],
    'rocks1': [['name', 'nad', 'density', 'porosity',
                'k1', 'k2', 'k3', 'conductivity', 'specific_heat'],
               ['5s', '5d'] + ['10.4e'] * 7],
    'rocks1.1': [['compressibility', 'expansivity', 'dry_conductivity',
                  'tortuosity', 'klinkenberg', 'xkd3', 'xkd4'],
                 ['10.4e'] * 7],
    'rocks1.2': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['10.3e'] * 7],
    'rocks1.3': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['10.3e'] * 7],
    'param1_autough2': [['max_iterations', 'print_level', 'max_timesteps',
                         'max_duration', 'print_interval',
                         '_option_str', 'diff0', 'texp', 'be'],
                        ['2d'] * 2 + ['4d'] * 3 + ['24s'] + ['10.3e'] * 3],
    'param1': [['max_iterations', 'print_level', 'max_timesteps',
                'max_duration', 'print_interval', '_option_str', 'texp', 'be'],
               ['2d'] * 2 + ['4d'] * 3 + ['24s'] + ['10.3e'] * 2],
    'param2': [['tstart', 'tstop', 'const_timestep', 'max_timestep',
                'print_block', '', 'gravity', 'timestep_reduction', 'scale'],
               ['10.3e'] * 4 + ['5s', '5x'] + ['10.4e'] * 3],
    'param3': [['relative_error', 'absolute_error', 'pivot', 'upstream_weight',
                'newton_weight', 'derivative_increment'],
               ['10.4e'] * 6],
    'param4': [['phase_index'],
               ['5d']],
    '_more_option_str': [['_more_option_str'], ['21s']],
    'timestep': [['timestep'] * 8, ['10.4e'] * 8],
    'multi': [['num_components', 'num_equations', 'num_phases',
               'num_secondary_parameters', 'num_inc'], ['5d'] * 5],
    'multi_autough2': [['num_components', 'num_equations', 'num_phases',
                        'num_secondary_parameters', 'eos'], ['5d'] * 4 + ['4s']],
    'lineq': [['type', 'epsilon', 'max_iterations', 'gauss', 'num_orthog'],
              ['2d', '10.4e', '4d', '1d', '4d']],
    'chemp': [['nhc'], ['5d']],
    'chemp1': [['hcnames'], ['20s']],
    'chemp1.1': [['tcrit', 'pcrit', 'zcrit', 'omega', 'dipolm'], ['10.4f'] * 5],
    'chemp1.2': [['tboil', 'vpa', 'vpb', 'vpc', 'vpd'], ['10.4f'] * 5],
    'chemp1.3': [['amwt', 'cpa', 'cpb', 'cpc', 'cpd'], ['10.3e'] * 5],
    'chemp1.4': [['rhoref', 'tdenref', 'difvo', 'tdifref', 'texpo'], ['10.3e'] * 5],
    'chemp1.5': [['vloa', 'vlob', 'vloc', 'vlod', 'volcrit'], ['10.3e'] * 5],
    'chemp1.6': [['sola', 'solb', 'solc', 'sold'], ['10.3e'] * 4],
    'chemp1.7': [['ock', 'fox', 'alam'], ['10.3e'] * 3],
    'ncgas': [['ncg'], ['5d']],
    'ncgas1': [['ncginp'], ['10s']],
    'biodg': [['imonod', 'icflag', 'bfac', 'null1', 'sw1', 'sw2', 'wea', 'wsub'],
              ['5d', '5d', '10.0e', '10s'] + ['10.2f'] * 4],
    'biodg1': [['nproc'], ['5d']],
    'biodg1.1': [['nsproc', 'ibio', 'mumax', 'yield', 'ncomp', 'nnc', 'nhal', 'entb'],
                 ['10d', '10d', '10.4e', '10.2f'] + ['10d'] * 4],
    'biodg1.1.1': [['is1', 'ks1', 'is2', 'ks2', 'is3', 'ks3', 'is4', 'ks4'],
                   ['10d', '10.4e', '10d', '10.4e', '10d', '10.4e', '10d', '10.4e']],
    'biodg1.1.2': [['ic1', 'kc1', 'ic2', 'kc2', 'ic3', 'kc3', 'ic4', 'kc4'],
                   ['10d', '10.4e', '10d', '10.4e', '10d', '10.4e', '10d', '10.4e']],
    'biodg1.1.3': [['inc1', 'knc1', 'inc2', 'knc2', 'inc3', 'knc3', 'inc4', 'knc4'],
                   ['10d', '10.4e', '10d', '10.4e', '10d', '10.4e', '10d', '10.4e']],
    'biodg1.1.4': [['ih1', 'kh1', 'ih2', 'kh2', 'ih3', 'kh3', 'ih4', 'kh4'],
                   ['10d', '10.4e', '10d', '10.4e', '10d', '10.4e', '10d', '10.4e']],
    'biodg1.1.5': [['upt1', 'upt2', 'upt3', 'upt4', 'upt5', 'upt6', 'upt7', 'upt8'],
                   ['10.2f'] * 8],
    'biodg2': [['npop', 'ibflag'], ['5d', '5d']],
    'biodg2.1': [['bai', 'ba0', 'tmax', 'death', 'akbio'], ['10.4e', '10.4e', '10.1f', '10.4e', '10.4e']],
    'solids1': [['ntr'], ['5d']],
    'solids2': [['ntrinp', 'amwtm', 'ockm', 'alamm'], ['10s', '10.4e', '10.4e', '10.4e']],
    'default_incons': [['incon'] * 4, ['20.14e'] * 4],
    'output_times1': [['num_times_specified', 'num_times', 'max_timestep', 'time_increment'],
                      ['5d'] * 2 + ['10.4e'] * 2],
    'output_times2': [['time'] * 8, ['10.4e'] * 8],
    'relative_permeability': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['10.3e'] * 7],
    'capillarity': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['10.3e'] * 7],
    'blocks': [['name', 'nseq', 'nadd', 'rocktype', 'volume',
                'ahtx', 'pmx', 'x', 'y', 'z'],
               ['5s', '5d', '5d', '5s'] + ['10.4e'] * 3 + ['10.3e'] * 3],
    'connections': [['block1', 'block2', 'nseq', 'nad1', 'nad2',
                     'direction', 'distance1', 'distance2', 'area', 'dircos', 'sigma'],
                    ['5s'] * 2 + ['5d'] * 4 + ['10.4e'] * 3 + ['10.7f', '10.3e']],
    'generator': [['block', 'name', 'nseq', 'nadd', 'nads', 'ltab',
                   '', 'type', 'itab', 'gx', 'ex', 'hg', 'fg'],
                  ['5s'] * 2 + ['5d'] * 3 + ['5d', '5x', '4s', '1s'] + ['10.3e'] * 4],
    'generation_times': [['time'] * 4, ['14.7e'] * 4],
    'generation_rates': [['rate'] * 4, ['14.7e'] * 4],
    'generation_enthalpy': [['enthalpy'] * 4, ['14.7e'] * 4],
    'short': [['', 'frequency'], ['5x', '2d']],
    'incon1': [['block', 'nseq', 'nadd', 'porosity'], ['5s'] + ['5d'] * 2 + ['15.9e']],
    'incon2': [['incon'] * 4, ['20.14e'] * 4],
    'solver': [['type', '', 'z_precond', '', 'o_precond', 'relative_max_iterations', 'closure'],
               ['1d', '2x', '2s', '3x', '2s'] + ['10.4e'] * 2],
    'indom2': [['indom'] * 4, ['20.13e'] * 4],
    'diffusion': [['diff'] * 8, ['10.3e'] * 8],
    'selec1': [['int_selec'] * 16, ['5d'] * 16],
    'selec2': [['float_selec'] * 8, ['10.3e'] * 8],
    'radii1': [['nrad'], ['5d']],
    'radii2': [['radius'] * 8, ['10.4e'] * 8],
    'equid': [['nequ', '', 'dr'], ['5d', '5x', '10.4e']],
    'logar': [['nlog', '', 'rlog', 'dr'], ['5d', '5x'] + ['10.4e'] * 2],
    'layer1': [['nlay'], ['5d']],
    'layer2': [['layer'] * 8, ['10.4e'] * 8],
    'xyz1': [['deg'], ['10.4e']],
    'xyz2': [['ntype', '', 'no', 'del'], ['2s', '3x', '5d', '10.4e']],
    'xyz3': [['deli'] * 8, ['10.4e'] * 8],
    'minc': [['part', 'type', '', 'dual'], ['5s'] * 2 + ['5x', '5s']],
    'part1': [['num_continua', 'nvol', 'where'] + ['spacing'] * 7,
              ['3d'] * 2 + ['-4s'] + ['10.4e'] * 7],
    'part2': [['vol'] * 8, ['10.4e'] * 8]
}

t2bio_extra_precision_format_specification = {
    'rocks1': [['name', 'nad', 'density', 'porosity', 'k1', 'k2', 'k3',
                'conductivity', 'specific_heat'],
               ['5s', '5d'] + ['15.8e'] * 7],
    'rocks1.1': [['compressibility', 'expansivity', 'dry_conductivity',
                  'tortuosity', 'klinkenberg', 'xkd3', 'xkd4'], ['15.8e'] * 7],
    'rocks1.2': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['15.8e'] * 7],
    'rocks1.3': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['15.8e'] * 7],
    'blocks': [['name', 'nseq', 'nadd', 'rocktype', 'volume',
                'ahtx', 'pmx', 'x', 'y', 'z'],
               ['5s', '5d', '5d', '5s'] + ['15.8e'] * 3 + ['15.8e'] * 3],
    'connections': [['block1', 'block2', 'nseq', 'nad1', 'nad2',
                     'direction', 'distance1', 'distance2', 'area', 'dircos', 'sigma'],
                    ['5s'] * 2 + ['5d'] * 4 + ['15.8e'] * 3 + ['15.8f', '15.8e']],
    'relative_permeability': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['15.8e'] * 7],
    'capillarity': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['15.8e'] * 7],
    'generator': [['block', 'name', 'nseq', 'nadd', 'nads', 'ltab',
                   '', 'type', 'itab', 'gx', 'ex', 'hg', 'fg'],
                  ['5s'] * 2 + ['5d'] * 3 + ['5d', '5x', '4s', '1s'] + ['15.8e'] * 4],
    'generation_times': [['time'] * 4, ['15.8e'] * 4],
    'generation_rates': [['rate'] * 4, ['15.8e'] * 4],
    'generation_enthalpy': [['enthalpy'] * 4, ['15.8e'] * 4]}


t2react_format_specification = {
    'title': [['title'], ['80s']],
    'simulator': [['simulator'], ['80s']],
    'rocks1': [['name', 'nad', 'density', 'porosity',
                'k1', 'k2', 'k3', 'conductivity', 'specific_heat'],
               ['5s', '5d'] + ['10.4e'] * 7],
    'rocks1.1': [['compressibility', 'expansivity', 'dry_conductivity',
                  'tortuosity', 'klinkenberg', 'xkd3', 'xkd4'],
                 ['10.4e'] * 7],
    'rocks1.2': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['10.3e'] * 7],
    'rocks1.3': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['10.3e'] * 7],
    'param1_autough2': [['max_iterations', 'print_level', 'max_timesteps',
                         'max_duration', 'print_interval',
                         '_option_str', 'diff0', 'texp', 'be'],
                        ['2d'] * 2 + ['4d'] * 3 + ['24s'] + ['10.3e'] * 3],
    'param1': [['max_iterations', 'print_level', 'max_timesteps',
                'max_duration', 'print_interval', '_option_str', 'texp', 'be'],
               ['2d'] * 2 + ['4d'] * 3 + ['24s'] + ['10.3e'] * 2],
    'param2': [['tstart', 'tstop', 'const_timestep', 'max_timestep',
                'print_block', '', 'gravity', 'timestep_reduction', 'scale'],
               ['10.3e'] * 4 + ['5s', '5x'] + ['10.4e'] * 3],
    'param3': [['relative_error', 'absolute_error', 'pivot', 'upstream_weight',
                'newton_weight', 'derivative_increment'],
               ['10.4e'] * 6],
    'REACT': [
        ['MOPR1', 'MOPR2', 'MOPR3', 'MOPR4', 'MOPR5', 'MOPR6', 'MOPR7', 'MOPR8', 'MOPR9', 'MOPR10', 'MOPR11', 'MOPR12',
         'MOPR13', 'MOPR14', 'MOPR15', 'MOPR16', 'MOPR17', 'MOPR1', ],
        ['1d'] * 17],
    '_more_option_str': [['_more_option_str'], ['21s']],
    'timestep': [['timestep'] * 8, ['10.4e'] * 8],
    'multi': [['num_components', 'num_equations', 'num_phases',
               'num_secondary_parameters', 'num_inc'], ['5d'] * 5],
    'multi_autough2': [['num_components', 'num_equations', 'num_phases',
                        'num_secondary_parameters', 'eos'], ['5d'] * 4 + ['4s']],
    'lineq': [['type', 'epsilon', 'max_iterations', 'gauss', 'num_orthog'],
              ['2d', '10.4e', '4d', '1d', '4d']],
    'default_incons': [['incon'] * 4, ['20.14e'] * 4],
    'output_times1': [['num_times_specified', 'num_times', 'max_timestep', 'time_increment'],
                      ['5d'] * 2 + ['10.4e'] * 2],
    'output_times2': [['time'] * 8, ['10.4e'] * 8],
    'relative_permeability': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['10.3e'] * 7],
    'capillarity': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['10.3e'] * 7],
    'blocks': [['name', 'nseq', 'nadd', 'rocktype', 'volume',
                'ahtx', 'pmx', 'x', 'y', 'z'],
               ['5s', '5d', '5d', '5s'] + ['10.4e'] * 3 + ['10.3e'] * 3],
    'connections': [['block1', 'block2', 'nseq', 'nad1', 'nad2',
                     'direction', 'distance1', 'distance2', 'area', 'dircos', 'sigma'],
                    ['5s'] * 2 + ['5d'] * 4 + ['10.4e'] * 3 + ['10.7f', '10.3e']],
    'generator': [['block', 'name', 'nseq', 'nadd', 'nads', 'ltab',
                   '', 'type', 'itab', 'gx', 'ex', 'hg', 'fg'],
                  ['5s'] * 2 + ['5d'] * 3 + ['5d', '5x', '4s', '1s'] + ['10.3e'] * 4],
    'generation_times': [['time'] * 4, ['14.7e'] * 4],
    'generation_rates': [['rate'] * 4, ['14.7e'] * 4],
    'generation_enthalpy': [['enthalpy'] * 4, ['14.7e'] * 4],
    'short': [['', 'frequency'], ['5x', '2d']],
    'incon1': [['block', 'nseq', 'nadd', 'porosity'], ['5s'] + ['5d'] * 2 + ['15.9e']],
    'incon2': [['incon'] * 4, ['20.14e'] * 4],
    'solver': [['type', '', 'z_precond', '', 'o_precond', 'relative_max_iterations', 'closure'],
               ['1d', '2x', '2s', '3x', '2s'] + ['10.4e'] * 2],
    'indom2': [['indom'] * 4, ['20.13e'] * 4],
    'diffusion': [['diff'] * 8, ['10.3e'] * 8],
    'selec1': [['int_selec'] * 16, ['5d'] * 16],
    'selec2': [['float_selec'] * 8, ['10.3e'] * 8],
    'radii1': [['nrad'], ['5d']],
    'radii2': [['radius'] * 8, ['10.4e'] * 8],
    'equid': [['nequ', '', 'dr'], ['5d', '5x', '10.4e']],
    'logar': [['nlog', '', 'rlog', 'dr'], ['5d', '5x'] + ['10.4e'] * 2],
    'layer1': [['nlay'], ['5d']],
    'layer2': [['layer'] * 8, ['10.4e'] * 8],
    'xyz1': [['deg'], ['10.4e']],
    'xyz2': [['ntype', '', 'no', 'del'], ['2s', '3x', '5d', '10.4e']],
    'xyz3': [['deli'] * 8, ['10.4e'] * 8],
    'minc': [['part', 'type', '', 'dual'], ['5s'] * 2 + ['5x', '5s']],
    'part1': [['num_continua', 'nvol', 'where'] + ['spacing'] * 7,
              ['3d'] * 2 + ['-4s'] + ['10.4e'] * 7],
    'part2': [['vol'] * 8, ['10.4e'] * 8]
}

t2react_extra_precision_format_specification = {
    'rocks1': [['name', 'nad', 'density', 'porosity', 'k1', 'k2', 'k3',
                'conductivity', 'specific_heat'],
               ['5s', '5d'] + ['15.8e'] * 7],
    'rocks1.1': [['compressibility', 'expansivity', 'dry_conductivity',
                  'tortuosity', 'klinkenberg', 'xkd3', 'xkd4'], ['15.8e'] * 7],
    'rocks1.2': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['15.8e'] * 7],
    'rocks1.3': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['15.8e'] * 7],
    'blocks': [['name', 'nseq', 'nadd', 'rocktype', 'volume',
                'ahtx', 'pmx', 'x', 'y', 'z'],
               ['5s', '5d', '5d', '5s'] + ['15.8e'] * 3 + ['15.8e'] * 3],
    'connections': [['block1', 'block2', 'nseq', 'nad1', 'nad2',
                     'direction', 'distance1', 'distance2', 'area', 'dircos', 'sigma'],
                    ['5s'] * 2 + ['5d'] * 4 + ['15.8e'] * 3 + ['15.8f', '15.8e']],
    'relative_permeability': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['15.8e'] * 7],
    'capillarity': [['type', ''] + ['parameter'] * 7, ['5d', '5x'] + ['15.8e'] * 7],
    'generator': [['block', 'name', 'nseq', 'nadd', 'nads', 'ltab',
                   '', 'type', 'itab', 'gx', 'ex', 'hg', 'fg'],
                  ['5s'] * 2 + ['5d'] * 3 + ['5d', '5x', '4s', '1s'] + ['15.8e'] * 4],
    'generation_times': [['time'] * 4, ['15.8e'] * 4],
    'generation_rates': [['rate'] * 4, ['15.8e'] * 4],
    'generation_enthalpy': [['enthalpy'] * 4, ['15.8e'] * 4]}
