# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['conf_diff', 'conf_diff.examples', 'conf_diff.tests']

package_data = \
{'': ['*'],
 'conf_diff': ['.git/*',
               '.git/hooks/*',
               '.git/info/*',
               '.git/logs/*',
               '.git/logs/refs/heads/*',
               '.git/logs/refs/remotes/origin/*',
               '.git/objects/03/*',
               '.git/objects/04/*',
               '.git/objects/06/*',
               '.git/objects/0a/*',
               '.git/objects/0c/*',
               '.git/objects/0f/*',
               '.git/objects/17/*',
               '.git/objects/18/*',
               '.git/objects/1a/*',
               '.git/objects/1b/*',
               '.git/objects/1c/*',
               '.git/objects/20/*',
               '.git/objects/21/*',
               '.git/objects/23/*',
               '.git/objects/25/*',
               '.git/objects/26/*',
               '.git/objects/2d/*',
               '.git/objects/31/*',
               '.git/objects/33/*',
               '.git/objects/36/*',
               '.git/objects/37/*',
               '.git/objects/3a/*',
               '.git/objects/3b/*',
               '.git/objects/3d/*',
               '.git/objects/3e/*',
               '.git/objects/3f/*',
               '.git/objects/42/*',
               '.git/objects/46/*',
               '.git/objects/47/*',
               '.git/objects/49/*',
               '.git/objects/4b/*',
               '.git/objects/50/*',
               '.git/objects/51/*',
               '.git/objects/52/*',
               '.git/objects/54/*',
               '.git/objects/55/*',
               '.git/objects/57/*',
               '.git/objects/59/*',
               '.git/objects/5a/*',
               '.git/objects/5f/*',
               '.git/objects/65/*',
               '.git/objects/67/*',
               '.git/objects/68/*',
               '.git/objects/6a/*',
               '.git/objects/6d/*',
               '.git/objects/6e/*',
               '.git/objects/73/*',
               '.git/objects/74/*',
               '.git/objects/76/*',
               '.git/objects/79/*',
               '.git/objects/7b/*',
               '.git/objects/7e/*',
               '.git/objects/81/*',
               '.git/objects/86/*',
               '.git/objects/89/*',
               '.git/objects/8a/*',
               '.git/objects/8c/*',
               '.git/objects/8e/*',
               '.git/objects/95/*',
               '.git/objects/9e/*',
               '.git/objects/9f/*',
               '.git/objects/a0/*',
               '.git/objects/a1/*',
               '.git/objects/a9/*',
               '.git/objects/aa/*',
               '.git/objects/ac/*',
               '.git/objects/ad/*',
               '.git/objects/af/*',
               '.git/objects/b0/*',
               '.git/objects/b7/*',
               '.git/objects/b9/*',
               '.git/objects/bc/*',
               '.git/objects/bf/*',
               '.git/objects/c2/*',
               '.git/objects/c4/*',
               '.git/objects/c5/*',
               '.git/objects/c6/*',
               '.git/objects/c7/*',
               '.git/objects/c8/*',
               '.git/objects/ca/*',
               '.git/objects/cb/*',
               '.git/objects/cc/*',
               '.git/objects/cf/*',
               '.git/objects/d5/*',
               '.git/objects/d9/*',
               '.git/objects/da/*',
               '.git/objects/df/*',
               '.git/objects/e1/*',
               '.git/objects/e3/*',
               '.git/objects/e6/*',
               '.git/objects/e7/*',
               '.git/objects/e9/*',
               '.git/objects/eb/*',
               '.git/objects/ec/*',
               '.git/objects/ef/*',
               '.git/objects/f0/*',
               '.git/objects/f3/*',
               '.git/objects/f7/*',
               '.git/objects/f9/*',
               '.git/objects/fa/*',
               '.git/objects/fb/*',
               '.git/objects/ff/*',
               '.git/refs/heads/*',
               '.git/refs/remotes/origin/*',
               '.github/workflows/*',
               '.tox/*',
               '.tox/dist/*',
               'dist/conf_diff-0.1.0-py3-none-any.whl',
               'dist/conf_diff-0.1.0-py3-none-any.whl',
               'dist/conf_diff-0.1.0-py3-none-any.whl',
               'dist/conf_diff-0.1.0-py3-none-any.whl',
               'dist/conf_diff-0.1.0-py3-none-any.whl',
               'dist/conf_diff-0.1.0-py3-none-any.whl',
               'dist/conf_diff-0.1.0-py3-none-any.whl',
               'dist/conf_diff-0.1.0-py3-none-any.whl',
               'dist/conf_diff-0.1.0-py3-none-any.whl',
               'dist/conf_diff-0.1.0-py3-none-any.whl',
               'dist/conf_diff-0.1.0-py3-none-any.whl',
               'dist/conf_diff-0.1.0-py3-none-any.whl',
               'dist/conf_diff-0.1.0.tar.gz',
               'dist/conf_diff-0.1.0.tar.gz',
               'dist/conf_diff-0.1.0.tar.gz',
               'dist/conf_diff-0.1.0.tar.gz',
               'dist/conf_diff-0.1.0.tar.gz',
               'dist/conf_diff-0.1.0.tar.gz',
               'dist/conf_diff-0.1.0.tar.gz',
               'dist/conf_diff-0.1.0.tar.gz',
               'dist/conf_diff-0.1.0.tar.gz',
               'dist/conf_diff-0.1.0.tar.gz',
               'dist/conf_diff-0.1.0.tar.gz',
               'dist/conf_diff-0.1.0.tar.gz',
               'dist/conf_diff-0.1.1-py3-none-any.whl',
               'dist/conf_diff-0.1.1-py3-none-any.whl',
               'dist/conf_diff-0.1.1-py3-none-any.whl',
               'dist/conf_diff-0.1.1-py3-none-any.whl',
               'dist/conf_diff-0.1.1-py3-none-any.whl',
               'dist/conf_diff-0.1.1-py3-none-any.whl',
               'dist/conf_diff-0.1.1-py3-none-any.whl',
               'dist/conf_diff-0.1.1-py3-none-any.whl',
               'dist/conf_diff-0.1.1-py3-none-any.whl',
               'dist/conf_diff-0.1.1-py3-none-any.whl',
               'dist/conf_diff-0.1.1-py3-none-any.whl',
               'dist/conf_diff-0.1.1-py3-none-any.whl',
               'dist/conf_diff-0.1.1.tar.gz',
               'dist/conf_diff-0.1.1.tar.gz',
               'dist/conf_diff-0.1.1.tar.gz',
               'dist/conf_diff-0.1.1.tar.gz',
               'dist/conf_diff-0.1.1.tar.gz',
               'dist/conf_diff-0.1.1.tar.gz',
               'dist/conf_diff-0.1.1.tar.gz',
               'dist/conf_diff-0.1.1.tar.gz',
               'dist/conf_diff-0.1.1.tar.gz',
               'dist/conf_diff-0.1.1.tar.gz',
               'dist/conf_diff-0.1.1.tar.gz',
               'dist/conf_diff-0.1.1.tar.gz',
               'dist/conf_diff-0.2.0-py3-none-any.whl',
               'dist/conf_diff-0.2.0-py3-none-any.whl',
               'dist/conf_diff-0.2.0-py3-none-any.whl',
               'dist/conf_diff-0.2.0-py3-none-any.whl',
               'dist/conf_diff-0.2.0-py3-none-any.whl',
               'dist/conf_diff-0.2.0-py3-none-any.whl',
               'dist/conf_diff-0.2.0-py3-none-any.whl',
               'dist/conf_diff-0.2.0-py3-none-any.whl',
               'dist/conf_diff-0.2.0-py3-none-any.whl',
               'dist/conf_diff-0.2.0-py3-none-any.whl',
               'dist/conf_diff-0.2.0-py3-none-any.whl',
               'dist/conf_diff-0.2.0-py3-none-any.whl',
               'dist/conf_diff-0.2.0.tar.gz',
               'dist/conf_diff-0.2.0.tar.gz',
               'dist/conf_diff-0.2.0.tar.gz',
               'dist/conf_diff-0.2.0.tar.gz',
               'dist/conf_diff-0.2.0.tar.gz',
               'dist/conf_diff-0.2.0.tar.gz',
               'dist/conf_diff-0.2.0.tar.gz',
               'dist/conf_diff-0.2.0.tar.gz',
               'dist/conf_diff-0.2.0.tar.gz',
               'dist/conf_diff-0.2.0.tar.gz',
               'dist/conf_diff-0.2.0.tar.gz',
               'dist/conf_diff-0.2.0.tar.gz',
               'dist/conf_diff-0.3.0-py3-none-any.whl',
               'dist/conf_diff-0.3.0-py3-none-any.whl',
               'dist/conf_diff-0.3.0-py3-none-any.whl',
               'dist/conf_diff-0.3.0-py3-none-any.whl',
               'dist/conf_diff-0.3.0-py3-none-any.whl',
               'dist/conf_diff-0.3.0-py3-none-any.whl',
               'dist/conf_diff-0.3.0-py3-none-any.whl',
               'dist/conf_diff-0.3.0-py3-none-any.whl',
               'dist/conf_diff-0.3.0-py3-none-any.whl',
               'dist/conf_diff-0.3.0-py3-none-any.whl',
               'dist/conf_diff-0.3.0-py3-none-any.whl',
               'dist/conf_diff-0.3.0-py3-none-any.whl',
               'dist/conf_diff-0.3.0.tar.gz',
               'dist/conf_diff-0.3.0.tar.gz',
               'dist/conf_diff-0.3.0.tar.gz',
               'dist/conf_diff-0.3.0.tar.gz',
               'dist/conf_diff-0.3.0.tar.gz',
               'dist/conf_diff-0.3.0.tar.gz',
               'dist/conf_diff-0.3.0.tar.gz',
               'dist/conf_diff-0.3.0.tar.gz',
               'dist/conf_diff-0.3.0.tar.gz',
               'dist/conf_diff-0.3.0.tar.gz',
               'dist/conf_diff-0.3.0.tar.gz',
               'dist/conf_diff-0.3.0.tar.gz',
               'dist/conf_diff-0.4.0-py3-none-any.whl',
               'dist/conf_diff-0.4.0-py3-none-any.whl',
               'dist/conf_diff-0.4.0-py3-none-any.whl',
               'dist/conf_diff-0.4.0-py3-none-any.whl',
               'dist/conf_diff-0.4.0-py3-none-any.whl',
               'dist/conf_diff-0.4.0-py3-none-any.whl',
               'dist/conf_diff-0.4.0-py3-none-any.whl',
               'dist/conf_diff-0.4.0-py3-none-any.whl',
               'dist/conf_diff-0.4.0-py3-none-any.whl',
               'dist/conf_diff-0.4.0-py3-none-any.whl',
               'dist/conf_diff-0.4.0-py3-none-any.whl',
               'dist/conf_diff-0.4.0-py3-none-any.whl',
               'dist/conf_diff-0.4.0.tar.gz',
               'dist/conf_diff-0.4.0.tar.gz',
               'dist/conf_diff-0.4.0.tar.gz',
               'dist/conf_diff-0.4.0.tar.gz',
               'dist/conf_diff-0.4.0.tar.gz',
               'dist/conf_diff-0.4.0.tar.gz',
               'dist/conf_diff-0.4.0.tar.gz',
               'dist/conf_diff-0.4.0.tar.gz',
               'dist/conf_diff-0.4.0.tar.gz',
               'dist/conf_diff-0.4.0.tar.gz',
               'dist/conf_diff-0.4.0.tar.gz',
               'dist/conf_diff-0.4.0.tar.gz',
               'dist/conf_diff-0.5.0-py3-none-any.whl',
               'dist/conf_diff-0.5.0-py3-none-any.whl',
               'dist/conf_diff-0.5.0-py3-none-any.whl',
               'dist/conf_diff-0.5.0-py3-none-any.whl',
               'dist/conf_diff-0.5.0-py3-none-any.whl',
               'dist/conf_diff-0.5.0-py3-none-any.whl',
               'dist/conf_diff-0.5.0-py3-none-any.whl',
               'dist/conf_diff-0.5.0-py3-none-any.whl',
               'dist/conf_diff-0.5.0-py3-none-any.whl',
               'dist/conf_diff-0.5.0-py3-none-any.whl',
               'dist/conf_diff-0.5.0-py3-none-any.whl',
               'dist/conf_diff-0.5.0-py3-none-any.whl',
               'dist/conf_diff-0.5.0.tar.gz',
               'dist/conf_diff-0.5.0.tar.gz',
               'dist/conf_diff-0.5.0.tar.gz',
               'dist/conf_diff-0.5.0.tar.gz',
               'dist/conf_diff-0.5.0.tar.gz',
               'dist/conf_diff-0.5.0.tar.gz',
               'dist/conf_diff-0.5.0.tar.gz',
               'dist/conf_diff-0.5.0.tar.gz',
               'dist/conf_diff-0.5.0.tar.gz',
               'dist/conf_diff-0.5.0.tar.gz',
               'dist/conf_diff-0.5.0.tar.gz',
               'dist/conf_diff-0.5.0.tar.gz',
               'images/*']}

modules = \
['conf_diff']
install_requires = \
['colorama>=0.4.4,<0.5.0']

extras_require = \
{':python_version >= "3.8"': ['importlib-metadata>=1.0,<2.0']}

setup_kwargs = {
    'name': 'conf-diff',
    'version': '0.6.0',
    'description': 'compare configuration files',
    'long_description': '[![license](https://img.shields.io/github/license/abatilo/actions-poetry.svg)](https://github.com/muhammad-rafi/conf_diff/blob/main/LICENSE)\n[![Pypi](https://img.shields.io/pypi/v/conf_diff.svg)](https://pypi.org/project/conf-diff/) \n[![Build Status](https://github.com/muhammad-rafi/conf_diff/actions/workflows/main.yml/badge.svg)](https://github.com/muhammad-rafi/conf_diff/actions)\n\n# Introduction\n\nThis module is built to provide you the configuration comparison between two configuration files and generates configuration differences either on the terminal or create a HTML output file based on the parameter provided to the module.\n\nNote: This module is built on the top of the Python built-in difflib module but modified to show you the colourful output and customised HTML template.\n\n## Features\n\n* Shows the configuration differences on the terminal window with colourful output.\n* Generate a HTML output file as a comparison report.\n\n## Installation\n\nInstall this module from PyPI:\n\n```sh\n\npip install conf-diff\n\n```\n\n## Usage:\n\n### Prerequisite\nAs this module compares the configuration difference between two config file, so we need to have two configuration files should be present in the same directory where you are running the script from or specify the absolute path for the configuration files. e.g. `"/Users/rafi/sandbox-nxos-1.cisco.com_before_config.cfg"` and `"/Users/rafi/sandbox-nxos-1.cisco.com_after_config.cfg"\n`\n\nYou may use either .cfg or .txt file extensions.\n\nIn the below example, I am using two running configuration files from the Cisco always-on NXOS Sandbox, assuming that, `sandbox-nxos-1.cisco.com_before_config.cfg` was taken before the change and ` sandbox-nxos-1.cisco.com_after_config.cfg` after the change, and we want to see the configuration diffrence between them. You may name the filenames as you like or add the timestamps.\n\nImport the module on your python script and instantiate a class object \'delta\'\n\n```python\n\nimport conf_diff\n\n# Instantiate a class object \'delta\'\ndelta = conf_diff.ConfDiff("sandbox-nxos-1.cisco.com_before_config.cfg", "sandbox-nxos-1.cisco.com_after_config.cfg")\n\n# Display the output of the diff on the terminal \nprint(delta.diff())\n\n```\n\nAbove will generate a configuration difference on the terminal. \n\n![App Screenshot](https://github.com/muhammad-rafi/conf_diff/blob/main/images/cli_output.png)\n\nTo generate a html output file, add third parameter as the expected output file name. e.g. `"html_diff_output.html"`\n\n```python\n\n # Instantiate a class object \'delta\'\ndelta = conf_diff.ConfDiff("sandbox-nxos-1.cisco.com_before_config.cfg", "sandbox-nxos-1.cisco.com_after_config.cfg", "html_diff_output.html")\n\n# Generates a `html_diff_output.html` in your current directory unless expected full path is specified.\ndelta.diff()\n\n```\n\nSee the screenshot below for the `html_diff_output.html`\n\n![App Screenshot](https://github.com/muhammad-rafi/conf_diff/blob/main/images/html_output_file.png)\n\n### Example\nIn this example, I am running a script with well known \'netmiko\' library and taking a backup of running config before and after the change. Then compare the configuration difference between these config files. See the [example](https://github.com/muhammad-rafi/conf_diff/tree/main/examples) directory. \n\n\n```python\n\nfrom netmiko import ConnectHandler\nimport conf_diff\nimport time\n\n# List of hosts or devices\nhosts_list = [\'sandbox-nxos-1.cisco.com\']\n\n# For loop to run through all the devices in the \'hosts_list\'\nfor host in hosts_list:\n    device = {\n        "device_type": "cisco_nxos",\n        "ip": host,\n        "username": "admin",\n        "password": "Admin_1234!",\n        "port": "22",\n    }\n\n    # Creating a network connection with the device\n    print(f"**** Connecting to {device[\'ip\']} **** ...\\n")\n    net_connect = ConnectHandler(**device)\n\n    # Sending \'show\' command to the device to take first configuration snapshot before updating the device\n    print(f"Connected to {device[\'ip\']}, Sending commands ...\\n")\n    current_config = net_connect.send_command("show running-config")\n\n    print(f"Saving pre-configuration change output for {device[\'ip\']} ...\\n")\n\n    # Opening a file in write mode to save the configuration before the change\n    with open(f"{device[\'ip\']}_before_config.cfg", "w") as f:\n        f.write(current_config)\n\n    print(f"{device[\'ip\']}_before_config.cfg has been saved ...\\n")\n\n    # List of configuration commands to the device\n    print(f"Updating the configuration for {device[\'ip\']}...\\n")\n    config_commands = [\'interface Ethernet1/22-28\',\n                       \'description testing python script\',\n                       \'switchport mode trunk\',\n                       \'switchport trunk allowed vlan 512,654,278\'\n                       ]\n\n    # Sending above configuration commands to updathe the device configuration\n    config_update = net_connect.send_config_set(config_commands)\n\n    # Sleep for 2 sec before take another configuration snapshot\n    time.sleep(2)\n\n    # Sending \'show\' command to the device again to take another configuration snapshot after the change\n    print(f"Saving post-configuration change output for {device[\'ip\']} ...\\n")\n    updated_config = net_connect.send_command("show running-config")\n\n    # Opening a file in write mode to save the configuration after the change\n    with open(f"{device[\'ip\']}_after_config.cfg", "w") as f:\n        f.write(updated_config)\n\n    print(f"{device[\'ip\']}_after_config.cfg has been saved ...\\n")\n\n    # Teardown the network connection with the device\n    net_connect.disconnect()\n\n    # To print the colourful output on the terminal\n    config_diff = conf_diff.ConfDiff(f"{device[\'ip\']}_before_config.cfg", f"{device[\'ip\']}_after_config.cfg")\n    print(config_diff.diff())\n\n    # To generate a HTML output file\n    html_diff = conf_diff.ConfDiff(f"{device[\'ip\']}_before_config.cfg", f"{device[\'ip\']}_after_config.cfg", "html_diff_output.html")\n    html_diff.diff()\n\n```\n\n## Issues\nPlease raise an issue or pull request if you find something wrong with this module.\n\n## Authors\n[Muhammad Rafi](https://github.com/muhammad-rafi)\n\n## License\nThe source code is released under the MIT License.\n',
    'author': 'Muhammad Rafi',
    'author_email': 'murafi@cisco.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/muhammad-rafi/conf_diff',
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
