from distutils.core import setup

with open('README.md') as f:
    long_description = f.read()

setup(
  name = 'OpenPermID',         # How you named your package folder (MyLib)
  packages = ['OpenPermID'],   # Chose the same as "name"
  version = '0.2',      # Start with a small number and increase it with every change you make
  license='MIT',        # Chose a license from here: https://help.github.com/articles/licensing-a-repository
  description = 'Open PermID APIs: Record Matching, Entity Search, and Intelligent Tagging',   # Give a short description about your library
  long_description=long_description,
  long_description_content_type='text/markdown',
  author = 'Jirapongse Phuriphanvichai',                   # Type in your name
  author_email = 'jirapongse.phuriphanvichai@refinitiv.com',      # Type in your E-Mail
  url = 'https://github.com/Refinitiv-API-Samples/Article.OpenPermID.Python.APIs',   # Provide either the link to your github or to your website
  download_url = 'https://github.com/Refinitiv-API-Samples/Article.OpenPermID.Python.APIs/archive/v_02.tar.gz',    # I explain this later on
  keywords = ['Open PermID', 'Calais', 'Tagging'],   # Keywords that define your package best
  install_requires=[            # I get to this in a second
          'requests',                             
          'pandas'          
      ],
  classifiers=[
    'Development Status :: 4 - Beta',      # Chose either "3 - Alpha", "4 - Beta" or "5 - Production/Stable" as the current state of your package
    'Intended Audience :: Developers',      # Define that your audience are developers
    'Topic :: Software Development :: Build Tools',
    'License :: OSI Approved :: MIT License',   # Again, pick a license
    'Programming Language :: Python :: 3',      #Specify which pyhton versions that you want to support
    'Programming Language :: Python :: 3.4',
    'Programming Language :: Python :: 3.5',
    'Programming Language :: Python :: 3.6',
  ],
)
