/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.Graph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BoundedBFSIterator<T>
implements Iterator<T> {
    final ArrayList<T> Q = new ArrayList();
    final HashSet<T> visited = HashSetFactory.make();
    private int index = 0;
    protected Graph<T> G;
    private final int k;
    private final int[] boundary;
    private int currentHops = 0;

    public BoundedBFSIterator(Graph<T> G, T N, int k) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (k < 0) {
            throw new IllegalArgumentException("invalid k : " + k);
        }
        this.k = k;
        this.boundary = new int[k];
        this.init(G, new NonNullSingletonIterator<T>(N));
    }

    public BoundedBFSIterator(Graph<T> G, Iterator<? extends T> nodes, int k) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (k < 0) {
            throw new IllegalArgumentException("invalid k: " + k);
        }
        this.k = k;
        this.boundary = new int[k];
        this.init(G, nodes);
    }

    private void init(Graph<T> G, Iterator<? extends T> nodes) {
        this.G = G;
        if (G.getNumberOfNodes() == 0) {
            return;
        }
        while (nodes.hasNext()) {
            T o = nodes.next();
            if (!this.visited.add(o)) continue;
            this.Q.add(o);
        }
        this.index = 0;
        if (this.Q.size() > 0) {
            T current = this.Q.get(0);
            this.visitChildren(current);
        }
    }

    private void visitChildren(T N) {
        if (this.currentHops == this.k) {
            return;
        }
        if (this.boundary[this.currentHops] == 0) {
            this.boundary[this.currentHops] = this.Q.size();
        }
        for (T child : Iterator2Iterable.make(this.getConnected(N))) {
            if (!this.visited.add(child)) continue;
            this.Q.add(child);
        }
    }

    @Override
    public boolean hasNext() {
        return this.Q.size() > this.index;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.Q.get(this.index);
        ++this.index;
        if (this.currentHops < this.k && this.index == this.boundary[this.currentHops]) {
            ++this.currentHops;
        }
        if (this.hasNext()) {
            T N = this.Q.get(this.index);
            this.visitChildren(N);
        }
        return result;
    }

    protected Iterator<? extends T> getConnected(T n) {
        return this.G.getSuccNodes(n);
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getCurrentHops() {
        return this.currentHops;
    }
}

