/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public class SSAReturnInstruction
extends SSAInstruction {
    private final int result;
    private final boolean isPrimitive;

    public SSAReturnInstruction(int iindex, int result, boolean isPrimitive) {
        super(iindex);
        this.result = result;
        this.isPrimitive = isPrimitive;
    }

    public SSAReturnInstruction(int iindex) {
        super(iindex);
        this.result = -1;
        this.isPrimitive = false;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        if (this.result == -1) {
            return insts.ReturnInstruction(this.iIndex());
        }
        if (uses != null && uses.length != 1) {
            throw new IllegalArgumentException("invalid uses.  must have exactly one use.");
        }
        return insts.ReturnInstruction(this.iIndex(), uses == null ? this.result : uses[0], this.isPrimitive);
    }

    @Override
    public String toString(SymbolTable table) {
        if (this.result == -1) {
            return "return";
        }
        return "return " + this.getValueString(table, this.result);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitReturn(this);
    }

    @Override
    public int getNumberOfUses() {
        return this.result == -1 ? 0 : 1;
    }

    @Override
    public int getUse(int j) {
        if (j != 0) {
            throw new IllegalArgumentException("illegal j: " + j);
        }
        return this.result;
    }

    public boolean returnsPrimitiveType() {
        return this.isPrimitive;
    }

    public int getResult() {
        return this.result;
    }

    public boolean returnsVoid() {
        return this.result == -1;
    }

    @Override
    public int hashCode() {
        return this.result * 8933;
    }

    @Override
    public boolean isFallThrough() {
        return false;
    }
}

