/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT.analysis;

import com.ibm.wala.shrike.shrikeBT.analysis.ClassHierarchyProvider;
import java.util.HashMap;
import java.util.Iterator;

public final class ClassHierarchyStore
implements ClassHierarchyProvider {
    private static final String[] noClasses = new String[0];
    private final HashMap<String, ClassInfo> contents = new HashMap();

    public boolean containsClass(String cl) {
        return this.contents.containsKey(cl);
    }

    public void setClassInfo(String cl, boolean isInterface, boolean isFinal, String superClass, String[] superInterfaces) throws IllegalArgumentException {
        if (superClass != null && superClass.equals(cl)) {
            throw new IllegalArgumentException("Class " + cl + " cannot be its own superclass");
        }
        this.contents.put(cl, new ClassInfo(isInterface, isFinal, superClass, superInterfaces));
    }

    public void removeClassInfo(String cl) {
        this.contents.remove(cl);
    }

    public Iterator<String> iterateOverClasses() {
        return this.contents.keySet().iterator();
    }

    @Override
    public String getSuperClass(String cl) {
        ClassInfo info = this.contents.get(cl);
        return info == null ? null : info.superClass;
    }

    @Override
    public String[] getSuperInterfaces(String cl) {
        ClassInfo info = this.contents.get(cl);
        return info == null ? null : info.superInterfaces;
    }

    @Override
    public String[] getSubClasses(String cl) {
        ClassInfo info = this.contents.get(cl);
        return info == null || !info.isFinal ? null : noClasses;
    }

    @Override
    public int isInterface(String cl) {
        ClassInfo info = this.contents.get(cl);
        return info == null ? 3 : (info.isInterface ? 2 : 1);
    }

    static final class ClassInfo {
        final boolean isInterface;
        final boolean isFinal;
        final String superClass;
        final String[] superInterfaces;

        ClassInfo(boolean isInterface, boolean isFinal, String superClass, String[] superInterfaces) {
            this.isInterface = isInterface;
            this.isFinal = isFinal;
            this.superClass = superClass;
            this.superInterfaces = superInterfaces;
        }
    }
}

