/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT;

import com.ibm.wala.shrike.shrikeBT.Constants;
import com.ibm.wala.shrike.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.Instruction;
import com.ibm.wala.shrike.shrikeBT.Util;

public final class ArrayLoadInstruction
extends Instruction
implements IArrayLoadInstruction {
    private static final ArrayLoadInstruction[] preallocated = ArrayLoadInstruction.preallocate();

    private ArrayLoadInstruction(short opcode) {
        super(opcode);
    }

    private static ArrayLoadInstruction[] preallocate() {
        ArrayLoadInstruction[] r = new ArrayLoadInstruction[9];
        for (short i = 46; i <= 53; i = (short)(i + 1)) {
            r[i - 46] = new ArrayLoadInstruction(i);
        }
        r[8] = r[5];
        return r;
    }

    public static ArrayLoadInstruction make(String type) throws IllegalArgumentException {
        int i = Util.getTypeIndex(type);
        if (i < 0 || i > 8) {
            throw new IllegalArgumentException("Invalid type " + type + " for ArrayLoadInstruction");
        }
        return preallocated[i];
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayLoadInstruction) {
            ArrayLoadInstruction i = (ArrayLoadInstruction)o;
            return i.opcode == this.opcode;
        }
        return false;
    }

    public int hashCode() {
        return this.opcode + 9109101;
    }

    @Override
    public int getPoppedCount() {
        return 2;
    }

    @Override
    public String toString() {
        return "ArrayLoad(" + this.getType() + ')';
    }

    @Override
    public String getPushedType(String[] types) throws IllegalArgumentException {
        if (types == null) {
            return this.getType();
        }
        if (types.length <= 1) {
            throw new IllegalArgumentException("types.length <= 1");
        }
        String t = types[1];
        if (t == null) {
            throw new IllegalArgumentException("types[1] cannot be null");
        }
        if (t.startsWith("[")) {
            return t.substring(1);
        }
        if (t.equals("L;")) {
            return "L;";
        }
        return "L?;";
    }

    @Override
    public byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    @Override
    public String getType() {
        return Constants.indexedTypes[this.opcode - 46];
    }

    @Override
    public void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitArrayLoad(this);
    }

    @Override
    public boolean isPEI() {
        return true;
    }

    @Override
    public boolean isAddressOf() {
        return false;
    }
}

