/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.pruned;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class PrunedCallGraph
implements CallGraph {
    private final CallGraph cg;
    private final Set<CGNode> keep;
    private Map<CGNode, Set<CGNode>> remove = Collections.emptyMap();

    public PrunedCallGraph(CallGraph cg, Set<CGNode> keep) {
        this.cg = cg;
        this.keep = keep;
        for (CGNode keptNode : keep) {
            if (cg.containsNode(keptNode)) continue;
            throw new IllegalArgumentException(String.format("%s does not contain %s", cg, keptNode));
        }
    }

    public PrunedCallGraph(CallGraph cg, Set<CGNode> keep, Map<CGNode, Set<CGNode>> remove) {
        this(cg, keep);
        this.remove = remove;
    }

    @Override
    public void removeNodeAndEdges(CGNode n) throws UnsupportedOperationException {
        this.cg.removeNodeAndEdges(n);
        this.keep.remove(n);
        this.remove.remove(n);
    }

    @Override
    public Iterator<CGNode> iterator() {
        return this.keep.iterator();
    }

    @Override
    public Stream<CGNode> stream() {
        return this.keep.stream();
    }

    @Override
    public int getNumberOfNodes() {
        return this.keep.size();
    }

    @Override
    public void addNode(CGNode n) {
        this.cg.addNode(n);
        this.keep.add(n);
    }

    @Override
    public void removeNode(CGNode n) throws UnsupportedOperationException {
        this.cg.removeNode(n);
        this.keep.remove(n);
        this.remove.remove(n);
    }

    @Override
    public boolean containsNode(CGNode n) {
        return this.cg.containsNode(n) && this.keep.contains(n);
    }

    private boolean removedEdge(CGNode src, CGNode target) {
        return this.remove.containsKey(src) && this.remove.get(src).contains(target);
    }

    @Override
    public Iterator<CGNode> getPredNodes(CGNode n) {
        Iterator<CGNode> tmp = this.cg.getPredNodes(n);
        ArrayList<CGNode> col = new ArrayList<CGNode>();
        while (tmp.hasNext()) {
            CGNode no = tmp.next();
            if (!this.keep.contains(no) || this.removedEdge(no, n)) continue;
            col.add(no);
        }
        return col.iterator();
    }

    @Override
    public int getPredNodeCount(CGNode n) {
        Iterator<CGNode> tmp = this.cg.getPredNodes(n);
        int cnt = 0;
        while (tmp.hasNext()) {
            CGNode no = tmp.next();
            if (!this.keep.contains(no) || this.removedEdge(no, n)) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public Iterator<CGNode> getSuccNodes(CGNode n) {
        Iterator<CGNode> tmp = this.cg.getSuccNodes(n);
        ArrayList<CGNode> col = new ArrayList<CGNode>();
        while (tmp.hasNext()) {
            CGNode no = tmp.next();
            if (!this.keep.contains(no) || this.removedEdge(n, no)) continue;
            col.add(no);
        }
        return col.iterator();
    }

    @Override
    public int getSuccNodeCount(CGNode n) {
        Iterator<CGNode> tmp = this.cg.getSuccNodes(n);
        int cnt = 0;
        while (tmp.hasNext()) {
            CGNode no = tmp.next();
            if (!this.keep.contains(no) || this.removedEdge(n, no)) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public void addEdge(CGNode src, CGNode dst) {
        if (this.keep.contains(src) && this.keep.contains(dst)) {
            this.cg.addEdge(src, dst);
        }
    }

    @Override
    public void removeEdge(CGNode src, CGNode dst) throws UnsupportedOperationException {
        this.cg.removeEdge(src, dst);
    }

    @Override
    public void removeAllIncidentEdges(CGNode node) throws UnsupportedOperationException {
        this.cg.removeAllIncidentEdges(node);
    }

    @Override
    public void removeIncomingEdges(CGNode node) throws UnsupportedOperationException {
        this.cg.removeIncomingEdges(node);
    }

    @Override
    public void removeOutgoingEdges(CGNode node) throws UnsupportedOperationException {
        this.cg.removeOutgoingEdges(node);
    }

    @Override
    public boolean hasEdge(CGNode src, CGNode dst) {
        return this.cg.hasEdge(src, dst) && this.keep.contains(src) && this.keep.contains(dst) && !this.removedEdge(src, dst);
    }

    @Override
    public int getNumber(CGNode N) {
        if (this.keep.contains(N)) {
            return this.cg.getNumber(N);
        }
        return -1;
    }

    @Override
    public CGNode getNode(int number) {
        if (this.keep.contains(this.cg.getNode(number))) {
            return (CGNode)this.cg.getNode(number);
        }
        return null;
    }

    @Override
    public int getMaxNumber() {
        return this.cg.getMaxNumber();
    }

    @Override
    public Iterator<CGNode> iterateNodes(IntSet s) {
        Iterator tmp = this.cg.iterateNodes(s);
        ArrayList<CGNode> col = new ArrayList<CGNode>();
        while (tmp.hasNext()) {
            CGNode n = (CGNode)tmp.next();
            if (!this.keep.contains(n)) continue;
            col.add(n);
        }
        return col.iterator();
    }

    @Override
    public IntSet getSuccNodeNumbers(CGNode node) {
        if (!this.keep.contains(node)) {
            return null;
        }
        IntSet tmp = this.cg.getSuccNodeNumbers(node);
        BitVectorIntSet kp = new BitVectorIntSet();
        for (CGNode n : this.keep) {
            if (this.removedEdge(node, n)) continue;
            kp.add(this.getNumber(n));
        }
        return tmp.intersection(kp);
    }

    @Override
    public IntSet getPredNodeNumbers(CGNode node) {
        if (!this.keep.contains(node)) {
            return null;
        }
        IntSet tmp = this.cg.getPredNodeNumbers(node);
        BitVectorIntSet kp = new BitVectorIntSet();
        for (CGNode n : this.keep) {
            if (this.removedEdge(n, node)) continue;
            kp.add(this.getNumber(n));
        }
        return tmp.intersection(kp);
    }

    @Override
    public CGNode getFakeRootNode() {
        if (this.keep.contains(this.cg.getFakeRootNode())) {
            return this.cg.getFakeRootNode();
        }
        return null;
    }

    @Override
    public CGNode getFakeWorldClinitNode() {
        if (this.keep.contains(this.cg.getFakeWorldClinitNode())) {
            return this.cg.getFakeRootNode();
        }
        return null;
    }

    @Override
    public Collection<CGNode> getEntrypointNodes() {
        Collection<CGNode> tmp = this.cg.getEntrypointNodes();
        HashSet<CGNode> ret = new HashSet<CGNode>();
        for (CGNode n : tmp) {
            if (!this.keep.contains(n)) continue;
            ret.add(n);
        }
        return ret;
    }

    @Override
    public CGNode getNode(IMethod method, Context C) {
        if (this.keep.contains(this.cg.getNode(method, C))) {
            return this.cg.getNode(method, C);
        }
        return null;
    }

    @Override
    public Set<CGNode> getNodes(MethodReference m) {
        Set<CGNode> tmp = this.cg.getNodes(m);
        HashSet<CGNode> ret = new HashSet<CGNode>();
        for (CGNode n : tmp) {
            if (!this.keep.contains(n)) continue;
            ret.add(n);
        }
        return ret;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cg.getClassHierarchy();
    }

    @Override
    public Set<CGNode> getPossibleTargets(CGNode node, CallSiteReference site) {
        if (!this.keep.contains(node)) {
            return null;
        }
        Set<CGNode> tmp = this.cg.getPossibleTargets(node, site);
        HashSet<CGNode> ret = new HashSet<CGNode>();
        for (CGNode n : tmp) {
            if (!this.keep.contains(n) || this.removedEdge(node, n)) continue;
            ret.add(n);
        }
        return ret;
    }

    @Override
    public int getNumberOfTargets(CGNode node, CallSiteReference site) {
        if (!this.keep.contains(node)) {
            return -1;
        }
        return this.getPossibleTargets(node, site).size();
    }

    @Override
    public Iterator<CallSiteReference> getPossibleSites(CGNode src, CGNode target) {
        if (!this.keep.contains(src) || !this.keep.contains(target) || this.removedEdge(src, target)) {
            return null;
        }
        return this.cg.getPossibleSites(src, target);
    }
}

