/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.core.util.CancelRuntimeException;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.modref.GenReach;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class CallGraphTransitiveClosure {
    public static <T> Map<CGNode, OrdinalSet<T>> transitiveClosure(CallGraph cg, Map<CGNode, Collection<T>> nodeResults) {
        try {
            GenReach<CGNode, T> gr = new GenReach<CGNode, T>(GraphInverter.invert(cg), nodeResults);
            BitVectorSolver<CGNode> solver = new BitVectorSolver<CGNode>((IKilldallFramework<CGNode, BitVectorVariable>)gr);
            solver.solve(null);
            HashMap<CGNode, OrdinalSet<T>> result = HashMapFactory.make();
            for (CGNode n : cg) {
                BitVectorVariable bv = (BitVectorVariable)solver.getOut(n);
                result.put(n, new OrdinalSet(bv.getValue(), gr.getLatticeValues()));
            }
            return result;
        }
        catch (CancelException e) {
            throw new CancelRuntimeException(e);
        }
    }

    public static <T> Map<CGNode, Collection<T>> collectNodeResults(CallGraph cg, Function<CGNode, Collection<T>> nodeResultComputer) {
        HashMap<CGNode, Collection<T>> result = HashMapFactory.make();
        for (CGNode n : cg) {
            result.put(n, nodeResultComputer.apply(n));
        }
        return result;
    }
}

