/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.escape;

import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.escape.LocalLiveRangeAnalysis;
import com.ibm.wala.escape.TrivialMethodEscape;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FILiveObjectAnalysis
implements ILiveObjectAnalysis {
    private final CallGraph callGraph;
    private final HeapGraph<?> heapGraph;
    private final Map<InstanceKey, Set<CGNode>> liveNodes = HashMapFactory.make();
    private final Set<InstanceKey> liveEverywhere = HashSetFactory.make();
    private final boolean expensiveIntraproceduralAnalysis;

    public FILiveObjectAnalysis(CallGraph callGraph, HeapGraph<?> heapGraph, boolean expensiveIntraproceduralAnalysis) {
        this.callGraph = callGraph;
        this.heapGraph = heapGraph;
        this.expensiveIntraproceduralAnalysis = expensiveIntraproceduralAnalysis;
    }

    @Override
    public boolean mayBeLive(CGNode allocMethod, int allocPC, CGNode m, int instructionIndex) throws IllegalArgumentException, WalaException {
        if (allocMethod == null) {
            throw new IllegalArgumentException("allocMethod == null");
        }
        NewSiteReference site = TrivialMethodEscape.findAlloc(allocMethod, allocPC);
        InstanceKey ik = this.heapGraph.getHeapModel().getInstanceKeyForAllocation(allocMethod, site);
        return this.mayBeLive(ik, m, instructionIndex);
    }

    @Override
    public boolean mayBeLive(InstanceKey ik, CGNode m, int instructionIndex) {
        if (this.liveEverywhere.contains(ik)) {
            return true;
        }
        Set<CGNode> live = this.liveNodes.get(ik);
        if (live != null) {
            if (live.contains(m)) {
                if (instructionIndex == -1) {
                    return true;
                }
                if (this.mayBeLiveInSomeCaller(ik, m)) {
                    return true;
                }
                if (this.expensiveIntraproceduralAnalysis) {
                    return this.mayBeLiveIntraprocedural(ik, m, instructionIndex);
                }
                return true;
            }
            return false;
        }
        live = this.computeLiveNodes(ik);
        this.liveNodes.put(ik, live);
        return this.mayBeLive(ik, m, instructionIndex);
    }

    private boolean mayBeLiveInSomeCaller(InstanceKey ik, CGNode m) {
        for (CGNode n : Iterator2Iterable.make(this.callGraph.getPredNodes(m))) {
            if (!this.mayBeLive(ik, n, -1)) continue;
            return true;
        }
        return false;
    }

    private boolean mayBeLiveIntraprocedural(InstanceKey ik, CGNode m, int instructionIndex) {
        IR ir = m.getIR();
        DefUse du = m.getDU();
        for (InstanceKey p : Iterator2Iterable.make(DFS.iterateDiscoverTime(GraphInverter.invert(this.heapGraph), ik))) {
            LocalPointerKey lpk;
            if (!(p instanceof LocalPointerKey) || !(lpk = (LocalPointerKey)((Object)p)).getNode().equals(m) || !LocalLiveRangeAnalysis.isLive(lpk.getValueNumber(), instructionIndex, ir, du)) continue;
            return true;
        }
        return false;
    }

    private Set<CGNode> computeLiveNodes(InstanceKey ik) {
        HashSet localRootNodes = HashSetFactory.make();
        for (InstanceKey instanceKey : Iterator2Iterable.make(DFS.iterateDiscoverTime(GraphInverter.invert(this.heapGraph), ik))) {
            if (instanceKey instanceof StaticFieldKey) {
                this.liveEverywhere.add(ik);
                return Collections.emptySet();
            }
            if (instanceKey instanceof AbstractLocalPointerKey) {
                AbstractLocalPointerKey local = (AbstractLocalPointerKey)((Object)instanceKey);
                localRootNodes.add(local.getNode());
                continue;
            }
            if (!(instanceKey instanceof PropagationCallGraphBuilder.TypedPointerKey)) continue;
            PropagationCallGraphBuilder.TypedPointerKey t = (PropagationCallGraphBuilder.TypedPointerKey)((Object)instanceKey);
            PointerKey pointerKey = t.getBase();
            if (pointerKey instanceof AbstractLocalPointerKey) {
                AbstractLocalPointerKey local = (AbstractLocalPointerKey)pointerKey;
                localRootNodes.add(local.getNode());
                continue;
            }
            Assertions.UNREACHABLE("unexpected base of TypedPointerKey: " + pointerKey.getClass() + ' ' + pointerKey);
        }
        return DFS.getReachableNodes(this.callGraph, localRootNodes);
    }

    @Override
    public boolean mayBeLive(InstanceKey ik, CGNode m, IntSet instructionIndices) {
        if (instructionIndices == null) {
            throw new IllegalArgumentException("instructionIndices is null");
        }
        IntIterator it = instructionIndices.intIterator();
        while (it.hasNext()) {
            int i = it.next();
            if (!this.mayBeLive(ik, m, i)) continue;
            return true;
        }
        return false;
    }
}

