/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg;

import com.ibm.wala.demandpa.alg.AbstractDemandPointsTo;
import com.ibm.wala.demandpa.flowgraph.SimpleDemandPointerFlowGraph;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.traverse.SlowDFSDiscoverTimeIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class SimpleDemandPointsTo
extends AbstractDemandPointsTo {
    private static final boolean VERBOSE = false;

    public SimpleDemandPointsTo(CallGraph cg, HeapModel model, MemoryAccessMap fam, IClassHierarchy cha, AnalysisOptions options) {
        super(cg, model, fam, cha, options);
    }

    @Override
    public Collection<InstanceKey> getPointsTo(PointerKey pk) throws IllegalArgumentException, UnimplementedError {
        if (pk == null) {
            throw new IllegalArgumentException("pk == null");
        }
        assert (pk instanceof LocalPointerKey) : "we only handle locals";
        LocalPointerKey lpk = (LocalPointerKey)pk;
        SimpleDemandPointerFlowGraph g = new SimpleDemandPointerFlowGraph(this.cg, this.heapModel, this.mam, this.cha);
        CGNode node = lpk.getNode();
        g.addSubgraphForNode(node);
        if (!g.containsNode(pk)) {
            return Collections.emptySet();
        }
        SlowDFSDiscoverTimeIterator<PointerKey> dfs = new SlowDFSDiscoverTimeIterator<PointerKey>(g, pk);
        HashSet<InstanceKey> keys = HashSetFactory.make();
        while (dfs.hasNext()) {
            Object o = dfs.next();
            if (!(o instanceof InstanceKey)) continue;
            keys.add((InstanceKey)o);
        }
        return keys;
    }
}

