/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.types.annotations.TypeAnnotation;
import com.ibm.wala.types.generics.TypeSignature;
import java.util.Collection;
import java.util.Collections;

public final class FieldImpl
implements IField {
    private final IClass declaringClass;
    private final FieldReference fieldRef;
    private final int accessFlags;
    private final Collection<Annotation> annotations;
    private final Collection<TypeAnnotation> typeAnnotations;
    private final TypeSignature genericSignature;

    public FieldImpl(IClass declaringClass, FieldReference canonicalRef, int accessFlags, Collection<Annotation> annotations, TypeSignature sig) {
        this(declaringClass, canonicalRef, accessFlags, annotations, null, sig);
    }

    public FieldImpl(IClass declaringClass, FieldReference canonicalRef, int accessFlags, Collection<Annotation> annotations, Collection<TypeAnnotation> typeAnnotations, TypeSignature sig) {
        this.declaringClass = declaringClass;
        this.fieldRef = canonicalRef;
        this.accessFlags = accessFlags;
        this.annotations = annotations;
        this.typeAnnotations = typeAnnotations;
        this.genericSignature = sig;
        if (declaringClass == null) {
            throw new IllegalArgumentException("null declaringClass");
        }
        if (this.fieldRef == null) {
            throw new IllegalArgumentException("null canonicalRef");
        }
    }

    public FieldImpl(IClass declaringClass, FieldReference canonicalRef, int accessFlags, Collection<Annotation> annotations) {
        this(declaringClass, canonicalRef, accessFlags, annotations, null);
    }

    public TypeSignature getGenericSignature() {
        return this.genericSignature;
    }

    @Override
    public IClass getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldImpl) {
            FieldImpl other = (FieldImpl)obj;
            return this.fieldRef.equals(other.fieldRef) && this.declaringClass.equals(other.declaringClass);
        }
        return false;
    }

    public int hashCode() {
        return 87049 * this.declaringClass.hashCode() + this.fieldRef.hashCode();
    }

    public String toString() {
        FieldReference fr = this.getReference();
        return fr.toString();
    }

    @Override
    public FieldReference getReference() {
        return FieldReference.findOrCreate(this.getDeclaringClass().getReference(), this.getName(), this.getFieldTypeReference());
    }

    @Override
    public Atom getName() {
        return this.fieldRef.getName();
    }

    @Override
    public TypeReference getFieldTypeReference() {
        return this.fieldRef.getFieldType();
    }

    @Override
    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.accessFlags & 2) != 0;
    }

    @Override
    public boolean isProtected() {
        return (this.accessFlags & 4) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    @Override
    public boolean isVolatile() {
        return (this.accessFlags & 0x40) != 0;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.declaringClass.getClassHierarchy();
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return this.annotations == null ? null : Collections.unmodifiableCollection(this.annotations);
    }

    public Collection<TypeAnnotation> getTypeAnnotations() {
        return this.typeAnnotations == null ? null : Collections.unmodifiableCollection(this.typeAnnotations);
    }
}

