/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.ArrayClassLoader;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.JarFileEntry;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.core.util.io.FileProvider;
import com.ibm.wala.core.util.io.FileSuffixes;
import com.ibm.wala.core.util.shrike.ShrikeClassReaderHandle;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.core.util.warnings.Warning;
import com.ibm.wala.core.util.warnings.Warnings;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrike.shrikeCT.ClassReader;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.config.SetOfClasses;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

public class ClassLoaderImpl
implements IClassLoader {
    public static final int DEBUG_LEVEL = 0;
    private static final boolean OPTIMIZE_JAR_FILE_IO = true;
    private final SetOfClasses exclusions;
    private final ClassLoaderReference loader;
    protected final Map<TypeName, IClass> loadedClasses = HashMapFactory.make();
    private final Map<TypeName, ModuleEntry> sourceMap = HashMapFactory.make();
    private final IClassLoader parent;
    protected final IClassHierarchy cha;
    private final ArrayClassLoader arrayClassLoader;

    public ClassLoaderImpl(ClassLoaderReference loader, ArrayClassLoader arrayClassLoader, IClassLoader parent, SetOfClasses exclusions, IClassHierarchy cha) {
        if (loader == null) {
            throw new IllegalArgumentException("null loader");
        }
        this.arrayClassLoader = arrayClassLoader;
        this.parent = parent;
        this.loader = loader;
        this.exclusions = exclusions;
        this.cha = cha;
    }

    private Set<ModuleEntry> getSourceFiles(Module M) throws IOException {
        HashSet<ModuleEntry> result = HashSetFactory.make();
        for (ModuleEntry moduleEntry : Iterator2Iterable.make(M.getEntries())) {
            if (moduleEntry.isSourceFile()) {
                result.add(moduleEntry);
                continue;
            }
            if (!moduleEntry.isModuleFile()) continue;
            result.addAll(this.getSourceFiles(moduleEntry.asModule()));
        }
        return result;
    }

    private Set<ModuleEntry> getClassFiles(Module M) throws IOException {
        HashSet<ModuleEntry> result = HashSetFactory.make();
        for (ModuleEntry moduleEntry : Iterator2Iterable.make(M.getEntries())) {
            if (moduleEntry.isClassFile()) {
                result.add(moduleEntry);
                continue;
            }
            if (!moduleEntry.isModuleFile()) continue;
            Set<ModuleEntry> s = this.getClassFiles(moduleEntry.asModule());
            ClassLoaderImpl.removeClassFiles(s, result);
            result.addAll(s);
        }
        return result;
    }

    private static void removeClassFiles(Set<ModuleEntry> s, Set<ModuleEntry> t) {
        s.removeAll(t);
    }

    private Collection<IClass> getAllClasses() {
        assert (this.loadedClasses != null);
        return this.loadedClasses.values();
    }

    private void loadAllClasses(Collection<ModuleEntry> moduleEntries, Map<String, Object> fileContents, boolean isJMODType) {
        for (ModuleEntry entry : moduleEntries) {
            if (!entry.isClassFile() || isJMODType && entry.getClassName().startsWith("classes/module-info")) continue;
            String className = entry.getClassName().replace('.', '/');
            if (isJMODType && className.startsWith("classes/")) {
                className = className.replace("classes/", "");
            }
            if (this.exclusions != null && this.exclusions.contains(className)) continue;
            ShrikeClassReaderHandle entryReader = new ShrikeClassReaderHandle(entry);
            className = 'L' + className;
            try {
                ShrikeClass tmpKlass;
                Object contents;
                TypeName T = TypeName.string2TypeName(className);
                if (this.loadedClasses.get(T) != null) {
                    Warnings.add(MultipleImplementationsWarning.create(className));
                    continue;
                }
                if (this.parent != null && this.parent.lookupClass(T) != null) {
                    Warnings.add(MultipleImplementationsWarning.create(className));
                    continue;
                }
                ShrikeClassReaderHandle reader = entryReader;
                if (fileContents != null && (contents = fileContents.get(entry.getName())) != null) {
                    reader = new ByteArrayReaderHandle(entry, (byte[])contents);
                }
                if ((tmpKlass = new ShrikeClass(reader, this, this.cha)).getReference().getName().equals(T)) {
                    this.loadedClasses.put(T, new ShrikeClass(entryReader, this, this.cha));
                    continue;
                }
                Warnings.add(InvalidClassFile.create(className));
            }
            catch (InvalidClassFileException e) {
                Warnings.add(InvalidClassFile.create(className));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> getAllClassAndSourceFileContents(byte[] jarFileContents, String fileName, Map<String, Map<String, Long>> entrySizes) {
        if (jarFileContents == null) {
            return null;
        }
        Map<String, Long> entrySizesForFile = entrySizes.get(fileName);
        if (entrySizesForFile == null) {
            return null;
        }
        HashMap<String, Object> result = HashMapFactory.make();
        try (JarInputStream s = new JarInputStream((InputStream)new ByteArrayInputStream(jarFileContents), false);){
            JarEntry entry = null;
            block17: while ((entry = s.getNextJarEntry()) != null) {
                byte[] entryBytes = ClassLoaderImpl.getEntryBytes(entrySizesForFile.get(entry.getName()), s);
                if (entryBytes == null) {
                    Map<String, Object> map = null;
                    return map;
                }
                String name = entry.getName();
                if (FileSuffixes.isJarFile(name) || FileSuffixes.isWarFile(name)) {
                    Iterator<Map.Entry<String, Object>> iterator;
                    Map<String, Object> nestedResult = this.getAllClassAndSourceFileContents(entryBytes, name, entrySizes);
                    if (nestedResult == null) {
                        iterator = null;
                        return iterator;
                    }
                    iterator = nestedResult.entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block17;
                        Map.Entry<String, Object> nestedEntry = iterator.next();
                        String entryName = nestedEntry.getKey();
                        if (result.containsKey(entryName)) continue;
                        result.put(entryName, nestedEntry.getValue());
                    }
                }
                if (!FileSuffixes.isClassFile(name) && !FileSuffixes.isSourceFile(name)) continue;
                result.put(name, entryBytes);
            }
            return result;
        }
        catch (IOException e) {
            assert (false);
            return result;
        }
    }

    private static byte[] getEntryBytes(Long size, InputStream is) throws IOException {
        if (size == null) {
            return null;
        }
        ByteArrayOutputStream S = new ByteArrayOutputStream();
        int n = 0;
        long count = 0L;
        byte[] buffer = new byte[1024];
        while (n > -1 && count < size) {
            n = is.read(buffer, 0, 1024);
            if (n <= -1) continue;
            S.write(buffer, 0, n);
            count += (long)n;
        }
        return S.toByteArray();
    }

    protected void loadAllSources(Set<ModuleEntry> sourceModules) {
        for (ModuleEntry entry : sourceModules) {
            String className = entry.getClassName().replace('.', '/');
            className = className.replace(File.separatorChar, '/');
            className = 'L' + (className.startsWith("/") ? className.substring(1) : className);
            TypeName T = TypeName.string2TypeName(className);
            boolean success = false;
            if (this.loadedClasses.get(T) != null) {
                this.sourceMap.put(T, entry);
                success = true;
            } else {
                while (className.indexOf(47) > 0) {
                    className = 'L' + className.substring(className.indexOf(47) + 1);
                    TypeName T2 = TypeName.string2TypeName(className);
                    if (this.loadedClasses.get(T2) == null) continue;
                    this.sourceMap.put(T2, entry);
                    success = true;
                    break;
                }
            }
            if (success) continue;
            this.sourceMap.put(T, entry);
        }
    }

    @Override
    public void init(List<Module> modules) throws IOException {
        if (modules == null) {
            throw new IllegalArgumentException("modules is null");
        }
        HashSet<ModuleEntry> classModuleEntries = HashSetFactory.make();
        HashSet sourceModuleEntries = HashSetFactory.make();
        for (Module archive : modules) {
            boolean isJMODType = false;
            if (archive instanceof JarFileModule) {
                JarFile jarFile = ((JarFileModule)archive).getJarFile();
                boolean bl = isJMODType = jarFile != null && jarFile.getName().endsWith(".jmod");
            }
            if (archive instanceof JarFileModule) {
                ClassLoaderImpl.getJarFileContents((JarFileModule)archive);
            }
            Set<ModuleEntry> classFiles = this.getClassFiles(archive);
            ClassLoaderImpl.removeClassFiles(classFiles, classModuleEntries);
            Set<ModuleEntry> sourceFiles = this.getSourceFiles(archive);
            Map<String, Object> allClassAndSourceFileContents = null;
            this.loadAllClasses(classFiles, allClassAndSourceFileContents, isJMODType);
            this.loadAllSources(sourceFiles);
            classModuleEntries.addAll(classFiles);
            sourceModuleEntries.addAll(sourceFiles);
        }
    }

    private Map<String, Map<String, Long>> getEntrySizes(Module module, String name) {
        HashMap<String, Map<String, Long>> result = HashMapFactory.make();
        HashMap<String, Long> curFileResult = HashMapFactory.make();
        for (ModuleEntry moduleEntry : Iterator2Iterable.make(module.getEntries())) {
            if (moduleEntry.isModuleFile()) {
                result.putAll(this.getEntrySizes(moduleEntry.asModule(), moduleEntry.getName()));
                continue;
            }
            if (!(moduleEntry instanceof JarFileEntry)) continue;
            curFileResult.put(moduleEntry.getName(), ((JarFileEntry)moduleEntry).getSize());
        }
        result.put(name, curFileResult);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getJarFileContents(JarFileModule archive) {
        String jarFileName = archive.getJarFile().getName();
        InputStream s = null;
        try {
            File jarFile = new FileProvider().getFile(jarFileName);
            int bufferSize = 65536;
            s = new BufferedInputStream(new FileInputStream(jarFile), bufferSize);
            byte[] b = new byte[1024];
            int n = s.read(b);
            while (n != -1) {
                n = s.read(b);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public ClassLoaderReference getReference() {
        return this.loader;
    }

    @Override
    public Iterator<IClass> iterateAllClasses() {
        return this.getAllClasses().iterator();
    }

    @Override
    public IClass lookupClass(TypeName className) {
        IClass result;
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (className.isArrayType()) {
            return this.arrayClassLoader.lookupClass(className, this, this.cha);
        }
        IClassLoader parent = this.getParent();
        if (parent != null && (result = parent.lookupClass(className)) != null) {
            return result;
        }
        result = this.loadedClasses.get(className);
        return result;
    }

    @Override
    public IClassLoader getParent() {
        return this.parent;
    }

    @Override
    public Atom getName() {
        return this.loader.getName();
    }

    @Override
    public Language getLanguage() {
        return Language.JAVA;
    }

    public String toString() {
        return this.getName().toString();
    }

    @Override
    public int getNumberOfClasses() {
        return this.getAllClasses().size();
    }

    @Override
    public int getNumberOfMethods() {
        int result = 0;
        for (IClass klass : Iterator2Iterable.make(this.iterateAllClasses())) {
            result += klass.getDeclaredMethods().size();
        }
        return result;
    }

    @Override
    public String getSourceFileName(IClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        ModuleEntry e = this.sourceMap.get(klass.getName());
        return e == null ? null : e.getName();
    }

    @Override
    public Reader getSource(IMethod method, int offset) {
        return this.getSource(method.getDeclaringClass());
    }

    @Override
    public String getSourceFileName(IMethod method, int offset) {
        return this.getSourceFileName(method.getDeclaringClass());
    }

    @Override
    public Reader getSource(IClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        ModuleEntry e = this.sourceMap.get(klass.getName());
        return e == null ? null : new InputStreamReader(e.getInputStream());
    }

    @Override
    public void removeAll(Collection<IClass> toRemove) {
        if (toRemove == null) {
            throw new IllegalArgumentException("toRemove is null");
        }
        toRemove.stream().map(IClass::getName).peek(this.loadedClasses::remove).forEach(this.sourceMap::remove);
    }

    @Override
    public SSAInstructionFactory getInstructionFactory() {
        return this.getLanguage().instructionFactory();
    }

    private static class InvalidClassFile
    extends Warning {
        final String className;

        InvalidClassFile(String className) {
            super((byte)2);
            this.className = className;
        }

        @Override
        public String getMsg() {
            return this.getClass().toString() + " : " + this.className;
        }

        public static InvalidClassFile create(String className) {
            return new InvalidClassFile(className);
        }
    }

    private static class MultipleImplementationsWarning
    extends Warning {
        final String className;

        MultipleImplementationsWarning(String className) {
            super((byte)2);
            this.className = className;
        }

        @Override
        public String getMsg() {
            return this.getClass().toString() + " : " + this.className;
        }

        public static MultipleImplementationsWarning create(String className) {
            return new MultipleImplementationsWarning(className);
        }
    }

    static class ByteArrayReaderHandle
    extends ShrikeClassReaderHandle {
        private byte[] contents;
        private boolean cleared;

        public ByteArrayReaderHandle(ModuleEntry entry, byte[] contents) {
            super(entry);
            assert (contents != null && contents.length > 0);
            this.contents = contents;
        }

        @Override
        public ClassReader get() throws InvalidClassFileException {
            if (this.cleared) {
                return super.get();
            }
            return new ClassReader(this.contents);
        }

        @Override
        public void clear() {
            if (this.cleared) {
                super.clear();
            } else {
                this.contents = null;
                this.cleared = true;
            }
        }
    }
}

