/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;

public class GetMethodContext
implements Context {
    private final TypeAbstraction type;
    private final ConstantKey<String> name;

    public GetMethodContext(TypeAbstraction type, ConstantKey<String> name) {
        if (type == null) {
            throw new IllegalArgumentException("null == type");
        }
        this.type = type;
        if (name == null) {
            throw new IllegalArgumentException("null == name");
        }
        this.name = name;
    }

    @Override
    public ContextItem get(ContextKey name) {
        if (name == ContextKey.RECEIVER) {
            return this.type;
        }
        if (name == ContextKey.NAME) {
            return new NameItem();
        }
        if (name == ContextKey.PARAMETERS[0]) {
            if (this.type instanceof PointType) {
                IClass cls = ((PointType)this.type).getIClass();
                return new FilteredPointerKey.SingleClassFilter(cls);
            }
            return null;
        }
        if (name == ContextKey.PARAMETERS[1]) {
            return new FilteredPointerKey.SingleClassFilter(this.name.getConcreteType());
        }
        return null;
    }

    public String toString() {
        return "GetMethodContext<" + this.type + ", " + this.name + '>';
    }

    public int hashCode() {
        return 6367 * this.type.hashCode() * this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass().equals(obj.getClass())) {
            GetMethodContext other = (GetMethodContext)obj;
            return this.type.equals(other.type) && this.name.equals(other.name);
        }
        return false;
    }

    public TypeAbstraction getType() {
        return this.type;
    }

    public String getName() {
        return this.name.getValue();
    }

    class NameItem
    implements ContextItem {
        NameItem() {
        }

        String name() {
            return GetMethodContext.this.getName();
        }
    }
}

