/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.common.graph;

import codetoolkit.janalysis.common.collections.MatcherLinkedHashMap;
import codetoolkit.janalysis.common.collections.MatcherLinkedHashSet;
import codetoolkit.janalysis.common.graph.AbstractPropertyGraph;
import codetoolkit.janalysis.common.graph.DefaultMatcher;
import codetoolkit.janalysis.common.graph.Edge;
import codetoolkit.janalysis.common.graph.Matcher;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class Digraph<V, E>
extends AbstractPropertyGraph<V, E> {
    protected final Matcher<V> VERTEX_MATCHER;
    protected final Matcher<Edge<V, E>> EDGES_MATCHER;

    public Digraph() {
        this.EDGES_MATCHER = new DefaultMatcher<Edge<V, E>>();
        this.VERTEX_MATCHER = new DefaultMatcher<V>();
        this.allEdges = new MatcherLinkedHashSet<Edge<V, E>>(32, this.EDGES_MATCHER);
        this.allVertices = new MatcherLinkedHashSet<V>(16, this.VERTEX_MATCHER);
        this.inEdges = new MatcherLinkedHashMap(16, this.VERTEX_MATCHER);
        this.outEdges = new MatcherLinkedHashMap(16, this.VERTEX_MATCHER);
    }

    public Digraph(Matcher<V> vm, Matcher<Edge<V, E>> em) {
        this.properties.put("directed", "true");
        this.EDGES_MATCHER = em;
        this.VERTEX_MATCHER = vm;
        this.allEdges = new MatcherLinkedHashSet<Edge<V, E>>(32, this.EDGES_MATCHER);
        this.allVertices = new MatcherLinkedHashSet<V>(16, this.VERTEX_MATCHER);
        this.inEdges = new MatcherLinkedHashMap(16, this.VERTEX_MATCHER);
        this.outEdges = new MatcherLinkedHashMap(16, this.VERTEX_MATCHER);
    }

    public Digraph(AbstractPropertyGraph<V, E> graph) {
        super(graph);
        this.properties.put("directed", "true");
        this.EDGES_MATCHER = graph.getEdgesMatcher();
        this.VERTEX_MATCHER = graph.getVertexMatcher();
        this.allEdges = new MatcherLinkedHashSet<Edge<V, E>>(graph.allEdges, this.EDGES_MATCHER);
        this.allVertices = new MatcherLinkedHashSet(graph.allVertices, this.VERTEX_MATCHER);
        this.inEdges = new MatcherLinkedHashMap(16, this.VERTEX_MATCHER);
        for (Object v : graph.inEdges.keySet()) {
            this.inEdges.put(v, new MatcherLinkedHashSet<Edge<V, E>>(graph.inEdges.get(v), this.EDGES_MATCHER));
        }
        this.outEdges = new MatcherLinkedHashMap(16, this.VERTEX_MATCHER);
        for (Object v : graph.outEdges.keySet()) {
            this.outEdges.put(v, new MatcherLinkedHashSet<Edge<V, E>>(graph.outEdges.get(v), this.EDGES_MATCHER));
        }
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    protected Matcher<V> getVertexMatcher() {
        return this.VERTEX_MATCHER;
    }

    @Override
    protected Matcher<Edge<V, E>> getEdgesMatcher() {
        return this.EDGES_MATCHER;
    }

    @Override
    public boolean addVertex(V v) {
        if (this.allVertices.add(v)) {
            this.inEdges.put(v, new MatcherLinkedHashSet<Edge<V, E>>(8, this.EDGES_MATCHER));
            this.outEdges.put(v, new MatcherLinkedHashSet<Edge<V, E>>(8, this.EDGES_MATCHER));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.allVertices.remove(v)) {
            this.allEdges.removeAll((Collection)this.inEdges.remove(v));
            this.allEdges.removeAll((Collection)this.outEdges.remove(v));
            return true;
        }
        return false;
    }

    @Override
    public boolean addEdge(Edge<V, E> e) {
        if (!this.allVertices.contains(e.source)) {
            throw new IllegalArgumentException("No such source-vertex in this graph!");
        }
        if (!this.allVertices.contains(e.target)) {
            throw new IllegalArgumentException("No such target-vertex in this graph!");
        }
        if (this.allEdges.add(e)) {
            ((Set)this.inEdges.get(e.target)).add(e);
            ((Set)this.outEdges.get(e.source)).add(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean addEdge(V src, V trgt) {
        return this.addEdge(new Edge<V, Object>(src, null, trgt));
    }

    @Override
    public boolean removeEdge(Edge<V, E> e) {
        if (this.allEdges.remove(e)) {
            ((Set)this.inEdges.get(e.target)).remove(e);
            ((Set)this.outEdges.get(e.source)).remove(e);
            return true;
        }
        return false;
    }

    @Override
    public Set<Edge<V, E>> removeEdges(V src, V trgt) {
        if (!this.allVertices.contains(src)) {
            throw new IllegalArgumentException("No such source-vertex in this graph!");
        }
        if (!this.allVertices.contains(trgt)) {
            throw new IllegalArgumentException("No such target-vertex in this graph!");
        }
        MatcherLinkedHashSet<Edge<V, Edge>> removed = new MatcherLinkedHashSet<Edge<V, Edge>>(8, this.EDGES_MATCHER);
        if (((Set)this.inEdges.get(trgt)).size() > ((Set)this.outEdges.get(src)).size()) {
            Set iterSet = (Set)this.outEdges.get(src);
            Iterator it = iterSet.iterator();
            while (it.hasNext()) {
                Edge next = (Edge)it.next();
                if (!next.target.equals(trgt)) continue;
                it.remove();
                this.allEdges.remove(next);
                ((Set)this.inEdges.get(trgt)).remove(next);
                removed.add(next);
            }
        } else {
            Set iterSet = (Set)this.inEdges.get(trgt);
            Iterator it = iterSet.iterator();
            while (it.hasNext()) {
                Edge next = (Edge)it.next();
                if (!next.source.equals(src)) continue;
                it.remove();
                this.allEdges.remove(next);
                ((Set)this.outEdges.get(src)).remove(next);
                removed.add(next);
            }
        }
        return removed;
    }

    @Override
    public Set<Edge<V, E>> copyEdgeSet() {
        return new MatcherLinkedHashSet<Edge<V, E>>(this.allEdges, this.EDGES_MATCHER);
    }

    @Override
    public Set<V> copyVertexSet() {
        return new MatcherLinkedHashSet<V>(this.allVertices, this.VERTEX_MATCHER);
    }

    @Override
    public Set<Edge<V, E>> copyIncomingEdges(V v) {
        if (!this.allVertices.contains(v)) {
            throw new IllegalArgumentException("No such vertex in this graph!");
        }
        return new MatcherLinkedHashSet<Edge<V, E>>((Set)this.inEdges.get(v), this.EDGES_MATCHER);
    }

    @Override
    public Set<Edge<V, E>> copyOutgoingEdges(V v) {
        if (!this.allVertices.contains(v)) {
            throw new IllegalArgumentException("No such vertex in this graph!");
        }
        return new MatcherLinkedHashSet<Edge<V, E>>((Set)this.outEdges.get(v), this.EDGES_MATCHER);
    }

    @Override
    public boolean containsEdge(Edge<V, E> e) {
        return this.allEdges.contains(e);
    }

    @Override
    public boolean containsEdge(V src, V trg) {
        for (Edge edge : (Set)this.outEdges.get(src)) {
            if (!edge.target.equals(trg)) continue;
            return true;
        }
        return false;
    }
}

