/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.cg.dyn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;

public class Instrumenter
implements ClassFileTransformer {
    static List<Pattern> pkgIncl = new ArrayList<Pattern>();
    static List<Pattern> pkgExcl = new ArrayList<Pattern>();

    public static void premain(String argument, Instrumentation instrumentation) {
        if (argument == null) {
            Instrumenter.err("Missing configuration argument");
            return;
        }
        Instrumenter.err("Argument is: " + argument);
        String[] tokens = argument.split(";");
        if (tokens.length < 1) {
            Instrumenter.err("Missing delimiter ;");
            return;
        }
        for (String token : tokens) {
            String[] patterns;
            String[] args = token.split("=");
            if (args.length < 2) {
                Instrumenter.err("Missing argument delimiter =:" + token);
                return;
            }
            String argtype = args[0];
            if (!argtype.equals("incl") && !argtype.equals("excl")) {
                Instrumenter.err("Wrong argument: " + argtype);
                return;
            }
            for (String pattern : patterns = args[1].split(",")) {
                Pattern p = null;
                Instrumenter.err("Compiling " + argtype + " pattern:" + pattern + "$");
                try {
                    p = Pattern.compile(pattern + "$");
                }
                catch (PatternSyntaxException pse) {
                    Instrumenter.err("pattern: " + pattern + " not valid, ignoring");
                }
                if (argtype.equals("incl")) {
                    pkgIncl.add(p);
                    continue;
                }
                pkgExcl.add(p);
            }
        }
        instrumentation.addTransformer(new Instrumenter());
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> clazz, ProtectionDomain domain, byte[] bytes) {
        Matcher m;
        boolean enhanceClass = false;
        String name = className.replace("/", ".");
        for (Pattern p : pkgIncl) {
            m = p.matcher(name);
            if (!m.matches()) continue;
            enhanceClass = true;
            break;
        }
        for (Pattern p : pkgExcl) {
            m = p.matcher(name);
            if (!m.matches()) continue;
            Instrumenter.err("Skipping class: " + name);
            enhanceClass = false;
            break;
        }
        if (enhanceClass) {
            return this.enhanceClass(className, bytes);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] enhanceClass(String name, byte[] b) {
        ClassPool pool = ClassPool.getDefault();
        CtClass clazz = null;
        try {
            clazz = pool.makeClass(new ByteArrayInputStream(b));
            if (!clazz.isInterface()) {
                Instrumenter.err("Enhancing class: " + name);
                CtBehavior[] methods = clazz.getDeclaredBehaviors();
                for (int i = 0; i < methods.length; ++i) {
                    if (methods[i].isEmpty()) continue;
                    this.enhanceMethod(methods[i], clazz.getName());
                }
                b = clazz.toBytecode();
            }
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
            Instrumenter.err("Cannot compile: " + e.getMessage());
        }
        catch (NotFoundException e) {
            e.printStackTrace();
            Instrumenter.err("Cannot find: " + e.getMessage());
        }
        catch (IOException e) {
            Instrumenter.err("Error writing: " + e.getMessage());
        }
        finally {
            if (clazz != null) {
                clazz.detach();
            }
        }
        return b;
    }

    private void enhanceMethod(CtBehavior method, String className) throws NotFoundException, CannotCompileException {
        String name = className.substring(className.lastIndexOf(46) + 1, className.length());
        String methodName = method.getName();
        if (method.getName().equals(name)) {
            methodName = "<init>";
        }
        method.insertBefore("gr.gousiosg.javacg.dyn.MethodStack.push(\"" + className + ":" + methodName + "\");");
        method.insertAfter("gr.gousiosg.javacg.dyn.MethodStack.pop();");
    }

    private static void err(String msg) {
    }
}

