# Contributing Guide

We would love for you to contribute to this project and help make it even better than it is today!
As a contributor, here are the guidelines we would like you to follow:

 - [Code of Conduct](#coc)
 - [Question or Problem?](#question)
 - [Issues and Bugs](#issue)
 - [Feature Requests](#feature)
 - [Submission Guidelines](#submit)


## <a name="coc"></a> Code of Conduct
Help us keep this community open and inclusive.

[Our code of conduct is located here.](https://github.com/permitio/opal/blob/master/CODE_OF_CONDUCT.md)

## <a name="question"></a> Got a Question or Problem?
Come talk to us about OPAL, or authorization in general - we would love to hear from you ❤️

You can:
- Raise questions in our [Github discussions](https://github.com/permitio/opal/discussions)
- Report issues and ask for features in [Github issues](https://github.com/permitio/opal/issues)
- Follow us on [Twitter](follow-twitter-link) to get the latest OPAL updates
- Join our [Slack community](join-slack-link) to chat about authorization, open-source, realtime communication, tech or anything else! We are super available on slack ;)


If you are using our project, please consider giving us a ⭐️
</br>
</br>

[![Button][join-slack-link]][badge-slack-link] </br> [![Button][follow-twitter-link]][badge-twitter-link]


[join-slack-link]: https://i.ibb.co/wzrGHQL/Group-749.png
[badge-slack-link]: https://bit.ly/opal-slack
[follow-twitter-link]: https://i.ibb.co/k4x55Lr/Group-750.png
[badge-twitter-link]: https://twitter.com/opal_ac

## <a name="issue"></a> Found a Bug?
If you find a bug in the source code, you can help us by [submitting an issue](#submit-issue) or even better, you can [submit a Pull Request](#submit-pr) with a fix.

## <a name="feature"></a> Missing a Feature?
You can *request* a new feature by [submitting an issue](#submit-issue) to our GitHub Repository.

## <a name="submit"></a> Submission Guidelines

### <a name="submit-issue"></a> Submitting an Issue

Issues are submitted to our [Github issues](https://github.com/permitio/opal/issues).

Before you submit an issue, please search the issue tracker, maybe an issue for your problem already exists and the discussion might inform you of workarounds readily available.

We want to fix all the issues as soon as possible, but before fixing a bug we need to reproduce and confirm it.
In order to reproduce bugs, we require that you provide:
- Full logs of opal server and opal client
- Your configuration for OPAL server and OPAL client
  - i.e: docker compose, Kubernetes YAMLs, environment variables, etc.
  - you should redact any secrets/tokens/api keys in your config

### <a name="submit-pr"></a> Submitting a Pull Request (PR)

PRs are submitted [here](https://github.com/permitio/opal/pulls).

- Pull requests are welcome! (please make sure to include *passing* tests and docs)
- Prior to submitting a PR - open an issue on GitHub, or make sure your PR addresses an existing issue well.