"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Parameter = exports.ParameterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const oos_generated_1 = require("./oos.generated");
Object.defineProperty(exports, "ParameterProperty", { enumerable: true, get: function () { return oos_generated_1.RosParameter; } });
/**
 * A ROS resource type:  `ALIYUN::OOS::Parameter`
 */
class Parameter extends ros.Resource {
    /**
     * Create a new `ALIYUN::OOS::Parameter`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosParameter = new oos_generated_1.RosParameter(this, id, {
            type: props.type,
            constraints: props.constraints,
            description: props.description,
            value: props.value,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosParameter;
        this.attrName = rosParameter.attrName;
        this.attrValue = rosParameter.attrValue;
    }
}
exports.Parameter = Parameter;
//# sourceMappingURL=data:application/json;base64,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