"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Execution = exports.ExecutionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const oos_generated_1 = require("./oos.generated");
Object.defineProperty(exports, "ExecutionProperty", { enumerable: true, get: function () { return oos_generated_1.RosExecution; } });
/**
 * A ROS resource type:  `ALIYUN::OOS::Execution`
 */
class Execution extends ros.Resource {
    /**
     * Create a new `ALIYUN::OOS::Execution`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosExecution = new oos_generated_1.RosExecution(this, id, {
            parentExecutionId: props.parentExecutionId,
            resourceOptions: props.resourceOptions,
            parameters: props.parameters,
            safetyCheck: props.safetyCheck ? props.safetyCheck : 'ConfirmEveryHighRiskAction',
            mode: props.mode ? props.mode : 'Automatic',
            templateName: props.templateName,
            templateVersion: props.templateVersion,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosExecution;
        this.attrCounters = rosExecution.attrCounters;
        this.attrCurlCli = rosExecution.attrCurlCli;
        this.attrExecutionId = rosExecution.attrExecutionId;
        this.attrOutputs = rosExecution.attrOutputs;
        this.attrPowerShellCurlCli = rosExecution.attrPowerShellCurlCli;
        this.attrStatus = rosExecution.attrStatus;
        this.attrStatusMessage = rosExecution.attrStatusMessage;
        this.attrWindowsCurlCli = rosExecution.attrWindowsCurlCli;
    }
}
exports.Execution = Execution;
//# sourceMappingURL=data:application/json;base64,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