# Copyright (c) 2004-2020 Adam Karpierz
# Licensed under CC BY-NC-ND 4.0
# Licensed under proprietary License
# Please refer to the accompanying LICENSE file.

import jni

from .. import embed


# Class: org.python.core.PyObject

# Method: native Object get_attr(long tstate, long pyobj, String name, Class<?> jclass) throws PyException;

@jni.method("(JJLjava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;")
def get_attr(env, this,
             tstate, pyobj, name, jclass):
    return embed.get_attr(env[0], tstate, pyobj, name, jclass)

# Method: native void set_attr(long tstate, long pyobj, String name, Object value);

@jni.method("(JJLjava/lang/String;Ljava/lang/Object;)V")
def set_attr(env, this,
             tstate, pyobj, name, value):
    return embed.set_attr(env[0], tstate, pyobj, name, value)

# Method: native void del_attr(long tstate, long pyobj, String name);

@jni.method("(JJLjava/lang/String;)V")
def del_attr(env, this,
             tstate, pyobj, name):
    return embed.del_attr(env[0], tstate, pyobj, name)

# Method: native boolean has_attr(long tstate, long pyobj, String name);

@jni.method("(JJLjava/lang/String;)Z")
def has_attr(env, this,
             tstate, pyobj, name):
    return embed.has_attr(env[0], tstate, pyobj, name)

# Method: native boolean py_eq(long tstate, long pyobj, Object other);

@jni.method("(JJLjava/lang/Object;)Z")
def py_eq(env, this,
          tstate, pyobj, other):
    return embed.py_eq(env[0], tstate, pyobj, other)

# Method: native long py_hash(long tstate, long pyobj);

@jni.method("(JJ)J")
def py_hash(env, this,
            tstate, pyobj):
    return embed.py_hash(env[0], tstate, pyobj)

# Method: native String py_str(long tstate, long pyobj);

@jni.method("(JJ)Ljava/lang/String;")
def py_str(env, this,
           tstate, pyobj):
    return embed.py_str(env[0], tstate, pyobj)

# Method: native long import_module(long tstate, long module, String name);

@jni.method("(JJLjava/lang/String;)J")
def import_module(env, this,
                  tstate, module, name):
    return embed.import_module(env[0], tstate, module, name)

# Method: native Object get_object(long tstate, long module, String name, Class<?> clazz);

@jni.method("(JJLjava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;")
def get_object(env, this,
               tstate, module, name, clazz):
    return embed.get_object(env[0], tstate, module, name, clazz)

# Method: native void incref(long tstate, long pyobj);

@jni.method("(JJ)V")
def incref(env, this,
           tstate, pyobj):
    return embed.incref(env[0], tstate, pyobj)

# Method: native void decref(long tstate, long pyobj);

@jni.method("(JJ)V")
def decref(env, this,
           tstate, pyobj):
    return embed.decref(env[0], tstate, pyobj)


__jnimethods__ = (
    get_attr,
    set_attr,
    del_attr,
    has_attr,
    py_eq,
    py_hash,
    py_str,
    import_module,
    get_object,
    incref,
    decref,
)

__javacode__ = bytearray(  # Auto-generated; DO NOT EDIT!
    b"\xca\xfe\xba\xbe\x00\x00\x00\x34\x00\x90\x0a\x00\x16\x00\x5c\x09\x00\x23\x00\x5d"
    b"\x07\x00\x5e\x08\x00\x5f\x0a\x00\x03\x00\x60\x09\x00\x23\x00\x61\x0a\x00\x23\x00"
    b"\x62\x0a\x00\x23\x00\x63\x0a\x00\x23\x00\x64\x0a\x00\x65\x00\x63\x07\x00\x66\x0a"
    b"\x00\x0b\x00\x5c\x0a\x00\x16\x00\x67\x0a\x00\x68\x00\x69\x0a\x00\x0b\x00\x6a\x08"
    b"\x00\x6b\x0a\x00\x0b\x00\x6c\x07\x00\x6d\x0a\x00\x12\x00\x6e\x09\x00\x65\x00\x6f"
    b"\x0a\x00\x23\x00\x70\x07\x00\x71\x0a\x00\x23\x00\x72\x0a\x00\x68\x00\x73\x0a\x00"
    b"\x23\x00\x74\x0a\x00\x23\x00\x75\x0a\x00\x23\x00\x76\x0a\x00\x23\x00\x77\x0a\x00"
    b"\x23\x00\x78\x0a\x00\x79\x00\x7a\x0a\x00\x79\x00\x7b\x0a\x00\x23\x00\x7c\x0a\x00"
    b"\x23\x00\x7d\x0a\x00\x23\x00\x7e\x07\x00\x7f\x07\x00\x80\x01\x00\x06\x69\x6e\x74"
    b"\x65\x72\x70\x01\x00\x23\x4c\x6f\x72\x67\x2f\x70\x79\x74\x68\x6f\x6e\x2f\x75\x74"
    b"\x69\x6c\x2f\x50\x79\x74\x68\x6f\x6e\x49\x6e\x74\x65\x72\x70\x72\x65\x74\x65\x72"
    b"\x3b\x01\x00\x05\x70\x79\x6f\x62\x6a\x01\x00\x01\x4a\x01\x00\x06\x3c\x69\x6e\x69"
    b"\x74\x3e\x01\x00\x27\x28\x4c\x6f\x72\x67\x2f\x70\x79\x74\x68\x6f\x6e\x2f\x75\x74"
    b"\x69\x6c\x2f\x50\x79\x74\x68\x6f\x6e\x49\x6e\x74\x65\x72\x70\x72\x65\x74\x65\x72"
    b"\x3b\x4a\x29\x56\x01\x00\x04\x43\x6f\x64\x65\x01\x00\x0d\x53\x74\x61\x63\x6b\x4d"
    b"\x61\x70\x54\x61\x62\x6c\x65\x07\x00\x7f\x07\x00\x81\x01\x00\x0a\x45\x78\x63\x65"
    b"\x70\x74\x69\x6f\x6e\x73\x01\x00\x05\x63\x6c\x6f\x73\x65\x01\x00\x03\x28\x29\x56"
    b"\x07\x00\x82\x01\x00\x0a\x63\x68\x65\x63\x6b\x56\x61\x6c\x69\x64\x01\x00\x11\x63"
    b"\x68\x65\x63\x6b\x56\x61\x6c\x69\x64\x52\x75\x6e\x74\x69\x6d\x65\x07\x00\x5e\x01"
    b"\x00\x07\x68\x61\x73\x41\x74\x74\x72\x01\x00\x15\x28\x4c\x6a\x61\x76\x61\x2f\x6c"
    b"\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x5a\x01\x00\x07\x67\x65\x74\x41"
    b"\x74\x74\x72\x01\x00\x26\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74"
    b"\x72\x69\x6e\x67\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a"
    b"\x65\x63\x74\x3b\x01\x00\x37\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53"
    b"\x74\x72\x69\x6e\x67\x3b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x43\x6c\x61"
    b"\x73\x73\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63"
    b"\x74\x3b\x01\x00\x09\x53\x69\x67\x6e\x61\x74\x75\x72\x65\x01\x00\x43\x3c\x54\x3a"
    b"\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74\x3b\x3e\x28"
    b"\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x4c\x6a"
    b"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x43\x6c\x61\x73\x73\x3c\x54\x54\x3b\x3e\x3b"
    b"\x29\x54\x54\x3b\x01\x00\x07\x73\x65\x74\x41\x74\x74\x72\x01\x00\x27\x28\x4c\x6a"
    b"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x4c\x6a\x61\x76"
    b"\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74\x3b\x29\x56\x01\x00\x07\x64"
    b"\x65\x6c\x41\x74\x74\x72\x01\x00\x15\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67"
    b"\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x56\x01\x00\x08\x68\x61\x73\x5f\x61\x74\x74"
    b"\x72\x01\x00\x17\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74"
    b"\x72\x69\x6e\x67\x3b\x29\x5a\x01\x00\x08\x67\x65\x74\x5f\x61\x74\x74\x72\x01\x00"
    b"\x39\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e"
    b"\x67\x3b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x43\x6c\x61\x73\x73\x3b\x29"
    b"\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74\x3b\x01\x00"
    b"\x3c\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e"
    b"\x67\x3b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x43\x6c\x61\x73\x73\x3c\x2a"
    b"\x3e\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74"
    b"\x3b\x01\x00\x08\x73\x65\x74\x5f\x61\x74\x74\x72\x01\x00\x29\x28\x4a\x4a\x4c\x6a"
    b"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x4c\x6a\x61\x76"
    b"\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74\x3b\x29\x56\x01\x00\x08\x64"
    b"\x65\x6c\x5f\x61\x74\x74\x72\x01\x00\x17\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c"
    b"\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x56\x01\x00\x06\x65\x71\x75\x61"
    b"\x6c\x73\x01\x00\x15\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a"
    b"\x65\x63\x74\x3b\x29\x5a\x01\x00\x08\x68\x61\x73\x68\x43\x6f\x64\x65\x01\x00\x03"
    b"\x28\x29\x49\x01\x00\x08\x74\x6f\x53\x74\x72\x69\x6e\x67\x01\x00\x14\x28\x29\x4c"
    b"\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x01\x00\x05"
    b"\x70\x79\x5f\x65\x71\x01\x00\x17\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e"
    b"\x67\x2f\x4f\x62\x6a\x65\x63\x74\x3b\x29\x5a\x01\x00\x07\x70\x79\x5f\x68\x61\x73"
    b"\x68\x01\x00\x05\x28\x4a\x4a\x29\x4a\x01\x00\x06\x70\x79\x5f\x73\x74\x72\x01\x00"
    b"\x16\x28\x4a\x4a\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69"
    b"\x6e\x67\x3b\x01\x00\x0d\x69\x6d\x70\x6f\x72\x74\x5f\x6d\x6f\x64\x75\x6c\x65\x01"
    b"\x00\x17\x28\x4a\x4a\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69"
    b"\x6e\x67\x3b\x29\x4a\x01\x00\x0a\x67\x65\x74\x5f\x6f\x62\x6a\x65\x63\x74\x01\x00"
    b"\x06\x69\x6e\x63\x72\x65\x66\x01\x00\x06\x64\x65\x63\x72\x65\x66\x01\x00\x05\x28"
    b"\x4a\x4a\x29\x56\x0c\x00\x29\x00\x31\x0c\x00\x27\x00\x28\x01\x00\x1b\x6f\x72\x67"
    b"\x2f\x70\x79\x74\x68\x6f\x6e\x2f\x63\x6f\x72\x65\x2f\x50\x79\x45\x78\x63\x65\x70"
    b"\x74\x69\x6f\x6e\x01\x00\x1e\x55\x6e\x61\x62\x6c\x65\x20\x74\x6f\x20\x63\x72\x65"
    b"\x61\x74\x65\x20\x6f\x62\x6a\x65\x63\x74\x2c\x20\x4e\x55\x4c\x4c\x2e\x0c\x00\x29"
    b"\x00\x40\x0c\x00\x25\x00\x26\x0c\x00\x59\x00\x31\x0c\x00\x33\x00\x31\x0c\x00\x5a"
    b"\x00\x31\x07\x00\x81\x01\x00\x17\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74"
    b"\x72\x69\x6e\x67\x42\x75\x69\x6c\x64\x65\x72\x0c\x00\x83\x00\x84\x07\x00\x85\x0c"
    b"\x00\x86\x00\x4f\x0c\x00\x87\x00\x88\x01\x00\x11\x20\x68\x61\x73\x20\x62\x65\x65"
    b"\x6e\x20\x63\x6c\x6f\x73\x65\x64\x2e\x0c\x00\x4e\x00\x4f\x01\x00\x1f\x6a\x61\x76"
    b"\x61\x2f\x6c\x61\x6e\x67\x2f\x49\x6c\x6c\x65\x67\x61\x6c\x53\x74\x61\x74\x65\x45"
    b"\x78\x63\x65\x70\x74\x69\x6f\x6e\x0c\x00\x29\x00\x89\x0c\x00\x8a\x00\x28\x0c\x00"
    b"\x41\x00\x42\x01\x00\x10\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65"
    b"\x63\x74\x0c\x00\x43\x00\x44\x0c\x00\x8b\x00\x8c\x0c\x00\x46\x00\x47\x0c\x00\x48"
    b"\x00\x49\x0c\x00\x34\x00\x31\x0c\x00\x50\x00\x51\x0c\x00\x52\x00\x53\x07\x00\x8d"
    b"\x0c\x00\x8e\x00\x8f\x0c\x00\x4c\x00\x4d\x0c\x00\x54\x00\x55\x0c\x00\x59\x00\x5b"
    b"\x0c\x00\x5a\x00\x5b\x01\x00\x18\x6f\x72\x67\x2f\x70\x79\x74\x68\x6f\x6e\x2f\x63"
    b"\x6f\x72\x65\x2f\x50\x79\x4f\x62\x6a\x65\x63\x74\x01\x00\x17\x6a\x61\x76\x61\x2f"
    b"\x6c\x61\x6e\x67\x2f\x41\x75\x74\x6f\x43\x6c\x6f\x73\x65\x61\x62\x6c\x65\x01\x00"
    b"\x21\x6f\x72\x67\x2f\x70\x79\x74\x68\x6f\x6e\x2f\x75\x74\x69\x6c\x2f\x50\x79\x74"
    b"\x68\x6f\x6e\x49\x6e\x74\x65\x72\x70\x72\x65\x74\x65\x72\x01\x00\x13\x6a\x61\x76"
    b"\x61\x2f\x6c\x61\x6e\x67\x2f\x54\x68\x72\x6f\x77\x61\x62\x6c\x65\x01\x00\x08\x67"
    b"\x65\x74\x43\x6c\x61\x73\x73\x01\x00\x13\x28\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61"
    b"\x6e\x67\x2f\x43\x6c\x61\x73\x73\x3b\x01\x00\x0f\x6a\x61\x76\x61\x2f\x6c\x61\x6e"
    b"\x67\x2f\x43\x6c\x61\x73\x73\x01\x00\x0d\x67\x65\x74\x53\x69\x6d\x70\x6c\x65\x4e"
    b"\x61\x6d\x65\x01\x00\x06\x61\x70\x70\x65\x6e\x64\x01\x00\x2d\x28\x4c\x6a\x61\x76"
    b"\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x4c\x6a\x61\x76\x61"
    b"\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x42\x75\x69\x6c\x64\x65\x72\x3b"
    b"\x01\x00\x18\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x54\x68\x72\x6f\x77"
    b"\x61\x62\x6c\x65\x3b\x29\x56\x01\x00\x06\x74\x73\x74\x61\x74\x65\x01\x00\x04\x63"
    b"\x61\x73\x74\x01\x00\x26\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62"
    b"\x6a\x65\x63\x74\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a"
    b"\x65\x63\x74\x3b\x01\x00\x0e\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4c\x6f\x6e"
    b"\x67\x01\x00\x07\x76\x61\x6c\x75\x65\x4f\x66\x01\x00\x13\x28\x4a\x29\x4c\x6a\x61"
    b"\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4c\x6f\x6e\x67\x3b\x00\x21\x00\x23\x00\x16\x00"
    b"\x01\x00\x24\x00\x02\x00\x14\x00\x25\x00\x26\x00\x00\x00\x04\x00\x27\x00\x28\x00"
    b"\x00\x00\x19\x00\x01\x00\x29\x00\x2a\x00\x02\x00\x2b\x00\x00\x00\x4a\x00\x04\x00"
    b"\x04\x00\x00\x00\x28\x2a\xb7\x00\x01\x2a\x09\xb5\x00\x02\x20\x09\x94\x9a\x00\x0d"
    b"\xbb\x00\x03\x59\x12\x04\xb7\x00\x05\xbf\x2a\x2b\xb5\x00\x06\x2a\x20\xb5\x00\x02"
    b"\x2a\xb6\x00\x07\xb1\x00\x00\x00\x01\x00\x2c\x00\x00\x00\x10\x00\x01\xff\x00\x19"
    b"\x00\x03\x07\x00\x2d\x07\x00\x2e\x04\x00\x00\x00\x2f\x00\x00\x00\x04\x00\x01\x00"
    b"\x03\x00\x01\x00\x30\x00\x31\x00\x02\x00\x2b\x00\x00\x00\x45\x00\x04\x00\x02\x00"
    b"\x00\x00\x23\x2a\xb4\x00\x02\x09\x94\x9a\x00\x04\xb1\x2a\xb6\x00\x08\x2a\xb6\x00"
    b"\x09\x2a\x09\xb5\x00\x02\xa7\x00\x0b\x4c\x2a\x09\xb5\x00\x02\x2b\xbf\xb1\x00\x01"
    b"\x00\x0e\x00\x12\x00\x1a\x00\x00\x00\x01\x00\x2c\x00\x00\x00\x08\x00\x03\x0a\x4f"
    b"\x07\x00\x32\x07\x00\x2f\x00\x00\x00\x04\x00\x01\x00\x03\x00\x04\x00\x33\x00\x31"
    b"\x00\x02\x00\x2b\x00\x00\x00\x47\x00\x04\x00\x01\x00\x00\x00\x32\x2a\xb4\x00\x06"
    b"\xb6\x00\x0a\x2a\xb4\x00\x02\x09\x94\x9a\x00\x24\xbb\x00\x03\x59\xbb\x00\x0b\x59"
    b"\xb7\x00\x0c\x2a\xb6\x00\x0d\xb6\x00\x0e\xb6\x00\x0f\x12\x10\xb6\x00\x0f\xb6\x00"
    b"\x11\xb7\x00\x05\xbf\xb1\x00\x00\x00\x01\x00\x2c\x00\x00\x00\x03\x00\x01\x31\x00"
    b"\x2f\x00\x00\x00\x04\x00\x01\x00\x03\x00\x04\x00\x34\x00\x31\x00\x02\x00\x2b\x00"
    b"\x00\x00\x33\x00\x03\x00\x02\x00\x00\x00\x12\x2a\xb6\x00\x08\xa7\x00\x0d\x4c\xbb"
    b"\x00\x12\x59\x2b\xb7\x00\x13\xbf\xb1\x00\x01\x00\x00\x00\x04\x00\x07\x00\x03\x00"
    b"\x01\x00\x2c\x00\x00\x00\x07\x00\x02\x47\x07\x00\x35\x09\x00\x2f\x00\x00\x00\x04"
    b"\x00\x01\x00\x12\x00\x01\x00\x36\x00\x37\x00\x02\x00\x2b\x00\x00\x00\x21\x00\x06"
    b"\x00\x02\x00\x00\x00\x15\x2a\xb6\x00\x08\x2a\x2a\xb4\x00\x06\xb4\x00\x14\x2a\xb4"
    b"\x00\x02\x2b\xb7\x00\x15\xac\x00\x00\x00\x00\x00\x2f\x00\x00\x00\x04\x00\x01\x00"
    b"\x03\x00\x01\x00\x38\x00\x39\x00\x02\x00\x2b\x00\x00\x00\x23\x00\x07\x00\x02\x00"
    b"\x00\x00\x17\x2a\xb6\x00\x08\x2a\x2a\xb4\x00\x06\xb4\x00\x14\x2a\xb4\x00\x02\x2b"
    b"\x12\x16\xb7\x00\x17\xb0\x00\x00\x00\x00\x00\x2f\x00\x00\x00\x04\x00\x01\x00\x03"
    b"\x00\x01\x00\x38\x00\x3a\x00\x03\x00\x2b\x00\x00\x00\x26\x00\x08\x00\x03\x00\x00"
    b"\x00\x1a\x2a\xb6\x00\x08\x2c\x2a\x2a\xb4\x00\x06\xb4\x00\x14\x2a\xb4\x00\x02\x2b"
    b"\x2c\xb7\x00\x17\xb6\x00\x18\xb0\x00\x00\x00\x00\x00\x2f\x00\x00\x00\x04\x00\x01"
    b"\x00\x03\x00\x3b\x00\x00\x00\x02\x00\x3c\x00\x01\x00\x3d\x00\x3e\x00\x02\x00\x2b"
    b"\x00\x00\x00\x22\x00\x07\x00\x03\x00\x00\x00\x16\x2a\xb6\x00\x08\x2a\x2a\xb4\x00"
    b"\x06\xb4\x00\x14\x2a\xb4\x00\x02\x2b\x2c\xb7\x00\x19\xb1\x00\x00\x00\x00\x00\x2f"
    b"\x00\x00\x00\x04\x00\x01\x00\x03\x00\x01\x00\x3f\x00\x40\x00\x02\x00\x2b\x00\x00"
    b"\x00\x21\x00\x06\x00\x02\x00\x00\x00\x15\x2a\xb6\x00\x08\x2a\x2a\xb4\x00\x06\xb4"
    b"\x00\x14\x2a\xb4\x00\x02\x2b\xb7\x00\x1a\xb1\x00\x00\x00\x00\x00\x2f\x00\x00\x00"
    b"\x04\x00\x01\x00\x03\x01\x02\x00\x41\x00\x42\x00\x00\x01\x02\x00\x43\x00\x44\x00"
    b"\x02\x00\x2f\x00\x00\x00\x04\x00\x01\x00\x03\x00\x3b\x00\x00\x00\x02\x00\x45\x01"
    b"\x02\x00\x46\x00\x47\x00\x01\x00\x2f\x00\x00\x00\x04\x00\x01\x00\x03\x01\x02\x00"
    b"\x48\x00\x49\x00\x01\x00\x2f\x00\x00\x00\x04\x00\x01\x00\x03\x00\x01\x00\x4a\x00"
    b"\x4b\x00\x01\x00\x2b\x00\x00\x00\x44\x00\x06\x00\x02\x00\x00\x00\x2d\x2b\x2a\xa6"
    b"\x00\x05\x04\xac\x2b\xc6\x00\x0e\x2b\xb6\x00\x0d\x2a\xb6\x00\x0d\xa5\x00\x05\x03"
    b"\xac\x2a\xb6\x00\x1b\x2a\x2a\xb4\x00\x06\xb4\x00\x14\x2a\xb4\x00\x02\x2b\xb7\x00"
    b"\x1c\xac\x00\x00\x00\x01\x00\x2c\x00\x00\x00\x05\x00\x03\x07\x0e\x01\x00\x01\x00"
    b"\x4c\x00\x4d\x00\x01\x00\x2b\x00\x00\x00\x28\x00\x05\x00\x02\x00\x00\x00\x1c\x2a"
    b"\xb6\x00\x1b\x2a\x2a\xb4\x00\x06\xb4\x00\x14\x2a\xb4\x00\x02\xb7\x00\x1d\xb8\x00"
    b"\x1e\x4c\x2b\xb6\x00\x1f\xac\x00\x00\x00\x00\x00\x01\x00\x4e\x00\x4f\x00\x01\x00"
    b"\x2b\x00\x00\x00\x20\x00\x05\x00\x01\x00\x00\x00\x14\x2a\xb6\x00\x1b\x2a\x2a\xb4"
    b"\x00\x06\xb4\x00\x14\x2a\xb4\x00\x02\xb7\x00\x20\xb0\x00\x00\x00\x00\x01\x02\x00"
    b"\x50\x00\x51\x00\x00\x01\x02\x00\x52\x00\x53\x00\x00\x01\x02\x00\x54\x00\x55\x00"
    b"\x00\x01\x04\x00\x56\x00\x57\x00\x01\x00\x2f\x00\x00\x00\x04\x00\x01\x00\x03\x01"
    b"\x04\x00\x58\x00\x44\x00\x02\x00\x2f\x00\x00\x00\x04\x00\x01\x00\x03\x00\x3b\x00"
    b"\x00\x00\x02\x00\x45\x00\x01\x00\x59\x00\x31\x00\x02\x00\x2b\x00\x00\x00\x20\x00"
    b"\x05\x00\x01\x00\x00\x00\x14\x2a\xb6\x00\x08\x2a\x2a\xb4\x00\x06\xb4\x00\x14\x2a"
    b"\xb4\x00\x02\xb7\x00\x21\xb1\x00\x00\x00\x00\x00\x2f\x00\x00\x00\x04\x00\x01\x00"
    b"\x03\x00\x01\x00\x5a\x00\x31\x00\x02\x00\x2b\x00\x00\x00\x20\x00\x05\x00\x01\x00"
    b"\x00\x00\x14\x2a\xb6\x00\x08\x2a\x2a\xb4\x00\x06\xb4\x00\x14\x2a\xb4\x00\x02\xb7"
    b"\x00\x22\xb1\x00\x00\x00\x00\x00\x2f\x00\x00\x00\x04\x00\x01\x00\x03\x01\x02\x00"
    b"\x59\x00\x5b\x00\x01\x00\x2f\x00\x00\x00\x04\x00\x01\x00\x03\x01\x02\x00\x5a\x00"
    b"\x5b\x00\x01\x00\x2f\x00\x00\x00\x04\x00\x01\x00\x03\x00\x00"
)
