import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback } from 'react';
import { ariaDescribedByIds, enumOptionsIndexForValue, enumOptionsValueForIndex, } from '@rjsf/utils';
function getValue(event, multiple) {
    if (multiple) {
        return Array.from(event.target.options)
            .slice()
            .filter((o) => o.selected)
            .map((o) => o.value);
    }
    return event.target.value;
}
/** The `SelectWidget` is a widget for rendering dropdowns.
 *  It is typically used with string properties constrained with enum options.
 *
 * @param props - The `WidgetProps` for this component
 */
function SelectWidget({ schema, id, options, value, required, disabled, readonly, multiple = false, autofocus = false, onChange, onBlur, onFocus, placeholder, }) {
    const { enumOptions, enumDisabled, emptyValue: optEmptyVal } = options;
    const emptyValue = multiple ? [] : '';
    const handleFocus = useCallback((event) => {
        const newValue = getValue(event, multiple);
        return onFocus(id, enumOptionsValueForIndex(newValue, enumOptions, optEmptyVal));
    }, [onFocus, id, schema, multiple, enumOptions, optEmptyVal]);
    const handleBlur = useCallback((event) => {
        const newValue = getValue(event, multiple);
        return onBlur(id, enumOptionsValueForIndex(newValue, enumOptions, optEmptyVal));
    }, [onBlur, id, schema, multiple, enumOptions, optEmptyVal]);
    const handleChange = useCallback((event) => {
        const newValue = getValue(event, multiple);
        return onChange(enumOptionsValueForIndex(newValue, enumOptions, optEmptyVal));
    }, [onChange, schema, multiple, enumOptions, optEmptyVal]);
    const selectedIndexes = enumOptionsIndexForValue(value, enumOptions, multiple);
    const showPlaceholderOption = !multiple && schema.default === undefined;
    return (_jsxs("select", { id: id, name: id, multiple: multiple, className: 'form-control', value: typeof selectedIndexes === 'undefined' ? emptyValue : selectedIndexes, required: required, disabled: disabled || readonly, autoFocus: autofocus, onBlur: handleBlur, onFocus: handleFocus, onChange: handleChange, "aria-describedby": ariaDescribedByIds(id), children: [showPlaceholderOption && _jsx("option", { value: '', children: placeholder }), Array.isArray(enumOptions) &&
                enumOptions.map(({ value, label }, i) => {
                    const disabled = enumDisabled && enumDisabled.indexOf(value) !== -1;
                    return (_jsx("option", { value: String(i), disabled: disabled, children: label }, i));
                })] }));
}
export default SelectWidget;
//# sourceMappingURL=SelectWidget.js.map