import React, { ReactNode } from 'react';
export declare const TABLE_CLASS = "jp-sortable-table";
/**
 * A namespace for Table.
 */
export declare namespace Table {
    /**
     * The state which will be restored from layout tracker.
     */
    interface ISortState {
        sortKey?: string | null;
        sortDirection: -1 | 1;
    }
    /**
     * The initialization options for the table.
     */
    interface IOptions<T> extends Partial<ISortState> {
        rows: IRow<T>[];
        columns: IColumn<T>[];
        onRowClick?: React.MouseEventHandler<HTMLTableRowElement>;
        blankIndicator: () => ReactNode;
    }
    /**
     * Table row with data to display.
     */
    interface IRow<T> {
        data: T;
        key: string;
    }
    /**
     * Column definition.
     */
    interface IColumn<T> {
        id: string;
        label: string;
        renderCell(data: T): ReactNode;
        sort(a: T, b: T): number | undefined;
        isAvailable?(): boolean;
        isHidden?: boolean;
    }
}
/**
 * Sortable table component for small datasets.
 *
 * For large datasets use `DataGrid` from `@lumino/datagrid`.
 */
export declare function Table<T>(props: Table.IOptions<T>): JSX.Element;
