"use strict";
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.SESMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class SESMetrics {
    static bounceSum(dimensions) {
        return {
            namespace: 'AWS/SES',
            metricName: 'Bounce',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static clickSum(dimensions) {
        return {
            namespace: 'AWS/SES',
            metricName: 'Click',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static complaintSum(dimensions) {
        return {
            namespace: 'AWS/SES',
            metricName: 'Complaint',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static deliverySum(dimensions) {
        return {
            namespace: 'AWS/SES',
            metricName: 'Delivery',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static openSum(dimensions) {
        return {
            namespace: 'AWS/SES',
            metricName: 'Open',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static rejectSum(dimensions) {
        return {
            namespace: 'AWS/SES',
            metricName: 'Reject',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static renderingFailureSum(dimensions) {
        return {
            namespace: 'AWS/SES',
            metricName: 'RenderingFailure',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static reputationBounceRateAverage(dimensions) {
        return {
            namespace: 'AWS/SES',
            metricName: 'Reputation.BounceRate',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static reputationComplaintRateAverage(dimensions) {
        return {
            namespace: 'AWS/SES',
            metricName: 'Reputation.ComplaintRate',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static sendSum(dimensions) {
        return {
            namespace: 'AWS/SES',
            metricName: 'Send',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
}
exports.SESMetrics = SESMetrics;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2VzLWNhbm5lZC1tZXRyaWNzLmdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNlcy1jYW5uZWQtbWV0cmljcy5nZW5lcmF0ZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLCtFQUErRTs7O0FBRS9FLDRCQUE0QixDQUFDLGlFQUFpRTtBQUU5RixNQUFhLFVBQVU7SUFHZCxNQUFNLENBQUMsU0FBUyxDQUFDLFVBQWU7UUFDckMsT0FBTztZQUNMLFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSxRQUFRO1lBQ3BCLGFBQWEsRUFBRSxVQUFVO1lBQ3pCLFNBQVMsRUFBRSxLQUFLO1NBQ2pCLENBQUM7S0FDSDtJQUdNLE1BQU0sQ0FBQyxRQUFRLENBQUMsVUFBZTtRQUNwQyxPQUFPO1lBQ0wsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLE9BQU87WUFDbkIsYUFBYSxFQUFFLFVBQVU7WUFDekIsU0FBUyxFQUFFLEtBQUs7U0FDakIsQ0FBQztLQUNIO0lBR00sTUFBTSxDQUFDLFlBQVksQ0FBQyxVQUFlO1FBQ3hDLE9BQU87WUFDTCxTQUFTLEVBQUUsU0FBUztZQUNwQixVQUFVLEVBQUUsV0FBVztZQUN2QixhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7SUFHTSxNQUFNLENBQUMsV0FBVyxDQUFDLFVBQWU7UUFDdkMsT0FBTztZQUNMLFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSxVQUFVO1lBQ3RCLGFBQWEsRUFBRSxVQUFVO1lBQ3pCLFNBQVMsRUFBRSxLQUFLO1NBQ2pCLENBQUM7S0FDSDtJQUdNLE1BQU0sQ0FBQyxPQUFPLENBQUMsVUFBZTtRQUNuQyxPQUFPO1lBQ0wsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLE1BQU07WUFDbEIsYUFBYSxFQUFFLFVBQVU7WUFDekIsU0FBUyxFQUFFLEtBQUs7U0FDakIsQ0FBQztLQUNIO0lBR00sTUFBTSxDQUFDLFNBQVMsQ0FBQyxVQUFlO1FBQ3JDLE9BQU87WUFDTCxTQUFTLEVBQUUsU0FBUztZQUNwQixVQUFVLEVBQUUsUUFBUTtZQUNwQixhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7SUFHTSxNQUFNLENBQUMsbUJBQW1CLENBQUMsVUFBZTtRQUMvQyxPQUFPO1lBQ0wsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLGtCQUFrQjtZQUM5QixhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7SUFHTSxNQUFNLENBQUMsMkJBQTJCLENBQUMsVUFBZTtRQUN2RCxPQUFPO1lBQ0wsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLHVCQUF1QjtZQUNuQyxhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsU0FBUztTQUNyQixDQUFDO0tBQ0g7SUFHTSxNQUFNLENBQUMsOEJBQThCLENBQUMsVUFBZTtRQUMxRCxPQUFPO1lBQ0wsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLDBCQUEwQjtZQUN0QyxhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsU0FBUztTQUNyQixDQUFDO0tBQ0g7SUFHTSxNQUFNLENBQUMsT0FBTyxDQUFDLFVBQWU7UUFDbkMsT0FBTztZQUNMLFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSxNQUFNO1lBQ2xCLGFBQWEsRUFBRSxVQUFVO1lBQ3pCLFNBQVMsRUFBRSxLQUFLO1NBQ2pCLENBQUM7S0FDSDtDQUNGO0FBckdELGdDQXFHQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDEyLTIwMjIgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblxuLyogZXNsaW50LWRpc2FibGUgbWF4LWxlbiAqLyAvLyBUaGlzIGlzIGdlbmVyYXRlZCBjb2RlIC0gbGluZSBsZW5ndGhzIGFyZSBkaWZmaWN1bHQgdG8gY29udHJvbFxuXG5leHBvcnQgY2xhc3MgU0VTTWV0cmljcyB7XG4gIHB1YmxpYyBzdGF0aWMgYm91bmNlU3VtKGRpbWVuc2lvbnM6IHsgUnVsZU5hbWU6IHN0cmluZyB9KTogTWV0cmljV2l0aERpbXM8eyBSdWxlTmFtZTogc3RyaW5nIH0+O1xuICBwdWJsaWMgc3RhdGljIGJvdW5jZVN1bShkaW1lbnNpb25zOiB7ICdzZXM6Y29uZmlndXJhdGlvbi1zZXQnOiBzdHJpbmcgfSk6IE1ldHJpY1dpdGhEaW1zPHsgJ3Nlczpjb25maWd1cmF0aW9uLXNldCc6IHN0cmluZyB9PjtcbiAgcHVibGljIHN0YXRpYyBib3VuY2VTdW0oZGltZW5zaW9uczogYW55KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9TRVMnLFxuICAgICAgbWV0cmljTmFtZTogJ0JvdW5jZScsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICB9O1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgY2xpY2tTdW0oZGltZW5zaW9uczogeyBSdWxlTmFtZTogc3RyaW5nIH0pOiBNZXRyaWNXaXRoRGltczx7IFJ1bGVOYW1lOiBzdHJpbmcgfT47XG4gIHB1YmxpYyBzdGF0aWMgY2xpY2tTdW0oZGltZW5zaW9uczogeyAnc2VzOmNvbmZpZ3VyYXRpb24tc2V0Jzogc3RyaW5nIH0pOiBNZXRyaWNXaXRoRGltczx7ICdzZXM6Y29uZmlndXJhdGlvbi1zZXQnOiBzdHJpbmcgfT47XG4gIHB1YmxpYyBzdGF0aWMgY2xpY2tTdW0oZGltZW5zaW9uczogYW55KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9TRVMnLFxuICAgICAgbWV0cmljTmFtZTogJ0NsaWNrJyxcbiAgICAgIGRpbWVuc2lvbnNNYXA6IGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyBjb21wbGFpbnRTdW0oZGltZW5zaW9uczogeyBSdWxlTmFtZTogc3RyaW5nIH0pOiBNZXRyaWNXaXRoRGltczx7IFJ1bGVOYW1lOiBzdHJpbmcgfT47XG4gIHB1YmxpYyBzdGF0aWMgY29tcGxhaW50U3VtKGRpbWVuc2lvbnM6IHsgJ3Nlczpjb25maWd1cmF0aW9uLXNldCc6IHN0cmluZyB9KTogTWV0cmljV2l0aERpbXM8eyAnc2VzOmNvbmZpZ3VyYXRpb24tc2V0Jzogc3RyaW5nIH0+O1xuICBwdWJsaWMgc3RhdGljIGNvbXBsYWludFN1bShkaW1lbnNpb25zOiBhbnkpIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL1NFUycsXG4gICAgICBtZXRyaWNOYW1lOiAnQ29tcGxhaW50JyxcbiAgICAgIGRpbWVuc2lvbnNNYXA6IGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyBkZWxpdmVyeVN1bShkaW1lbnNpb25zOiB7IFJ1bGVOYW1lOiBzdHJpbmcgfSk6IE1ldHJpY1dpdGhEaW1zPHsgUnVsZU5hbWU6IHN0cmluZyB9PjtcbiAgcHVibGljIHN0YXRpYyBkZWxpdmVyeVN1bShkaW1lbnNpb25zOiB7ICdzZXM6Y29uZmlndXJhdGlvbi1zZXQnOiBzdHJpbmcgfSk6IE1ldHJpY1dpdGhEaW1zPHsgJ3Nlczpjb25maWd1cmF0aW9uLXNldCc6IHN0cmluZyB9PjtcbiAgcHVibGljIHN0YXRpYyBkZWxpdmVyeVN1bShkaW1lbnNpb25zOiBhbnkpIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL1NFUycsXG4gICAgICBtZXRyaWNOYW1lOiAnRGVsaXZlcnknLFxuICAgICAgZGltZW5zaW9uc01hcDogZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIG9wZW5TdW0oZGltZW5zaW9uczogeyBSdWxlTmFtZTogc3RyaW5nIH0pOiBNZXRyaWNXaXRoRGltczx7IFJ1bGVOYW1lOiBzdHJpbmcgfT47XG4gIHB1YmxpYyBzdGF0aWMgb3BlblN1bShkaW1lbnNpb25zOiB7ICdzZXM6Y29uZmlndXJhdGlvbi1zZXQnOiBzdHJpbmcgfSk6IE1ldHJpY1dpdGhEaW1zPHsgJ3Nlczpjb25maWd1cmF0aW9uLXNldCc6IHN0cmluZyB9PjtcbiAgcHVibGljIHN0YXRpYyBvcGVuU3VtKGRpbWVuc2lvbnM6IGFueSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvU0VTJyxcbiAgICAgIG1ldHJpY05hbWU6ICdPcGVuJyxcbiAgICAgIGRpbWVuc2lvbnNNYXA6IGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyByZWplY3RTdW0oZGltZW5zaW9uczogeyBSdWxlTmFtZTogc3RyaW5nIH0pOiBNZXRyaWNXaXRoRGltczx7IFJ1bGVOYW1lOiBzdHJpbmcgfT47XG4gIHB1YmxpYyBzdGF0aWMgcmVqZWN0U3VtKGRpbWVuc2lvbnM6IHsgJ3Nlczpjb25maWd1cmF0aW9uLXNldCc6IHN0cmluZyB9KTogTWV0cmljV2l0aERpbXM8eyAnc2VzOmNvbmZpZ3VyYXRpb24tc2V0Jzogc3RyaW5nIH0+O1xuICBwdWJsaWMgc3RhdGljIHJlamVjdFN1bShkaW1lbnNpb25zOiBhbnkpIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL1NFUycsXG4gICAgICBtZXRyaWNOYW1lOiAnUmVqZWN0JyxcbiAgICAgIGRpbWVuc2lvbnNNYXA6IGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyByZW5kZXJpbmdGYWlsdXJlU3VtKGRpbWVuc2lvbnM6IHsgUnVsZU5hbWU6IHN0cmluZyB9KTogTWV0cmljV2l0aERpbXM8eyBSdWxlTmFtZTogc3RyaW5nIH0+O1xuICBwdWJsaWMgc3RhdGljIHJlbmRlcmluZ0ZhaWx1cmVTdW0oZGltZW5zaW9uczogeyAnc2VzOmNvbmZpZ3VyYXRpb24tc2V0Jzogc3RyaW5nIH0pOiBNZXRyaWNXaXRoRGltczx7ICdzZXM6Y29uZmlndXJhdGlvbi1zZXQnOiBzdHJpbmcgfT47XG4gIHB1YmxpYyBzdGF0aWMgcmVuZGVyaW5nRmFpbHVyZVN1bShkaW1lbnNpb25zOiBhbnkpIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL1NFUycsXG4gICAgICBtZXRyaWNOYW1lOiAnUmVuZGVyaW5nRmFpbHVyZScsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICB9O1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgcmVwdXRhdGlvbkJvdW5jZVJhdGVBdmVyYWdlKGRpbWVuc2lvbnM6IHsgUnVsZU5hbWU6IHN0cmluZyB9KTogTWV0cmljV2l0aERpbXM8eyBSdWxlTmFtZTogc3RyaW5nIH0+O1xuICBwdWJsaWMgc3RhdGljIHJlcHV0YXRpb25Cb3VuY2VSYXRlQXZlcmFnZShkaW1lbnNpb25zOiB7ICdzZXM6Y29uZmlndXJhdGlvbi1zZXQnOiBzdHJpbmcgfSk6IE1ldHJpY1dpdGhEaW1zPHsgJ3Nlczpjb25maWd1cmF0aW9uLXNldCc6IHN0cmluZyB9PjtcbiAgcHVibGljIHN0YXRpYyByZXB1dGF0aW9uQm91bmNlUmF0ZUF2ZXJhZ2UoZGltZW5zaW9uczogYW55KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9TRVMnLFxuICAgICAgbWV0cmljTmFtZTogJ1JlcHV0YXRpb24uQm91bmNlUmF0ZScsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIHJlcHV0YXRpb25Db21wbGFpbnRSYXRlQXZlcmFnZShkaW1lbnNpb25zOiB7IFJ1bGVOYW1lOiBzdHJpbmcgfSk6IE1ldHJpY1dpdGhEaW1zPHsgUnVsZU5hbWU6IHN0cmluZyB9PjtcbiAgcHVibGljIHN0YXRpYyByZXB1dGF0aW9uQ29tcGxhaW50UmF0ZUF2ZXJhZ2UoZGltZW5zaW9uczogeyAnc2VzOmNvbmZpZ3VyYXRpb24tc2V0Jzogc3RyaW5nIH0pOiBNZXRyaWNXaXRoRGltczx7ICdzZXM6Y29uZmlndXJhdGlvbi1zZXQnOiBzdHJpbmcgfT47XG4gIHB1YmxpYyBzdGF0aWMgcmVwdXRhdGlvbkNvbXBsYWludFJhdGVBdmVyYWdlKGRpbWVuc2lvbnM6IGFueSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvU0VTJyxcbiAgICAgIG1ldHJpY05hbWU6ICdSZXB1dGF0aW9uLkNvbXBsYWludFJhdGUnLFxuICAgICAgZGltZW5zaW9uc01hcDogZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ0F2ZXJhZ2UnLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyBzZW5kU3VtKGRpbWVuc2lvbnM6IHsgUnVsZU5hbWU6IHN0cmluZyB9KTogTWV0cmljV2l0aERpbXM8eyBSdWxlTmFtZTogc3RyaW5nIH0+O1xuICBwdWJsaWMgc3RhdGljIHNlbmRTdW0oZGltZW5zaW9uczogeyAnc2VzOmNvbmZpZ3VyYXRpb24tc2V0Jzogc3RyaW5nIH0pOiBNZXRyaWNXaXRoRGltczx7ICdzZXM6Y29uZmlndXJhdGlvbi1zZXQnOiBzdHJpbmcgfT47XG4gIHB1YmxpYyBzdGF0aWMgc2VuZFN1bShkaW1lbnNpb25zOiBhbnkpIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL1NFUycsXG4gICAgICBtZXRyaWNOYW1lOiAnU2VuZCcsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICB9O1xuICB9XG59XG50eXBlIE1ldHJpY1dpdGhEaW1zPEQ+ID0geyBuYW1lc3BhY2U6IHN0cmluZywgbWV0cmljTmFtZTogc3RyaW5nLCBzdGF0aXN0aWM6IHN0cmluZywgZGltZW5zaW9uc01hcDogRCB9O1xuIl19