# coding: utf-8

"""
    Nomad Envoy

    This is the API descriptor for the Nomad Envoy API, responsible for order creation and product lists.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nomad_envoy_cli.api_client import ApiClient
from nomad_envoy_cli.exceptions import (
    ApiTypeError,
    ApiValueError
)


class CustomsCallbackApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def post_customs_callback(self, store, body, **kwargs):  # noqa: E501
        """postCustomsCallback  # noqa: E501

        Customs server calls Nomad to receive the filing result of one order  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_customs_callback(store, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str store: ID of the store. (required)
        :param str body: Order details (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_customs_callback_with_http_info(store, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_customs_callback_with_http_info(store, body, **kwargs)  # noqa: E501
            return data

    def post_customs_callback_with_http_info(self, store, body, **kwargs):  # noqa: E501
        """postCustomsCallback  # noqa: E501

        Customs server calls Nomad to receive the filing result of one order  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_customs_callback_with_http_info(store, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str store: ID of the store. (required)
        :param str body: Order details (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['store', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_customs_callback" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'store' is set
        if ('store' not in local_var_params or
                local_var_params['store'] is None):
            raise ApiValueError("Missing the required parameter `store` when calling `post_customs_callback`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `post_customs_callback`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'store' in local_var_params:
            path_params['store'] = local_var_params['store']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key', 'ca_stage']  # noqa: E501

        return self.api_client.call_api(
            '/customs/{store}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
