# -*- coding: utf-8 -*-

"""
swaggerpetstore

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from swaggerpetstore.api_helper import APIHelper
from swaggerpetstore.configuration import Server
from swaggerpetstore.controllers.base_controller import BaseController
from swaggerpetstore.models.order import Order
from swaggerpetstore.exceptions.api_exception import APIException


class StoreController(BaseController):

    """A Controller to access Endpoints in the swaggerpetstore API."""
    def __init__(self, config, auth_managers):
        super(StoreController, self).__init__(config, auth_managers)

    def place_order(self,
                    body):
        """Does a POST request to /store/order.

        Place an order for a pet

        Args:
            body (Order): order placed for purchasing the pet

        Returns:
            Order: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/store/order'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        # Apply authentication scheme on request
        self.apply_auth_schemes(_request, 'apiKey')

        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise APIException('Invalid Order', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, Order.from_dictionary)

        return decoded

    def get_order_by_id(self,
                        order_id):
        """Does a GET request to /store/order/{orderId}.

        For valid response try integer IDs with value >= 1 and <= 10. Other
        values will generated exceptions

        Args:
            order_id (long|int): ID of pet that needs to be fetched

        Returns:
            Order: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/store/order/{orderId}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'orderId': {'value': order_id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        # Apply authentication scheme on request
        self.apply_auth_schemes(_request, 'apiKey')

        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise APIException('Invalid ID supplied', _response)
        elif _response.status_code == 404:
            raise APIException('Order not found', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, Order.from_dictionary)

        return decoded

    def get_inventory(self):
        """Does a GET request to /store/inventory.

        Returns a map of status codes to quantities

        Returns:
            dict: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/store/inventory'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        # Apply authentication scheme on request
        self.apply_auth_schemes(_request, 'apiKey')

        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def delete_order(self,
                     order_id):
        """Does a DELETE request to /store/order/{orderId}.

        For valid response try integer IDs with positive integer value.
        Negative or non-integer values will generate API errors

        Args:
            order_id (long|int): ID of the order that needs to be deleted

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/store/order/{orderId}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'orderId': {'value': order_id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url)
        # Apply authentication scheme on request
        self.apply_auth_schemes(_request, 'apiKey')

        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise APIException('Invalid ID supplied', _response)
        elif _response.status_code == 404:
            raise APIException('Order not found', _response)
        self.validate_response(_response)
