# -*- coding: utf-8 -*-
"""
Routes for the CRAB views.

.. versionadded:: 0.1.0
"""
import crabpy_pyramid


def includeme(config):
    crabpy_pyramid.add_route(config,
                             'list_gewesten',
                             '/crab/gewesten')
    crabpy_pyramid.add_route(config,
                             'get_gewest_by_id',
                             '/crab/gewesten/{gewest_id}')
    crabpy_pyramid.add_route(config,
                             'list_provincies',
                             '/crab/gewesten/{gewest_id}/provincies')
    crabpy_pyramid.add_route(config,
                             'get_provincie',
                             '/crab/provincies/{provincie_id}')
    crabpy_pyramid.add_route(config,
                             'list_gemeenten_by_provincie',
                             '/crab/provincies/{provincie_id}/gemeenten')
    crabpy_pyramid.add_route(config,
                             'list_gemeenten_crab',
                             '/crab/gewesten/{gewest_id}/gemeenten')
    crabpy_pyramid.add_route(config,
                             'get_gemeente_crab',
                             '/crab/gemeenten/{gemeente_id}')
    crabpy_pyramid.add_route(config,
                             'list_deelgemeenten',
                             '/crab/gewesten/{gewest_id}/deelgemeenten')
    crabpy_pyramid.add_route(config,
                             'list_deelgemeenten_by_gemeente',
                             '/crab/gemeenten/{gemeente_id}/deelgemeenten')
    crabpy_pyramid.add_route(config,
                             'get_deelgemeente_by_id',
                             '/crab/deelgemeenten/{deelgemeente_id}')
    crabpy_pyramid.add_route(config,
                             'list_straten',
                             '/crab/gemeenten/{gemeente_id}/straten')
    crabpy_pyramid.add_route(config,
                             'get_straat_by_id',
                             '/crab/straten/{straat_id}')
    crabpy_pyramid.add_route(config,
                             'get_wegobject',
                             '/crab/wegobjecten/{wegobject_id}')
    crabpy_pyramid.add_route(config,
                             'list_huisnummers',
                             '/crab/straten/{straat_id}/huisnummers')
    crabpy_pyramid.add_route(
        config,
        'get_huisnummer_by_straat_and_label',
        '/crab/straten/{straat_id}/huisnummers/{huisnummer_label}')
    crabpy_pyramid.add_route(config,
                             'get_huisnummer_by_id',
                             '/crab/huisnummers/{huisnummer_id}')
    crabpy_pyramid.add_route(config,
                             'list_percelen',
                             '/crab/huisnummers/{huisnummer_id}/percelen')
    crabpy_pyramid.add_route(config,
                             'get_perceel_by_id',
                             '/crab/percelen/{perceel_id1}/{perceel_id2}')
    crabpy_pyramid.add_route(
        config,
        'list_huisnummers_by_perceel',
        '/crab/percelen/{perceel_id1}/{perceel_id2}/huisnummers')
    crabpy_pyramid.add_route(config,
                             'list_gebouwen',
                             '/crab/huisnummers/{huisnummer_id}/gebouwen')
    crabpy_pyramid.add_route(config,
                             'get_gebouw_by_id',
                             '/crab/gebouwen/{gebouw_id}')
    crabpy_pyramid.add_route(config,
                             'list_subadressen',
                             '/crab/huisnummers/{huisnummer_id}/subadressen')
    crabpy_pyramid.add_route(config,
                             'get_subadres_by_id',
                             '/crab/subadressen/{subadres_id}')
    crabpy_pyramid.add_route(config,
                             'list_postkantons_by_gemeente',
                             '/crab/gemeenten/{gemeente_id}/postkantons')
    crabpy_pyramid.add_route(config,
                             'list_adresposities_by_huisnummer',
                             '/crab/huisnummers/{huisnummer_id}/adresposities')
    crabpy_pyramid.add_route(config,
                             'list_adresposities_by_subadres',
                             '/crab/subadressen/{subadres_id}/adresposities')
    crabpy_pyramid.add_route(config,
                             'get_adrespositie_by_id',
                             '/crab/adresposities/{adrespositie_id}')
    crabpy_pyramid.add_route(config,
                             'list_landen',
                             '/crab/landen')
    crabpy_pyramid.add_route(config,
                             'get_land_by_id',
                             '/crab/landen/{land_id}')
    crabpy_pyramid.add_route(config,
                             'get_postkanton_by_huisnummer',
                             '/crab/huisnummers/{huisnummer_id}/postkanton')
