from notmm.utils.wsgilib.exc import HTTPRedirectResponse
from notmm.utils.template import direct_to_template

import logging
log = logging.getLogger('notmm.controllers.wsgi')

__all__ = ('handle302', 'handle303', 'handle404', 'handle500')

def handle302(request, **kwargs):
    location = kwargs['location']
    return HTTPRedirectResponse(location=location, status=302)

def handle303(request, **kwargs):
    location = kwargs['location']
    return HTTPRedirectResponse(location=location, status=303)

def handle500(request, template_name='500.mako'):
    #exc = request.environ['wsgi.exception']
    #log.debug('caught a server error: %s !'%request.path_url)
    return direct_to_template(request, template_name, status=500)
 
def handle404(request, template_name='404.mako'):
    #self.logger.info('Location=%r' % request.path_url)
    #self.logger.info('Client IP=%r' % request.remote_addr)
    return direct_to_template(request, template_name, status=404)
def handle401(request, template_name='401.mako'):
    return direct_to_template(request, template_name, status=401)
