#!/usr/bin/env python

from moviereviews import global_conf
from pkg_resources import resource_filename

from notmm.utils.django_settings import LazySettings

app_conf = global_conf['moviereviews']

# init the settings module (thread-local)
settings = LazySettings() #SettingsProxy(autoload=True).get_settings()

class DatabaseBackend(object):
    pass

class MySQLBackend(DatabaseBackend):
    from sqlalchemy import create_engine, MetaData
    from sqlalchemy.orm import scoped_session, sessionmaker
    # SQLAlchemy settings
    backend = app_conf['backend']
    schema = backend + ':///' + resource_filename('sandbox', app_conf['path'])
    #engine = sqlalchemy.create_engine(schema, echo=app_conf['echo'])
    engine = create_engine(schema, echo=True)
    metadata = MetaData(engine)
    Session = scoped_session(sessionmaker(bind=engine))

