#!/usr/bin/env python
# -*- coding: utf-8 -*-

from notmm.utils.urlmap import RegexURLMap, url

handleLogin = 'blogengine2.contrib.session.views.login'
handleLogout = 'blogengine2.contrib.session.views.logout'
direct_to_template = 'notmm.utils.template.direct_to_template'

urlpatterns = RegexURLMap()
urlpatterns.add_routes('',
        # Frontdoor (a simple generic view)
        url(r'^$|index.html$', direct_to_template, {
            'template_name': 'sandbox/test.mako',
            #'charset': 'utf-8' # must specify mimetype or charset
        })
)

# Add the authentication views
urlpatterns.add_routes('',
        # Custom authentication backend wrapper (authkit based)
        # see nomainapp..controllers.auth.LoginController
        url(r'^session_login/$', handleLogin, \
            dict(template_name='auth/login.mako')),
        url(r'^session_logout/$', handleLogout, \
            dict(template_name='auth/logout.mako')))

urlpatterns.include('moviereviews.config.extras')
