# Suck in default django settings
from django.conf.global_settings import *
from pkg_resources import resource_filename
import os

DEBUG = True

USE_I18N = False

# Custom error handlers mapping
CUSTOM_ERROR_HANDLERS = (
    ('handle401', 'moviereviews.handlers.handle401'),
    #('handle403', 'moviereviews.handlers.handle403'),
    ('handle404', 'moviereviews.handlers.handle404'),
    ('handle500', 'moviereviews.handlers.handle500')
    )
PUBSUB_ERROR_HANDLERS = CUSTOM_ERROR_HANDLERS

# List of processors used by RequestContext to populate the context.
# Each one should be a callable that takes the request object as its
# only parameter and returns a dictionary to add to the context.
TEMPLATE_CONTEXT_PROCESSORS = (
    'django.contrib.auth.context_processors.auth',
    )

# For backward-compatibility with Django
TEMPLATE_DIRS = (
    resource_filename('moviereviews', 'templates'),
    resource_filename('blogengine', 'templates')
)

ROOT_URLCONF = 'moviereviews.config.urls'
MIDDLEWARE_CLASSES = ()

# XXX deprecated
# DATABASE_NAME = 'sqlite:///' + resource_filename('moviereviews_generic', 'fixtures/test.db')
DATABASE_NAME = 'moviereviews'

SITE_ID = 1

INSTALLED_APPS = (
    'moviereviews',
)

SCHEVO = {
    'DATABASE_NAME': 'moviereviews',
    'DATABASE_PREFIX': 'schevo.db',
    'ENABLE_GZIP': True,
    'DEBUG' : True
    }

