require.undef("wa_tree"),define("wa_tree",["wa_model","d3"],function({Workspace:Workspace,EventPublisher:EventPublisher},d3){function replaceAll(str,find,replace){return str.replace(new RegExp(find,"g"),replace)}class Tree extends EventPublisher{constructor(treeDom,settings){super(),this._treeDom=d3.select(treeDom).classed("wa_tree",!0),this._settings=settings,this._ws=void 0,this._visits=void 0,this._convs=void 0,this._selectedNode=void 0,this._visitsByNodeId=void 0}showStats(){this._treeDom.classed("visits",!1)}scrollToNode(nodeId){const node=d3.select(this.nodeRef(nodeId));node.empty()||node.node().scrollIntoView({block:"center",behavior:"smooth"})}classNodes(nodeIds,clazz){d3.selectAll(".node").classed(clazz,d=>nodeIds.includes(d.id))}showVisitedNodes(visitedNodeIds){this._treeDom.classed("visits",!0),d3.selectAll(".turn_visit").remove(),visitedNodeIds.length>0&&(this._markTurnVisits(visitedNodeIds),this._ws.nodes().forEach(n=>{visitedNodeIds.includes(n.id)&&this.expand(n)}),this.scrollToNode(visitedNodeIds[0]))}showWSTree(ws,visits){this._ws=ws,this._visits=visits,this._treeDom.classed("visits",!1),this.renderNodes(),this.collapseAll()}showVisits(convs){this._convs=convs,this._visitsByNodeId=turnsByVisitedNode(convs),this._markAbandoned(this._treeDom.selectAll(".node")),this._markStats(this._treeDom.selectAll(".node"))}expandCollapseClicked(d){d3.event.stopPropagation(),d.collapsed?this.expand(d):this.collapse(d)}nodeRef(id){return replaceAll("#"+id," ","_")}expand(d){d.directChildren().forEach(c=>{d3.select(this.nodeRef(c.id)).classed("hidden",!1)}),d.collapsed=!1,d3.select(this.nodeRef(d.id)).classed("node-container--expanded",!0),d.parent()&&this.expand(d.parent())}collapse(d){d.collapsed=!0,d3.select(this.nodeRef(d.id)).classed("node-container--expanded",!1),d.directChildren().forEach(c=>{this.collapse(c),d3.select(this.nodeRef(c.id)).classed("hidden",!0)})}expandAll(){this._ws.nodes().forEach(n=>this.expand(n))}collapseAll(){this._ws.nodes().filter(n=>n.isTop()).forEach(n=>this.collapse(n))}select(d){this._selectedNode&&d3.select(this.nodeRef(this._selectedNode.id)).classed("node--selected",!1),this._selectedNode=d,d3.select(this.nodeRef(this._selectedNode.id)).classed("node--selected",!0),this._publish(Tree.EVENT_SELECTED_NODE_CHANGED,d)}_markStats(selection){const visitsAtNode=d=>this._visitsByNodeId.get(d.id);selection.filter(d=>visitsAtNode(d)).append("div").classed("marker",!0).classed("this_turn",!0).text(d=>visitsAtNode(d).length).attr("title","Number of turns that visited this node").on("click",d=>{d3.event.stopPropagation(),this._publish(Tree.EVENT_TURNS_CLICKED,visitsAtNode(d),d)})}_markAbandoned(selection){const nodeIdsToAbandonedTurns={};abandonedConversationsAtNodes(this._convs).forEach(([k,v])=>nodeIdsToAbandonedTurns[k]=v);const visitsAtNode=d=>nodeIdsToAbandonedTurns[d.id]||[];selection.filter(d=>visitsAtNode(d).length>0).append("div").classed("marker",!0).classed("abandoned",!0).text(d=>visitsAtNode(d).length).attr("title","Number of turns ABANDONED after this node").on("click",d=>{d3.event.stopPropagation(),this._publish(Tree.EVENT_TURNS_CLICKED,visitsAtNode(d),d)})}_markTurnVisits(visitedNodeIds){const domIds=visitedNodeIds.map(id=>this.nodeRef(id)).join(", "),marker=d3.selectAll(domIds).filter(d=>visitedNodeIds.includes(d.id)).append("div").classed("marker",!0).classed("turn_visit",!0),go=delta=>(d,myIndex)=>{d3.event.stopPropagation();const nextNodeId=visitedNodeIds[myIndex+delta];this.scrollToNode(nextNodeId)};function arrow_right(selection){selection.append("svg").attr("width",8).attr("height",12).attr("viewBox","0 0 8 12").append("path").attr("d","M0 10.6L4.7 6 0 1.4 1.4 0l6.1 6-6.1 6z")}arrow_right(marker.filter((d,i)=>i>0).append("span").classed("nav prev",!0).on("click",go(-1))),marker.append("span").classed("marker_value",!0).text(d=>visitedNodeIds.indexOf(d.id)+1),arrow_right(marker.filter((d,i,group)=>i<group.length-1).append("span").classed("nav next",!0).on("click",go(1)))}renderNodes(){const nodes=this._ws.nodes();this._treeDom.selectAll(".node").remove();const nodeContainer=this._treeDom.selectAll(".node").data(nodes,d=>d.id).enter().append("div").classed("node-container",!0).append("div").attr("id",d=>replaceAll(d.id," ","_")).classed("node",!0).classed("parent",d=>d.isParent()).classed("eot",d=>d.isEndOfTurn()).style("transform",d=>`translateX(${20*d.depth()}px)`).on("click",d=>{d3.event.stopPropagation(),this.select(d)});nodeContainer.append("div").classed("node__expander",!0).append("button").attr("type","button").attr("title","click to expand/collapse").on("click",d=>this.expandCollapseClicked(d)).append("svg").attr("width",d=>d.isFolder()?16:8).attr("height",12).attr("viewBox",d=>d.isFolder()?"0 0 16 12":"0 0 8 12").append("path").attr("d",d=>d.isFolder()?"M0 12h16V2H8V0H0z":"M0 10.6L4.7 6 0 1.4 1.4 0l6.1 6-6.1 6z");const nodeContent=nodeContainer.append("div").classed("node__contents",!0);this.createTitle(nodeContent),this.createConditionElem(nodeContent),this.createOutputElem(nodeContent),this.createBottomElem(nodeContent),null!=this._visits&&this.createStatsElem(nodeContent)}createBottomElem(nodeContent){const bottom=nodeContent.append("div").classed("node__subtext",!0);bottom.append("div").attr("class","set_context").text(d=>{const vals=Object.values(d.context||{});if(vals.length>0)return`${vals.length} Context Set`}).attr("title",d=>JSON.stringify(d.context));const jumpTo=bottom.filter(d=>d.nextStep).append("div").classed("jump_to",!0);return jumpTo.append("span").text(d=>d.nextStep.behavior),jumpTo.append("a").attr("href","javascript:").on("click",d=>{const target=this._ws._nodeById[d.nextStep.dialog_node];this.expand(target),setTimeout(()=>{this.select(target),this.scrollToNode(target.id)})}).text(d=>d.nextStep.dialog_node),jumpTo.append("span").text(d=>d.nextStep.selector),bottom}createStatsElem(nodeContent){const stats=nodeContent.append("div").classed("node__stats",!0).text("visits: ");return stats.append("div").attr("class","stats").text(d=>this._visits.nodeVisits(d.id)),stats}createOutputElem(nodeContent){return nodeContent.append("div").attr("class","output").classed("node__subtext",!0).text(d=>d.isSwitch()?" SWITCH ":d.outputLongText?d.outputLongText:void 0).attr("title",d=>d.outputLongText)}createConditionElem(nodeContent){return nodeContent.append("div").attr("class","node__subtext").append("div").text(d=>{return d.condition}).classed("cond",!0).attr("title",d=>d.condition)}createTitle(nodeContent){const title=nodeContent.append("div").attr("class","node__text").attr("title",d=>`${d.title} (${d.id})`);return title.append("span").text(d=>{const titleTxt=d.title||"_";switch(d.type){case Workspace.NODE_TYPE_FRAME:return`FRAME: ${titleTxt}`;case Workspace.NODE_TYPE_SLOT:return`SLOT: ${titleTxt}`;case Workspace.NODE_TYPE_EVENT_HANDLER:return`EVENT: ${titleTxt}`;case Workspace.NODE_TYPE_RESPONSE_CONDITION:return`RESP_COND: ${titleTxt}`;default:return titleTxt}}),title}}return Tree.EVENT_TURNS_CLICKED="turns_clicked",Tree.EVENT_SELECTED_NODE_CHANGED="node_selected",Tree});