import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupMembersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifies the group in the API request. The value can be the group's email address, group alias, or the unique group ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/group_members#group_id GroupMembers#group_id}
    */
    readonly groupId: string;
    /**
    * members block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/group_members#members GroupMembers#members}
    */
    readonly members?: GroupMembersMembers[] | cdktf.IResolvable;
}
export interface GroupMembersMembers {
    /**
    * Defaults to `ALL_MAIL`. Defines mail delivery preferences of member. Acceptable values are:
      - `ALL_MAIL`: All messages, delivered as soon as they arrive.
      - `DAILY`: No more than one message a day.
      - `DIGEST`: Up to 25 messages bundled into a single message.
      - `DISABLED`: Remove subscription.
      - `NONE`: No messages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/group_members#delivery_settings GroupMembers#delivery_settings}
    */
    readonly deliverySettings?: string;
    /**
    * The member's email address. A member can be a user or another group. This property isrequired when adding a member to a group. The email must be unique and cannot be an alias of another group. If the email address is changed, the API automatically reflects the email address changes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/group_members#email GroupMembers#email}
    */
    readonly email: string;
    /**
    * Defaults to `MEMBER`. The member's role in a group. The API returns an error for cycles in group memberships. For example, if group1 is a member of group2, group2 cannot be a member of group1. Acceptable values are:
      - `MANAGER`: This role is only available if the Google Groups for Business is enabled using the Admin Console. A `MANAGER` role can do everything done by an `OWNER` role except make a member an `OWNER` or delete the group. A group can have multiple `MANAGER` members.
      - `MEMBER`: This role can subscribe to a group, view discussion archives, and view the group's membership list.
      - `OWNER`: This role can send messages to the group, add or remove members, change member roles, change group's settings, and delete the group. An OWNER must be a member of the group. A group can have more than one OWNER.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/group_members#role GroupMembers#role}
    */
    readonly role?: string;
    /**
    * Defaults to `USER`. The type of group member. Acceptable values are:
      - `CUSTOMER`: The member represents all users in a domain. An email address is not returned and the ID returned is the customer ID.
      - `GROUP`: The member is another group.
      - `USER`: The member is a user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/group_members#type GroupMembers#type}
    */
    readonly type?: string;
}
export declare function groupMembersMembersToTerraform(struct?: GroupMembersMembers | cdktf.IResolvable): any;
export declare class GroupMembersMembersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GroupMembersMembers | cdktf.IResolvable | undefined;
    set internalValue(value: GroupMembersMembers | cdktf.IResolvable | undefined);
    private _deliverySettings?;
    get deliverySettings(): string;
    set deliverySettings(value: string);
    resetDeliverySettings(): void;
    get deliverySettingsInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    get id(): string;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    get status(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class GroupMembersMembersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GroupMembersMembers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GroupMembersMembersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/r/group_members googleworkspace_group_members}
*/
export declare class GroupMembers extends cdktf.TerraformResource {
    static readonly tfResourceType = "googleworkspace_group_members";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/r/group_members googleworkspace_group_members} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupMembersConfig
    */
    constructor(scope: Construct, id: string, config: GroupMembersConfig);
    get etag(): string;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    get id(): string;
    private _members;
    get members(): GroupMembersMembersList;
    putMembers(value: GroupMembersMembers[] | cdktf.IResolvable): void;
    resetMembers(): void;
    get membersInput(): cdktf.IResolvable | GroupMembersMembers[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
