import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * The domain name of the customer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/domain#domain_name Domain#domain_name}
    */
    readonly domainName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/r/domain googleworkspace_domain}
*/
export declare class Domain extends cdktf.TerraformResource {
    static readonly tfResourceType = "googleworkspace_domain";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/r/domain googleworkspace_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DomainConfig
    */
    constructor(scope: Construct, id: string, config: DomainConfig);
    get creationTime(): number;
    get domainAliases(): string[];
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    get etag(): string;
    get id(): string;
    get isPrimary(): cdktf.IResolvable;
    get verified(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
