# pversion

[![Build Status](https://travis-ci.com/sfneal/pversion.svg?branch=master)](https://travis-ci.com/sfneal/pversion)
[![PyPi version](https://img.shields.io/pypi/v/pversion)](https://pypi.org/project/pversion)
[![PyPi Python support](https://img.shields.io/pypi/pyversions/pversion)](https://pypi.org/project/pversion)
[![PyPi downloads per month](https://img.shields.io/pypi/dm/pversion)](https://pypi.org/project/pversion)
[![PyPi license](https://img.shields.io/pypi/l/pversion)](https://pypi.org/project/pversion)

Retrieve a package's version in a setup.py file.

## Usage
Retrieve the package version from a version file in the package root.

## Getting Started

These instructions will get you a copy of the project up and running on your local machine for development and testing purposes.

### Prerequisites

In order to utilize this pversion you will need to have a Python (3.6+) interpreter installed on your machine.

#### PyPi installation
```
pip install pversion
```

#### PyPi update
```
pip install --upgrade --no-cache-dir pversion
```

### Project Structure

```
├── pversion
│   ├── __init__.py
│   ├── _version.py
│   ├── font
│   │   ├── __init__.py
│   │   ├── Vera.ttf
│   │   └── register.py
│   ├── pillow.py
│   └── utils.py
```

## Contributing

Please read [CONTRIBUTING.md](https://github.com/sfneal/pversion/CONTRIBUTING.md) for details on our code of 
conduct, and the process for submitting pull requests to us.

## Versioning

We use [SemVer](http://semver.org/) for versioning. For the versions available, see the [tags on this repository](https://github.com/sfneal/pversion). 

## Authors

* **Stephen Neal** - *Initial work* - [pversion](https://github.com/sfneal)

## License

This project is licensed under the Apache License - see the [LICENSE.md](LICENSE.md) file for details
