# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'DetectorModelActionArgs',
    'DetectorModelAssetPropertyTimestampArgs',
    'DetectorModelAssetPropertyValueArgs',
    'DetectorModelAssetPropertyVariantArgs',
    'DetectorModelClearTimerArgs',
    'DetectorModelDetectorModelDefinitionArgs',
    'DetectorModelDynamoDBv2Args',
    'DetectorModelDynamoDBArgs',
    'DetectorModelEventArgs',
    'DetectorModelFirehoseArgs',
    'DetectorModelIotEventsArgs',
    'DetectorModelIotSiteWiseArgs',
    'DetectorModelIotTopicPublishArgs',
    'DetectorModelLambdaArgs',
    'DetectorModelOnEnterArgs',
    'DetectorModelOnExitArgs',
    'DetectorModelOnInputArgs',
    'DetectorModelPayloadArgs',
    'DetectorModelResetTimerArgs',
    'DetectorModelSetTimerArgs',
    'DetectorModelSetVariableArgs',
    'DetectorModelSnsArgs',
    'DetectorModelSqsArgs',
    'DetectorModelStateArgs',
    'DetectorModelTagArgs',
    'DetectorModelTransitionEventArgs',
    'InputAttributeArgs',
    'InputInputDefinitionArgs',
    'InputTagArgs',
]

@pulumi.input_type
class DetectorModelActionArgs:
    def __init__(__self__, *,
                 clear_timer: Optional[pulumi.Input['DetectorModelClearTimerArgs']] = None,
                 dynamo_db: Optional[pulumi.Input['DetectorModelDynamoDBArgs']] = None,
                 dynamo_d_bv2: Optional[pulumi.Input['DetectorModelDynamoDBv2Args']] = None,
                 firehose: Optional[pulumi.Input['DetectorModelFirehoseArgs']] = None,
                 iot_events: Optional[pulumi.Input['DetectorModelIotEventsArgs']] = None,
                 iot_site_wise: Optional[pulumi.Input['DetectorModelIotSiteWiseArgs']] = None,
                 iot_topic_publish: Optional[pulumi.Input['DetectorModelIotTopicPublishArgs']] = None,
                 lambda_: Optional[pulumi.Input['DetectorModelLambdaArgs']] = None,
                 reset_timer: Optional[pulumi.Input['DetectorModelResetTimerArgs']] = None,
                 set_timer: Optional[pulumi.Input['DetectorModelSetTimerArgs']] = None,
                 set_variable: Optional[pulumi.Input['DetectorModelSetVariableArgs']] = None,
                 sns: Optional[pulumi.Input['DetectorModelSnsArgs']] = None,
                 sqs: Optional[pulumi.Input['DetectorModelSqsArgs']] = None):
        """
        The actions to be performed.
        """
        if clear_timer is not None:
            pulumi.set(__self__, "clear_timer", clear_timer)
        if dynamo_db is not None:
            pulumi.set(__self__, "dynamo_db", dynamo_db)
        if dynamo_d_bv2 is not None:
            pulumi.set(__self__, "dynamo_d_bv2", dynamo_d_bv2)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if iot_events is not None:
            pulumi.set(__self__, "iot_events", iot_events)
        if iot_site_wise is not None:
            pulumi.set(__self__, "iot_site_wise", iot_site_wise)
        if iot_topic_publish is not None:
            pulumi.set(__self__, "iot_topic_publish", iot_topic_publish)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if reset_timer is not None:
            pulumi.set(__self__, "reset_timer", reset_timer)
        if set_timer is not None:
            pulumi.set(__self__, "set_timer", set_timer)
        if set_variable is not None:
            pulumi.set(__self__, "set_variable", set_variable)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sqs is not None:
            pulumi.set(__self__, "sqs", sqs)

    @property
    @pulumi.getter(name="clearTimer")
    def clear_timer(self) -> Optional[pulumi.Input['DetectorModelClearTimerArgs']]:
        return pulumi.get(self, "clear_timer")

    @clear_timer.setter
    def clear_timer(self, value: Optional[pulumi.Input['DetectorModelClearTimerArgs']]):
        pulumi.set(self, "clear_timer", value)

    @property
    @pulumi.getter(name="dynamoDB")
    def dynamo_db(self) -> Optional[pulumi.Input['DetectorModelDynamoDBArgs']]:
        return pulumi.get(self, "dynamo_db")

    @dynamo_db.setter
    def dynamo_db(self, value: Optional[pulumi.Input['DetectorModelDynamoDBArgs']]):
        pulumi.set(self, "dynamo_db", value)

    @property
    @pulumi.getter(name="dynamoDBv2")
    def dynamo_d_bv2(self) -> Optional[pulumi.Input['DetectorModelDynamoDBv2Args']]:
        return pulumi.get(self, "dynamo_d_bv2")

    @dynamo_d_bv2.setter
    def dynamo_d_bv2(self, value: Optional[pulumi.Input['DetectorModelDynamoDBv2Args']]):
        pulumi.set(self, "dynamo_d_bv2", value)

    @property
    @pulumi.getter
    def firehose(self) -> Optional[pulumi.Input['DetectorModelFirehoseArgs']]:
        return pulumi.get(self, "firehose")

    @firehose.setter
    def firehose(self, value: Optional[pulumi.Input['DetectorModelFirehoseArgs']]):
        pulumi.set(self, "firehose", value)

    @property
    @pulumi.getter(name="iotEvents")
    def iot_events(self) -> Optional[pulumi.Input['DetectorModelIotEventsArgs']]:
        return pulumi.get(self, "iot_events")

    @iot_events.setter
    def iot_events(self, value: Optional[pulumi.Input['DetectorModelIotEventsArgs']]):
        pulumi.set(self, "iot_events", value)

    @property
    @pulumi.getter(name="iotSiteWise")
    def iot_site_wise(self) -> Optional[pulumi.Input['DetectorModelIotSiteWiseArgs']]:
        return pulumi.get(self, "iot_site_wise")

    @iot_site_wise.setter
    def iot_site_wise(self, value: Optional[pulumi.Input['DetectorModelIotSiteWiseArgs']]):
        pulumi.set(self, "iot_site_wise", value)

    @property
    @pulumi.getter(name="iotTopicPublish")
    def iot_topic_publish(self) -> Optional[pulumi.Input['DetectorModelIotTopicPublishArgs']]:
        return pulumi.get(self, "iot_topic_publish")

    @iot_topic_publish.setter
    def iot_topic_publish(self, value: Optional[pulumi.Input['DetectorModelIotTopicPublishArgs']]):
        pulumi.set(self, "iot_topic_publish", value)

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional[pulumi.Input['DetectorModelLambdaArgs']]:
        return pulumi.get(self, "lambda_")

    @lambda_.setter
    def lambda_(self, value: Optional[pulumi.Input['DetectorModelLambdaArgs']]):
        pulumi.set(self, "lambda_", value)

    @property
    @pulumi.getter(name="resetTimer")
    def reset_timer(self) -> Optional[pulumi.Input['DetectorModelResetTimerArgs']]:
        return pulumi.get(self, "reset_timer")

    @reset_timer.setter
    def reset_timer(self, value: Optional[pulumi.Input['DetectorModelResetTimerArgs']]):
        pulumi.set(self, "reset_timer", value)

    @property
    @pulumi.getter(name="setTimer")
    def set_timer(self) -> Optional[pulumi.Input['DetectorModelSetTimerArgs']]:
        return pulumi.get(self, "set_timer")

    @set_timer.setter
    def set_timer(self, value: Optional[pulumi.Input['DetectorModelSetTimerArgs']]):
        pulumi.set(self, "set_timer", value)

    @property
    @pulumi.getter(name="setVariable")
    def set_variable(self) -> Optional[pulumi.Input['DetectorModelSetVariableArgs']]:
        return pulumi.get(self, "set_variable")

    @set_variable.setter
    def set_variable(self, value: Optional[pulumi.Input['DetectorModelSetVariableArgs']]):
        pulumi.set(self, "set_variable", value)

    @property
    @pulumi.getter
    def sns(self) -> Optional[pulumi.Input['DetectorModelSnsArgs']]:
        return pulumi.get(self, "sns")

    @sns.setter
    def sns(self, value: Optional[pulumi.Input['DetectorModelSnsArgs']]):
        pulumi.set(self, "sns", value)

    @property
    @pulumi.getter
    def sqs(self) -> Optional[pulumi.Input['DetectorModelSqsArgs']]:
        return pulumi.get(self, "sqs")

    @sqs.setter
    def sqs(self, value: Optional[pulumi.Input['DetectorModelSqsArgs']]):
        pulumi.set(self, "sqs", value)


@pulumi.input_type
class DetectorModelAssetPropertyTimestampArgs:
    def __init__(__self__, *,
                 time_in_seconds: pulumi.Input[str],
                 offset_in_nanos: Optional[pulumi.Input[str]] = None):
        """
        A structure that contains timestamp information. For more information, see [TimeInNanos](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html) in the *AWS IoT SiteWise API Reference*.
        :param pulumi.Input[str] time_in_seconds: The nanosecond offset converted from `timeInSeconds`. The valid range is between `0-999999999`. You can also specify an expression.
        :param pulumi.Input[str] offset_in_nanos: The timestamp, in seconds, in the Unix epoch format. The valid range is between `1-31556889864403199`. You can also specify an expression.
        """
        pulumi.set(__self__, "time_in_seconds", time_in_seconds)
        if offset_in_nanos is not None:
            pulumi.set(__self__, "offset_in_nanos", offset_in_nanos)

    @property
    @pulumi.getter(name="timeInSeconds")
    def time_in_seconds(self) -> pulumi.Input[str]:
        """
        The nanosecond offset converted from `timeInSeconds`. The valid range is between `0-999999999`. You can also specify an expression.
        """
        return pulumi.get(self, "time_in_seconds")

    @time_in_seconds.setter
    def time_in_seconds(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_in_seconds", value)

    @property
    @pulumi.getter(name="offsetInNanos")
    def offset_in_nanos(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp, in seconds, in the Unix epoch format. The valid range is between `1-31556889864403199`. You can also specify an expression.
        """
        return pulumi.get(self, "offset_in_nanos")

    @offset_in_nanos.setter
    def offset_in_nanos(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offset_in_nanos", value)


@pulumi.input_type
class DetectorModelAssetPropertyValueArgs:
    def __init__(__self__, *,
                 value: pulumi.Input['DetectorModelAssetPropertyVariantArgs'],
                 quality: Optional[pulumi.Input[str]] = None,
                 timestamp: Optional[pulumi.Input['DetectorModelAssetPropertyTimestampArgs']] = None):
        """
        A structure that contains value information. For more information, see [AssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html) in the *AWS IoT SiteWise API Reference*.
        :param pulumi.Input[str] quality: The quality of the asset property value. The value must be `GOOD`, `BAD`, or `UNCERTAIN`. You can also specify an expression.
        """
        pulumi.set(__self__, "value", value)
        if quality is not None:
            pulumi.set(__self__, "quality", quality)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input['DetectorModelAssetPropertyVariantArgs']:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input['DetectorModelAssetPropertyVariantArgs']):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def quality(self) -> Optional[pulumi.Input[str]]:
        """
        The quality of the asset property value. The value must be `GOOD`, `BAD`, or `UNCERTAIN`. You can also specify an expression.
        """
        return pulumi.get(self, "quality")

    @quality.setter
    def quality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quality", value)

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[pulumi.Input['DetectorModelAssetPropertyTimestampArgs']]:
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: Optional[pulumi.Input['DetectorModelAssetPropertyTimestampArgs']]):
        pulumi.set(self, "timestamp", value)


@pulumi.input_type
class DetectorModelAssetPropertyVariantArgs:
    def __init__(__self__, *,
                 boolean_value: Optional[pulumi.Input[str]] = None,
                 double_value: Optional[pulumi.Input[str]] = None,
                 integer_value: Optional[pulumi.Input[str]] = None,
                 string_value: Optional[pulumi.Input[str]] = None):
        """
        A structure that contains an asset property value. For more information, see [Variant](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html) in the *AWS IoT SiteWise API Reference*.
        :param pulumi.Input[str] boolean_value: The asset property value is a Boolean value that must be `TRUE` or `FALSE`. You can also specify an expression. If you use an expression, the evaluated result should be a Boolean value.
        :param pulumi.Input[str] double_value: The asset property value is a double. You can also specify an expression. If you use an expression, the evaluated result should be a double.
        :param pulumi.Input[str] integer_value: The asset property value is an integer. You can also specify an expression. If you use an expression, the evaluated result should be an integer.
        :param pulumi.Input[str] string_value: The asset property value is a string. You can also specify an expression. If you use an expression, the evaluated result should be a string.
        """
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if integer_value is not None:
            pulumi.set(__self__, "integer_value", integer_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[pulumi.Input[str]]:
        """
        The asset property value is a Boolean value that must be `TRUE` or `FALSE`. You can also specify an expression. If you use an expression, the evaluated result should be a Boolean value.
        """
        return pulumi.get(self, "boolean_value")

    @boolean_value.setter
    def boolean_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boolean_value", value)

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[pulumi.Input[str]]:
        """
        The asset property value is a double. You can also specify an expression. If you use an expression, the evaluated result should be a double.
        """
        return pulumi.get(self, "double_value")

    @double_value.setter
    def double_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "double_value", value)

    @property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> Optional[pulumi.Input[str]]:
        """
        The asset property value is an integer. You can also specify an expression. If you use an expression, the evaluated result should be an integer.
        """
        return pulumi.get(self, "integer_value")

    @integer_value.setter
    def integer_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "integer_value", value)

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[pulumi.Input[str]]:
        """
        The asset property value is a string. You can also specify an expression. If you use an expression, the evaluated result should be a string.
        """
        return pulumi.get(self, "string_value")

    @string_value.setter
    def string_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "string_value", value)


@pulumi.input_type
class DetectorModelClearTimerArgs:
    def __init__(__self__, *,
                 timer_name: pulumi.Input[str]):
        """
        Information needed to clear the timer.
        """
        pulumi.set(__self__, "timer_name", timer_name)

    @property
    @pulumi.getter(name="timerName")
    def timer_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "timer_name")

    @timer_name.setter
    def timer_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "timer_name", value)


@pulumi.input_type
class DetectorModelDetectorModelDefinitionArgs:
    def __init__(__self__, *,
                 initial_state_name: pulumi.Input[str],
                 states: pulumi.Input[Sequence[pulumi.Input['DetectorModelStateArgs']]]):
        """
        Information that defines how a detector operates.
        :param pulumi.Input[str] initial_state_name: The state that is entered at the creation of each detector (instance).
        :param pulumi.Input[Sequence[pulumi.Input['DetectorModelStateArgs']]] states: Information about the states of the detector.
        """
        pulumi.set(__self__, "initial_state_name", initial_state_name)
        pulumi.set(__self__, "states", states)

    @property
    @pulumi.getter(name="initialStateName")
    def initial_state_name(self) -> pulumi.Input[str]:
        """
        The state that is entered at the creation of each detector (instance).
        """
        return pulumi.get(self, "initial_state_name")

    @initial_state_name.setter
    def initial_state_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "initial_state_name", value)

    @property
    @pulumi.getter
    def states(self) -> pulumi.Input[Sequence[pulumi.Input['DetectorModelStateArgs']]]:
        """
        Information about the states of the detector.
        """
        return pulumi.get(self, "states")

    @states.setter
    def states(self, value: pulumi.Input[Sequence[pulumi.Input['DetectorModelStateArgs']]]):
        pulumi.set(self, "states", value)


@pulumi.input_type
class DetectorModelDynamoDBv2Args:
    def __init__(__self__, *,
                 table_name: pulumi.Input[str],
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None):
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can also customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.

        You can use expressions for parameters that are strings. For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
        :param pulumi.Input[str] table_name: The name of the DynamoDB table.
        """
        pulumi.set(__self__, "table_name", table_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        The name of the DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


@pulumi.input_type
class DetectorModelDynamoDBArgs:
    def __init__(__self__, *,
                 hash_key_field: pulumi.Input[str],
                 hash_key_value: pulumi.Input[str],
                 table_name: pulumi.Input[str],
                 hash_key_type: Optional[pulumi.Input[str]] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None,
                 payload_field: Optional[pulumi.Input[str]] = None,
                 range_key_field: Optional[pulumi.Input[str]] = None,
                 range_key_type: Optional[pulumi.Input[str]] = None,
                 range_key_value: Optional[pulumi.Input[str]] = None):
        """
        Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can also customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *AWS IoT Events Developer Guide*.
        :param pulumi.Input[str] hash_key_field: The name of the hash key (also called the partition key).
        :param pulumi.Input[str] hash_key_value: The value of the hash key (also called the partition key).
        :param pulumi.Input[str] table_name: The name of the DynamoDB table.
        :param pulumi.Input[str] hash_key_type: The data type for the hash key (also called the partition key). You can specify the following values:
               
               * `STRING` - The hash key is a string.
               
               * `NUMBER` - The hash key is a number.
               
               If you don't specify `hashKeyType`, the default value is `STRING`.
        :param pulumi.Input[str] operation: The type of operation to perform. You can specify the following values:
               
               * `INSERT` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.
               
               * `UPDATE` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
               
               * `DELETE` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
               
               If you don't specify this parameter, AWS IoT Events triggers the `INSERT` operation.
        :param pulumi.Input[str] payload_field: The name of the DynamoDB column that receives the action payload.
               
               If you don't specify this parameter, the name of the DynamoDB column is `payload`.
        :param pulumi.Input[str] range_key_field: The name of the range key (also called the sort key).
        :param pulumi.Input[str] range_key_type: The data type for the range key (also called the sort key), You can specify the following values:
               
               * `STRING` - The range key is a string.
               
               * `NUMBER` - The range key is number.
               
               If you don't specify `rangeKeyField`, the default value is `STRING`.
        :param pulumi.Input[str] range_key_value: The value of the range key (also called the sort key).
        """
        pulumi.set(__self__, "hash_key_field", hash_key_field)
        pulumi.set(__self__, "hash_key_value", hash_key_value)
        pulumi.set(__self__, "table_name", table_name)
        if hash_key_type is not None:
            pulumi.set(__self__, "hash_key_type", hash_key_type)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_field is not None:
            pulumi.set(__self__, "payload_field", payload_field)
        if range_key_field is not None:
            pulumi.set(__self__, "range_key_field", range_key_field)
        if range_key_type is not None:
            pulumi.set(__self__, "range_key_type", range_key_type)
        if range_key_value is not None:
            pulumi.set(__self__, "range_key_value", range_key_value)

    @property
    @pulumi.getter(name="hashKeyField")
    def hash_key_field(self) -> pulumi.Input[str]:
        """
        The name of the hash key (also called the partition key).
        """
        return pulumi.get(self, "hash_key_field")

    @hash_key_field.setter
    def hash_key_field(self, value: pulumi.Input[str]):
        pulumi.set(self, "hash_key_field", value)

    @property
    @pulumi.getter(name="hashKeyValue")
    def hash_key_value(self) -> pulumi.Input[str]:
        """
        The value of the hash key (also called the partition key).
        """
        return pulumi.get(self, "hash_key_value")

    @hash_key_value.setter
    def hash_key_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "hash_key_value", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        The name of the DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="hashKeyType")
    def hash_key_type(self) -> Optional[pulumi.Input[str]]:
        """
        The data type for the hash key (also called the partition key). You can specify the following values:

        * `STRING` - The hash key is a string.

        * `NUMBER` - The hash key is a number.

        If you don't specify `hashKeyType`, the default value is `STRING`.
        """
        return pulumi.get(self, "hash_key_type")

    @hash_key_type.setter
    def hash_key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hash_key_type", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        """
        The type of operation to perform. You can specify the following values:

        * `INSERT` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.

        * `UPDATE` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.

        * `DELETE` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.

        If you don't specify this parameter, AWS IoT Events triggers the `INSERT` operation.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="payloadField")
    def payload_field(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the DynamoDB column that receives the action payload.

        If you don't specify this parameter, the name of the DynamoDB column is `payload`.
        """
        return pulumi.get(self, "payload_field")

    @payload_field.setter
    def payload_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload_field", value)

    @property
    @pulumi.getter(name="rangeKeyField")
    def range_key_field(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the range key (also called the sort key).
        """
        return pulumi.get(self, "range_key_field")

    @range_key_field.setter
    def range_key_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range_key_field", value)

    @property
    @pulumi.getter(name="rangeKeyType")
    def range_key_type(self) -> Optional[pulumi.Input[str]]:
        """
        The data type for the range key (also called the sort key), You can specify the following values:

        * `STRING` - The range key is a string.

        * `NUMBER` - The range key is number.

        If you don't specify `rangeKeyField`, the default value is `STRING`.
        """
        return pulumi.get(self, "range_key_type")

    @range_key_type.setter
    def range_key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range_key_type", value)

    @property
    @pulumi.getter(name="rangeKeyValue")
    def range_key_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the range key (also called the sort key).
        """
        return pulumi.get(self, "range_key_value")

    @range_key_value.setter
    def range_key_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range_key_value", value)


@pulumi.input_type
class DetectorModelEventArgs:
    def __init__(__self__, *,
                 event_name: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]]] = None,
                 condition: Optional[pulumi.Input[str]] = None):
        """
        Specifies the `actions` to be performed when the `condition` evaluates to `TRUE`.
        :param pulumi.Input[str] event_name: The name of the event.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]] actions: The actions to be performed.
        :param pulumi.Input[str] condition: The Boolean expression that, when `TRUE`, causes the `actions` to be performed. If not present, the `actions` are performed (=`TRUE`). If the expression result is not a `Boolean` value, the `actions` are not performed (=`FALSE`).
        """
        pulumi.set(__self__, "event_name", event_name)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> pulumi.Input[str]:
        """
        The name of the event.
        """
        return pulumi.get(self, "event_name")

    @event_name.setter
    def event_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_name", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]]]:
        """
        The actions to be performed.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        The Boolean expression that, when `TRUE`, causes the `actions` to be performed. If not present, the `actions` are performed (=`TRUE`). If the expression result is not a `Boolean` value, the `actions` are not performed (=`FALSE`).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)


@pulumi.input_type
class DetectorModelFirehoseArgs:
    def __init__(__self__, *,
                 delivery_stream_name: pulumi.Input[str],
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None,
                 separator: Optional[pulumi.Input[str]] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        :param pulumi.Input[str] delivery_stream_name: The name of the Kinesis Data Firehose delivery stream where the data is written.
        :param pulumi.Input[str] separator: A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
        """
        pulumi.set(__self__, "delivery_stream_name", delivery_stream_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)

    @property
    @pulumi.getter(name="deliveryStreamName")
    def delivery_stream_name(self) -> pulumi.Input[str]:
        """
        The name of the Kinesis Data Firehose delivery stream where the data is written.
        """
        return pulumi.get(self, "delivery_stream_name")

    @delivery_stream_name.setter
    def delivery_stream_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "delivery_stream_name", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter
    def separator(self) -> Optional[pulumi.Input[str]]:
        """
        A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
        """
        return pulumi.get(self, "separator")

    @separator.setter
    def separator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "separator", value)


@pulumi.input_type
class DetectorModelIotEventsArgs:
    def __init__(__self__, *,
                 input_name: pulumi.Input[str],
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None):
        """
        Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.
        :param pulumi.Input[str] input_name: The name of the AWS IoT Events input where the data is sent.
        """
        pulumi.set(__self__, "input_name", input_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="inputName")
    def input_name(self) -> pulumi.Input[str]:
        """
        The name of the AWS IoT Events input where the data is sent.
        """
        return pulumi.get(self, "input_name")

    @input_name.setter
    def input_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_name", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


@pulumi.input_type
class DetectorModelIotSiteWiseArgs:
    def __init__(__self__, *,
                 property_value: pulumi.Input['DetectorModelAssetPropertyValueArgs'],
                 asset_id: Optional[pulumi.Input[str]] = None,
                 entry_id: Optional[pulumi.Input[str]] = None,
                 property_alias: Optional[pulumi.Input[str]] = None,
                 property_id: Optional[pulumi.Input[str]] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise.
        :param pulumi.Input[str] asset_id: The ID of the asset that has the specified property. You can specify an expression.
        :param pulumi.Input[str] entry_id: A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier. You can also specify an expression.
        :param pulumi.Input[str] property_alias: The alias of the asset property. You can also specify an expression.
        :param pulumi.Input[str] property_id: The ID of the asset property. You can specify an expression.
        """
        pulumi.set(__self__, "property_value", property_value)
        if asset_id is not None:
            pulumi.set(__self__, "asset_id", asset_id)
        if entry_id is not None:
            pulumi.set(__self__, "entry_id", entry_id)
        if property_alias is not None:
            pulumi.set(__self__, "property_alias", property_alias)
        if property_id is not None:
            pulumi.set(__self__, "property_id", property_id)

    @property
    @pulumi.getter(name="propertyValue")
    def property_value(self) -> pulumi.Input['DetectorModelAssetPropertyValueArgs']:
        return pulumi.get(self, "property_value")

    @property_value.setter
    def property_value(self, value: pulumi.Input['DetectorModelAssetPropertyValueArgs']):
        pulumi.set(self, "property_value", value)

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the asset that has the specified property. You can specify an expression.
        """
        return pulumi.get(self, "asset_id")

    @asset_id.setter
    def asset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_id", value)

    @property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier. You can also specify an expression.
        """
        return pulumi.get(self, "entry_id")

    @entry_id.setter
    def entry_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_id", value)

    @property
    @pulumi.getter(name="propertyAlias")
    def property_alias(self) -> Optional[pulumi.Input[str]]:
        """
        The alias of the asset property. You can also specify an expression.
        """
        return pulumi.get(self, "property_alias")

    @property_alias.setter
    def property_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property_alias", value)

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the asset property. You can specify an expression.
        """
        return pulumi.get(self, "property_id")

    @property_id.setter
    def property_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property_id", value)


@pulumi.input_type
class DetectorModelIotTopicPublishArgs:
    def __init__(__self__, *,
                 mqtt_topic: pulumi.Input[str],
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None):
        """
        Information required to publish the MQTT message through the AWS IoT message broker.
        :param pulumi.Input[str] mqtt_topic: The MQTT topic of the message. You can use a string expression that includes variables (`$variable.<variable-name>`) and input values (`$input.<input-name>.<path-to-datum>`) as the topic string.
        """
        pulumi.set(__self__, "mqtt_topic", mqtt_topic)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="mqttTopic")
    def mqtt_topic(self) -> pulumi.Input[str]:
        """
        The MQTT topic of the message. You can use a string expression that includes variables (`$variable.<variable-name>`) and input values (`$input.<input-name>.<path-to-datum>`) as the topic string.
        """
        return pulumi.get(self, "mqtt_topic")

    @mqtt_topic.setter
    def mqtt_topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "mqtt_topic", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


@pulumi.input_type
class DetectorModelLambdaArgs:
    def __init__(__self__, *,
                 function_arn: pulumi.Input[str],
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None):
        """
        :param pulumi.Input[str] function_arn: The ARN of the Lambda function that is executed.
        """
        pulumi.set(__self__, "function_arn", function_arn)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the Lambda function that is executed.
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_arn", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


@pulumi.input_type
class DetectorModelOnEnterArgs:
    def __init__(__self__, *,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]] = None):
        """
        When entering this state, perform these `actions` if the `condition` is `TRUE`.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]] events: Specifies the `actions` that are performed when the state is entered and the `condition` is `TRUE`.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]]:
        """
        Specifies the `actions` that are performed when the state is entered and the `condition` is `TRUE`.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]]):
        pulumi.set(self, "events", value)


@pulumi.input_type
class DetectorModelOnExitArgs:
    def __init__(__self__, *,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]] = None):
        """
        When exiting this state, perform these `actions` if the specified `condition` is `TRUE`.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]] events: Specifies the `actions` that are performed when the state is exited and the `condition` is `TRUE`.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]]:
        """
        Specifies the `actions` that are performed when the state is exited and the `condition` is `TRUE`.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]]):
        pulumi.set(self, "events", value)


@pulumi.input_type
class DetectorModelOnInputArgs:
    def __init__(__self__, *,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]] = None,
                 transition_events: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelTransitionEventArgs']]]] = None):
        """
        When an input is received and the `condition` is `TRUE`, perform the specified `actions`.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]] events: Specifies the `actions` performed when the `condition` evaluates to `TRUE`.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorModelTransitionEventArgs']]] transition_events: Specifies the `actions` performed, and the next `state` entered, when a `condition` evaluates to `TRUE`.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)
        if transition_events is not None:
            pulumi.set(__self__, "transition_events", transition_events)

    @property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]]:
        """
        Specifies the `actions` performed when the `condition` evaluates to `TRUE`.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]]):
        pulumi.set(self, "events", value)

    @property
    @pulumi.getter(name="transitionEvents")
    def transition_events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelTransitionEventArgs']]]]:
        """
        Specifies the `actions` performed, and the next `state` entered, when a `condition` evaluates to `TRUE`.
        """
        return pulumi.get(self, "transition_events")

    @transition_events.setter
    def transition_events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelTransitionEventArgs']]]]):
        pulumi.set(self, "transition_events", value)


@pulumi.input_type
class DetectorModelPayloadArgs:
    def __init__(__self__, *,
                 content_expression: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        Information needed to configure the payload.

        By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use `contentExpression`.
        :param pulumi.Input[str] content_expression: The content of the payload. You can use a string expression that includes quoted strings (`'<string>'`), variables (`$variable.<variable-name>`), input values (`$input.<input-name>.<path-to-datum>`), string concatenations, and quoted strings that contain `${}` as the content. The recommended maximum size of a content expression is 1 KB.
        :param pulumi.Input[str] type: The value of the payload type can be either `STRING` or `JSON`.
        """
        pulumi.set(__self__, "content_expression", content_expression)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="contentExpression")
    def content_expression(self) -> pulumi.Input[str]:
        """
        The content of the payload. You can use a string expression that includes quoted strings (`'<string>'`), variables (`$variable.<variable-name>`), input values (`$input.<input-name>.<path-to-datum>`), string concatenations, and quoted strings that contain `${}` as the content. The recommended maximum size of a content expression is 1 KB.
        """
        return pulumi.get(self, "content_expression")

    @content_expression.setter
    def content_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_expression", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The value of the payload type can be either `STRING` or `JSON`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DetectorModelResetTimerArgs:
    def __init__(__self__, *,
                 timer_name: pulumi.Input[str]):
        """
        Information required to reset the timer. The timer is reset to the previously evaluated result of the duration. The duration expression isn't reevaluated when you reset the timer.
        :param pulumi.Input[str] timer_name: The name of the timer to reset.
        """
        pulumi.set(__self__, "timer_name", timer_name)

    @property
    @pulumi.getter(name="timerName")
    def timer_name(self) -> pulumi.Input[str]:
        """
        The name of the timer to reset.
        """
        return pulumi.get(self, "timer_name")

    @timer_name.setter
    def timer_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "timer_name", value)


@pulumi.input_type
class DetectorModelSetTimerArgs:
    def __init__(__self__, *,
                 timer_name: pulumi.Input[str],
                 duration_expression: Optional[pulumi.Input[str]] = None,
                 seconds: Optional[pulumi.Input[int]] = None):
        """
        Information needed to set the timer.
        :param pulumi.Input[str] timer_name: The name of the timer.
        :param pulumi.Input[str] duration_expression: The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (`$variable.<variable-name>`), and input values (`$input.<input-name>.<path-to-datum>`) as the duration. The range of the duration is `1-31622400` seconds. To ensure accuracy, the minimum duration is `60` seconds. The evaluated result of the duration is rounded down to the nearest whole number.
        :param pulumi.Input[int] seconds: The number of seconds until the timer expires. The minimum value is `60` seconds to ensure accuracy. The maximum value is `31622400` seconds.
        """
        pulumi.set(__self__, "timer_name", timer_name)
        if duration_expression is not None:
            pulumi.set(__self__, "duration_expression", duration_expression)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter(name="timerName")
    def timer_name(self) -> pulumi.Input[str]:
        """
        The name of the timer.
        """
        return pulumi.get(self, "timer_name")

    @timer_name.setter
    def timer_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "timer_name", value)

    @property
    @pulumi.getter(name="durationExpression")
    def duration_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (`$variable.<variable-name>`), and input values (`$input.<input-name>.<path-to-datum>`) as the duration. The range of the duration is `1-31622400` seconds. To ensure accuracy, the minimum duration is `60` seconds. The evaluated result of the duration is rounded down to the nearest whole number.
        """
        return pulumi.get(self, "duration_expression")

    @duration_expression.setter
    def duration_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration_expression", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds until the timer expires. The minimum value is `60` seconds to ensure accuracy. The maximum value is `31622400` seconds.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seconds", value)


@pulumi.input_type
class DetectorModelSetVariableArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 variable_name: pulumi.Input[str]):
        """
        Information about the variable and its new value.
        :param pulumi.Input[str] value: The new value of the variable.
        :param pulumi.Input[str] variable_name: The name of the variable.
        """
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "variable_name", variable_name)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The new value of the variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> pulumi.Input[str]:
        """
        The name of the variable.
        """
        return pulumi.get(self, "variable_name")

    @variable_name.setter
    def variable_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "variable_name", value)


@pulumi.input_type
class DetectorModelSnsArgs:
    def __init__(__self__, *,
                 target_arn: pulumi.Input[str],
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None):
        """
        Information required to publish the Amazon SNS message.
        :param pulumi.Input[str] target_arn: The ARN of the Amazon SNS target where the message is sent.
        """
        pulumi.set(__self__, "target_arn", target_arn)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the Amazon SNS target where the message is sent.
        """
        return pulumi.get(self, "target_arn")

    @target_arn.setter
    def target_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_arn", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


@pulumi.input_type
class DetectorModelSqsArgs:
    def __init__(__self__, *,
                 queue_url: pulumi.Input[str],
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None,
                 use_base64: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] queue_url: The URL of the SQS queue where the data is written.
        :param pulumi.Input[bool] use_base64: Set this to `TRUE` if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to `FALSE`.
        """
        pulumi.set(__self__, "queue_url", queue_url)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if use_base64 is not None:
            pulumi.set(__self__, "use_base64", use_base64)

    @property
    @pulumi.getter(name="queueUrl")
    def queue_url(self) -> pulumi.Input[str]:
        """
        The URL of the SQS queue where the data is written.
        """
        return pulumi.get(self, "queue_url")

    @queue_url.setter
    def queue_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "queue_url", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="useBase64")
    def use_base64(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this to `TRUE` if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to `FALSE`.
        """
        return pulumi.get(self, "use_base64")

    @use_base64.setter
    def use_base64(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_base64", value)


@pulumi.input_type
class DetectorModelStateArgs:
    def __init__(__self__, *,
                 state_name: pulumi.Input[str],
                 on_enter: Optional[pulumi.Input['DetectorModelOnEnterArgs']] = None,
                 on_exit: Optional[pulumi.Input['DetectorModelOnExitArgs']] = None,
                 on_input: Optional[pulumi.Input['DetectorModelOnInputArgs']] = None):
        """
        Information that defines a state of a detector.
        :param pulumi.Input[str] state_name: The name of the state.
        """
        pulumi.set(__self__, "state_name", state_name)
        if on_enter is not None:
            pulumi.set(__self__, "on_enter", on_enter)
        if on_exit is not None:
            pulumi.set(__self__, "on_exit", on_exit)
        if on_input is not None:
            pulumi.set(__self__, "on_input", on_input)

    @property
    @pulumi.getter(name="stateName")
    def state_name(self) -> pulumi.Input[str]:
        """
        The name of the state.
        """
        return pulumi.get(self, "state_name")

    @state_name.setter
    def state_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "state_name", value)

    @property
    @pulumi.getter(name="onEnter")
    def on_enter(self) -> Optional[pulumi.Input['DetectorModelOnEnterArgs']]:
        return pulumi.get(self, "on_enter")

    @on_enter.setter
    def on_enter(self, value: Optional[pulumi.Input['DetectorModelOnEnterArgs']]):
        pulumi.set(self, "on_enter", value)

    @property
    @pulumi.getter(name="onExit")
    def on_exit(self) -> Optional[pulumi.Input['DetectorModelOnExitArgs']]:
        return pulumi.get(self, "on_exit")

    @on_exit.setter
    def on_exit(self, value: Optional[pulumi.Input['DetectorModelOnExitArgs']]):
        pulumi.set(self, "on_exit", value)

    @property
    @pulumi.getter(name="onInput")
    def on_input(self) -> Optional[pulumi.Input['DetectorModelOnInputArgs']]:
        return pulumi.get(self, "on_input")

    @on_input.setter
    def on_input(self, value: Optional[pulumi.Input['DetectorModelOnInputArgs']]):
        pulumi.set(self, "on_input", value)


@pulumi.input_type
class DetectorModelTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Tags to be applied to Input.
        :param pulumi.Input[str] key: Key of the Tag.
        :param pulumi.Input[str] value: Value of the Tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Key of the Tag.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of the Tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DetectorModelTransitionEventArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input[str],
                 event_name: pulumi.Input[str],
                 next_state: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]]] = None):
        """
        Specifies the `actions `performed and the next `state` entered when a `condition` evaluates to `TRUE`.
        :param pulumi.Input[str] condition: A Boolean expression that when `TRUE` causes the `actions` to be performed and the `nextState` to be entered.
        :param pulumi.Input[str] event_name: The name of the event.
        :param pulumi.Input[str] next_state: The next state to enter.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]] actions: The actions to be performed.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "event_name", event_name)
        pulumi.set(__self__, "next_state", next_state)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input[str]:
        """
        A Boolean expression that when `TRUE` causes the `actions` to be performed and the `nextState` to be entered.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> pulumi.Input[str]:
        """
        The name of the event.
        """
        return pulumi.get(self, "event_name")

    @event_name.setter
    def event_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_name", value)

    @property
    @pulumi.getter(name="nextState")
    def next_state(self) -> pulumi.Input[str]:
        """
        The next state to enter.
        """
        return pulumi.get(self, "next_state")

    @next_state.setter
    def next_state(self, value: pulumi.Input[str]):
        pulumi.set(self, "next_state", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]]]:
        """
        The actions to be performed.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]]]):
        pulumi.set(self, "actions", value)


@pulumi.input_type
class InputAttributeArgs:
    def __init__(__self__, *,
                 json_path: pulumi.Input[str]):
        """
        The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using `BatchPutMessage`. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the `condition` expressions used by detectors that monitor this input.
        :param pulumi.Input[str] json_path: An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to AWS IoT Events (`BatchPutMessage`). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the `condition` expressions used by detectors.
               
               _Syntax_: `<field-name>.<field-name>...`
        """
        pulumi.set(__self__, "json_path", json_path)

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> pulumi.Input[str]:
        """
        An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to AWS IoT Events (`BatchPutMessage`). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the `condition` expressions used by detectors.

        _Syntax_: `<field-name>.<field-name>...`
        """
        return pulumi.get(self, "json_path")

    @json_path.setter
    def json_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "json_path", value)


@pulumi.input_type
class InputInputDefinitionArgs:
    def __init__(__self__, *,
                 attributes: pulumi.Input[Sequence[pulumi.Input['InputAttributeArgs']]]):
        """
        The definition of the input.
        :param pulumi.Input[Sequence[pulumi.Input['InputAttributeArgs']]] attributes: The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using `BatchPutMessage`. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the `condition` expressions used by detectors that monitor this input.
        """
        pulumi.set(__self__, "attributes", attributes)

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Input[Sequence[pulumi.Input['InputAttributeArgs']]]:
        """
        The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using `BatchPutMessage`. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the `condition` expressions used by detectors that monitor this input.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: pulumi.Input[Sequence[pulumi.Input['InputAttributeArgs']]]):
        pulumi.set(self, "attributes", value)


@pulumi.input_type
class InputTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Tags to be applied to Input.
        :param pulumi.Input[str] key: Key of the Tag.
        :param pulumi.Input[str] value: Value of the Tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Key of the Tag.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of the Tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


