# Generated by Django 2.2.10 on 2020-02-17 16:59

from django.db import migrations, models
import NEMO.utilities

class Migration(migrations.Migration):

    dependencies = [
        ('NEMO', '0012_version_2_0_0'),
    ]

    operations = [
        migrations.AddField(
            model_name='interlockcard',
            name='name',
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AddField(
            model_name='tool',
            name='_description',
            field=models.TextField(blank=True, db_column='description', help_text='HTML syntax could be used', null=True),
        ),
        migrations.AddField(
            model_name='tool',
            name='_serial',
            field=models.CharField(blank=True, db_column='serial', help_text='Serial Number', max_length=100, null=True),
        ),
        migrations.AddField(
            model_name='tool',
            name='_image',
            field=models.ImageField(blank=True, db_column='image', help_text='An image that represent the tool. Maximum width and height are 500px', upload_to=NEMO.utilities.get_tool_image_filename),
        ),
        migrations.AddField(
            model_name='physicalaccesslevel',
            name='allow_staff_access',
            field=models.BooleanField(default=False, help_text='Check this box to allow access to Staff users without explicitly granting them access'),
        ),
        migrations.CreateModel(
            name='AlertCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
            ],
            options={
                'verbose_name_plural': 'Alert categories',
                'ordering': ['name'],
            },
        ),
        migrations.AddField(
            model_name='alert',
            name='category',
            field=models.CharField(blank=True, help_text='A category/type for this alert.', max_length=200),
        ),
        migrations.AddField(
            model_name='alert',
            name='deleted',
            field=models.BooleanField(default=False, help_text="Indicates the alert has been deleted and won't be shown anymore"),
        ),
        migrations.AddField(
            model_name='alert',
            name='expired',
            field=models.BooleanField(default=False, help_text="Indicates the alert has expired and won't be shown anymore"),
        ),
    ]
