from abc import ABC

from cli_ui import debug as verbose

from typing import List

from gitlabform.configuration import Configuration
from gitlabform.gitlab import GitLab
from gitlabform.output import EffectiveConfiguration
from gitlabform.processors.abstract_processor import AbstractProcessor


class AbstractProcessors(ABC):
    def __init__(self, gitlab: GitLab, config: Configuration, strict: bool):
        self.processors: List[AbstractProcessor] = []

    def get_configuration_names(self):
        return [processor.configuration_name for processor in self.processors]

    def process_entity(
        self,
        entity_reference: str,
        configuration: dict,
        dry_run: bool,
        effective_configuration: EffectiveConfiguration,
        only_sections: List[str],
    ):
        for processor in self.processors:
            if only_sections == "all" or processor.configuration_name in only_sections:
                processor.process(
                    entity_reference, configuration, dry_run, effective_configuration
                )
            else:
                verbose(
                    f"Skipping section '{processor.configuration_name}' - not in --only-sections list."
                )
