# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_ynh',
 'django_ynh.management',
 'django_ynh.management.commands',
 'django_ynh.sso_auth']

package_data = \
{'': ['*']}

install_requires = \
['django', 'django-axes', 'django-redis', 'gunicorn', 'psycopg2-binary']

setup_kwargs = {
    'name': 'django-ynh',
    'version': '0.1.4',
    'description': 'Glue code to package django projects as yunohost apps.',
    'long_description': '# django_ynh\n\n\nGlue code to package django projects as yunohost apps.\n\nThis repository is:\n\n* The Python package [django-ynh](https://pypi.org/project/django-ynh/) with helpers for integrate a Django project as YunoHost package\n* A example [YunoHost Application](https://install-app.yunohost.org/?app=django_ynh) that can be installed\n\n\n[![Integration level](https://dash.yunohost.org/integration/django_ynh.svg)](https://dash.yunohost.org/appci/app/django_ynh) ![](https://ci-apps.yunohost.org/ci/badges/django_ynh.status.svg) ![](https://ci-apps.yunohost.org/ci/badges/django_ynh.maintain.svg)\n[![Install django_ynh with YunoHost](https://install-app.yunohost.org/install-with-yunohost.svg)](https://install-app.yunohost.org/?app=django_ynh)\n\n\nPull requests welcome ;)\n\n\n## Features\n\n* SSOwat integration (see below)\n* Helper to create first super user for `scripts/install`\n* Run Django development server with a local generated YunoHost package installation (called `local_test`)\n* Run `pytest` against `local_test` "installation"\n\n\n### SSO authentication\n\n[SSOwat](https://github.com/YunoHost/SSOwat) is fully supported:\n\n* First user (`$YNH_APP_ARG_ADMIN`) will be created as Django\'s super user\n* All new users will be created as normal users\n* Login via SSO is fully supported\n* User Email, First / Last name will be updated from SSO data\n\n\n### usage\n\nTo create/update the first user in `install`/`upgrade`, e.g.:\n\n```bash\n./manage.py create_superuser --username="$admin" --email="$admin_mail"\n```\nThis Create/update Django superuser and set a unusable password.\nA password is not needed, because auth done via SSOwat ;)\n\nMain parts in `settings.py`:\n```python\nfrom django_ynh.secret_key import get_or_create_secret as __get_or_create_secret\n\n# Function that will be called to finalize a user profile:\nYNH_SETUP_USER = \'setup_user.setup_project_user\'\n\nSECRET_KEY = __get_or_create_secret(FINAL_HOME_PATH / \'secret.txt\')  # /opt/yunohost/$app/secret.txt\n\nINSTALLED_APPS = [\n    #...\n    \'django_ynh\',\n    #...\n]\n\nMIDDLEWARE = [\n    #... after AuthenticationMiddleware ...\n    #\n    # login a user via HTTP_REMOTE_USER header from SSOwat:\n    \'django_ynh.sso_auth.auth_middleware.SSOwatRemoteUserMiddleware\',\n    #...\n]\n\n# Keep ModelBackend around for per-user permissions and superuser\nAUTHENTICATION_BACKENDS = (\n    \'axes.backends.AxesBackend\',  # AxesBackend should be the first backend!\n    #\n    # Authenticate via SSO and nginx \'HTTP_REMOTE_USER\' header:\n    \'django_ynh.sso_auth.auth_backend.SSOwatUserBackend\',\n    #\n    # Fallback to normal Django model backend:\n    \'django.contrib.auth.backends.ModelBackend\',\n)\n\nLOGIN_REDIRECT_URL = None\nLOGIN_URL = \'/yunohost/sso/\'\nLOGOUT_REDIRECT_URL = \'/yunohost/sso/\'\n```\n\n\n## local test\n\nFor quicker developing of django_ynh in the context of YunoHost app,\nit\'s possible to run the Django developer server with the settings\nand urls made for YunoHost installation.\n\ne.g.:\n```bash\n~$ git clone https://github.com/YunoHost-Apps/django_ynh.git\n~$ cd django_ynh/\n~/django_ynh$ make\ninstall-poetry         install or update poetry\ninstall                install project via poetry\nupdate                 update the sources and installation and generate "conf/requirements.txt"\nlint                   Run code formatters and linter\nfix-code-style         Fix code formatting\ntox-listenvs           List all tox test environments\ntox                    Run pytest via tox with all environments\npytest                 Run pytest\npublish                Release new version to PyPi\nlocal-test             Run local_test.py to run the project locally\nlocal-diff-settings    Run "manage.py diffsettings" with local test\n\n~/django_ynh$ make install-poetry\n~/django_ynh$ make install\n~/django_ynh$ make local-test\n```\n\nNotes:\n\n* SQlite database will be used\n* A super user with username `test` and password `test` is created\n* The page is available under `http://127.0.0.1:8000/app_path/`\n\n\n## history\n\n* [compare v0.1.4...master](https://github.com/YunoHost-Apps/django_ynh/compare/v0.1.4...master) **dev**\n  * tbc\n* [v0.1.4 - 08.01.2021](https://github.com/YunoHost-Apps/django_ynh/compare/v0.1.3...v0.1.4)\n  * Bugfix [CSRF verification failed on POST requests #7](https://github.com/YunoHost-Apps/django_ynh/issues/7)\n* [v0.1.3 - 08.01.2021](https://github.com/YunoHost-Apps/django_ynh/compare/v0.1.2...v0.1.3)\n  * set "DEBUG = True" in local_test (so static files are served and auth works)\n  * Bugfixes and cleanups\n* [v0.1.2 - 29.12.2020](https://github.com/YunoHost-Apps/django_ynh/compare/v0.1.1...v0.1.2)\n  * Bugfixes\n* [v0.1.1 - 29.12.2020](https://github.com/YunoHost-Apps/django_ynh/compare/v0.1.0...v0.1.1)\n  * Refactor "create_superuser" to a manage command, useable via "django_ynh" in `INSTALLED_APPS`\n  * Generate "conf/requirements.txt" and use this file for install\n  * rename own settings and urls (in `/conf/`)\n* [v0.1.0 - 28.12.2020](https://github.com/YunoHost-Apps/django_ynh/compare/f578f14...v0.1.0)\n  * first working state\n* [23.12.2020](https://github.com/YunoHost-Apps/django_ynh/commit/f578f144a3a6d11d7044597c37d550d29c247773)\n  * init the project\n\n\n## Links\n\n* Report a bug about this package: https://github.com/YunoHost-Apps/django_ynh\n* YunoHost website: https://yunohost.org/\n* PyPi package: https://pypi.org/project/django-ynh/\n\nThese projects used `django_ynh`:\n\n* https://github.com/YunoHost-Apps/pyinventory_ynh\n* https://github.com/YunoHost-Apps/django-for-runners_ynh\n\n---\n\n# Developer info\n\n## package installation / debugging\n\nPlease send your pull request to https://github.com/YunoHost-Apps/django_ynh\n\nTry \'main\' branch, e.g.:\n```bash\nsudo yunohost app install https://github.com/YunoHost-Apps/django_ynh/tree/master --debug\nor\nsudo yunohost app upgrade django_ynh -u https://github.com/YunoHost-Apps/django_ynh/tree/master --debug\n```\n\nTry \'testing\' branch, e.g.:\n```bash\nsudo yunohost app install https://github.com/YunoHost-Apps/django_ynh/tree/testing --debug\nor\nsudo yunohost app upgrade django_ynh -u https://github.com/YunoHost-Apps/django_ynh/tree/testing --debug\n```\n\nTo remove call e.g.:\n```bash\nsudo yunohost app remove django_ynh\n```\n\nBackup / remove / restore cycle, e.g.:\n```bash\nyunohost backup create --apps django_ynh\nyunohost backup list\narchives:\n  - django_ynh-pre-upgrade1\n  - 20201223-163434\nyunohost app remove django_ynh\nyunohost backup restore 20201223-163434 --apps django_ynh\n```\n\nDebug installation, e.g.:\n```bash\nroot@yunohost:~# ls -la /var/www/django_ynh/\ntotal 18\ndrwxr-xr-x 4 root root 4 Dec  8 08:36 .\ndrwxr-xr-x 6 root root 6 Dec  8 08:36 ..\ndrwxr-xr-x 2 root root 2 Dec  8 08:36 media\ndrwxr-xr-x 7 root root 8 Dec  8 08:40 static\n\nroot@yunohost:~# ls -la /opt/yunohost/django_ynh/\ntotal 58\ndrwxr-xr-x 5 django_ynh django_ynh   11 Dec  8 08:39 .\ndrwxr-xr-x 3 root        root           3 Dec  8 08:36 ..\n-rw-r--r-- 1 django_ynh django_ynh  460 Dec  8 08:39 gunicorn.conf.py\n-rw-r--r-- 1 django_ynh django_ynh    0 Dec  8 08:39 local_settings.py\n-rwxr-xr-x 1 django_ynh django_ynh  274 Dec  8 08:39 manage.py\n-rw-r--r-- 1 django_ynh django_ynh  171 Dec  8 08:39 secret.txt\ndrwxr-xr-x 6 django_ynh django_ynh    6 Dec  8 08:37 venv\n-rw-r--r-- 1 django_ynh django_ynh  115 Dec  8 08:39 wsgi.py\n-rw-r--r-- 1 django_ynh django_ynh 4737 Dec  8 08:39 django_ynh_demo_settings.py\n\nroot@yunohost:~# cd /opt/yunohost/django_ynh/\nroot@yunohost:/opt/yunohost/django_ynh# source venv/bin/activate\n(venv) root@yunohost:/opt/yunohost/django_ynh# ./manage.py check\ndjango_ynh v0.8.2 (Django v2.2.17)\nDJANGO_SETTINGS_MODULE=\'django_ynh_demo_settings\'\nPROJECT_PATH:/opt/yunohost/django_ynh/venv/lib/python3.7/site-packages\nBASE_PATH:/opt/yunohost/django_ynh\nSystem check identified no issues (0 silenced).\n\nroot@yunohost:~# tail -f /var/log/django_ynh/django_ynh.log\nroot@yunohost:~# cat /etc/systemd/system/django_ynh.service\n\nroot@yunohost:~# systemctl reload-or-restart django_ynh\nroot@yunohost:~# journalctl --unit=django_ynh --follow\n```\n\n\n',
    'author': 'JensDiemer',
    'author_email': 'git@jensdiemer.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/YunoHost-Apps/django_ynh',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0.0',
}


setup(**setup_kwargs)
