# pnap-ip-api
Public IP blocks are a set of contiguous IPs that allow you to access your servers or networks from the internet.
Use the IP Addresses API to request and delete IP blocks.<br>
<br>
<span class='pnap-api-knowledge-base-link'>
Knowledge base articles to help you can be found
<a href='https://phoenixnap.com/kb/public-ip-management#bmc-public-ip-allocations-api' target='_blank'>here</a>
</span><br>
<br>
<b>All URLs are relative to (https://api.phoenixnap.com/ips/v1/)</b>


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
For more information, please visit [https://phoenixnap.com/](https://phoenixnap.com/)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

You can install this package directly from the [Python Package Index](https://pypi.org/) using:

```sh
pip install pnap_ip_api
```

Then import the package:
```python
import pnap_ip_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pnap_ip_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import pnap_ip_api
from pprint import pprint
from pnap_ip_api.api import ip_blocks_api
from pnap_ip_api.model.delete_ip_block_result import DeleteIpBlockResult
from pnap_ip_api.model.error import Error
from pnap_ip_api.model.ip_block import IpBlock
from pnap_ip_api.model.ip_block_create import IpBlockCreate
from pnap_ip_api.model.ip_block_patch import IpBlockPatch
from pnap_ip_api.model.tag_assignment_request import TagAssignmentRequest
# Defining the host is optional and defaults to https://api.phoenixnap.com/ips/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = pnap_ip_api.Configuration(
    host = "https://api.phoenixnap.com/ips/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: OAuth2
configuration = pnap_ip_api.Configuration(
    host = "https://api.phoenixnap.com/ips/v1"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with pnap_ip_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = ip_blocks_api.IPBlocksApi(api_client)
    tag = ["env.dev","loc.phx"] # [str] | List of tags, in the form tagName.tagValue, to filter by. (optional)

    try:
        # List IP Blocks.
        api_response = api_instance.ip_blocks_get(tag=tag)
        pprint(api_response)
    except pnap_ip_api.ApiException as e:
        print("Exception when calling IPBlocksApi->ip_blocks_get: %s\n" % e)
```
To generate a token using the [python-keycloak](https://pypi.org/project/python-keycloak/) library:

```python
from keycloak import KeycloakOpenID

clientId = "YOUR_CLIENT_ID"
clientSecret = "YOUR_CLIENT_SECRET"
serverUrl = "https://auth.phoenixnap.com/auth/"
realmName = "BMC"
grantType = "client_credentials"

keycloakOpenId =  KeycloakOpenID(server_url=serverUrl,
                        realm_name=realmName,
                        client_id=clientId,
                        client_secret_key=clientSecret)

ACCESS_TOKEN = keycloakOpenId.token(grant_type=grantType)['access_token']
```

## Documentation for API Endpoints

All URIs are relative to *https://api.phoenixnap.com/ips/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*IPBlocksApi* | [**ip_blocks_get**](docs/IPBlocksApi.md#ip_blocks_get) | **GET** /ip-blocks | List IP Blocks.
*IPBlocksApi* | [**ip_blocks_ip_block_id_delete**](docs/IPBlocksApi.md#ip_blocks_ip_block_id_delete) | **DELETE** /ip-blocks/{ipBlockId} | Delete IP Block.
*IPBlocksApi* | [**ip_blocks_ip_block_id_get**](docs/IPBlocksApi.md#ip_blocks_ip_block_id_get) | **GET** /ip-blocks/{ipBlockId} | Get IP Block.
*IPBlocksApi* | [**ip_blocks_ip_block_id_patch**](docs/IPBlocksApi.md#ip_blocks_ip_block_id_patch) | **PATCH** /ip-blocks/{ipBlockId} | Update IP block.
*IPBlocksApi* | [**ip_blocks_ip_block_id_tags_put**](docs/IPBlocksApi.md#ip_blocks_ip_block_id_tags_put) | **PUT** /ip-blocks/{ipBlockId}/tags | Overwrite tags assigned for IP Block.
*IPBlocksApi* | [**ip_blocks_post**](docs/IPBlocksApi.md#ip_blocks_post) | **POST** /ip-blocks | Create an IP Block.


## Documentation For Models

 - [DeleteIpBlockResult](docs/DeleteIpBlockResult.md)
 - [Error](docs/Error.md)
 - [IpBlock](docs/IpBlock.md)
 - [IpBlockCreate](docs/IpBlockCreate.md)
 - [IpBlockPatch](docs/IpBlockPatch.md)
 - [TagAssignment](docs/TagAssignment.md)
 - [TagAssignmentRequest](docs/TagAssignmentRequest.md)


## Documentation For Authorization


## OAuth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **bmc**: Grants full access to bmc-api.
 - **bmc.read**: Grants read only access to bmc-api.


## Author

support@phoenixnap.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in pnap_ip_api.apis and pnap_ip_api.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from pnap_ip_api.api.default_api import DefaultApi`
- `from pnap_ip_api.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import pnap_ip_api
from pnap_ip_api.apis import *
from pnap_ip_api.models import *
```