from enum import Enum


class PostgreSQLErrorCodes(Enum):
    ER_NO_DATA = '02000'
    ER_NO_ADD_DYN_RESSET_RET = '02001'
    ER_STMT_NOT_YET_COMPLETE = '03000'
    ER_CONN_EXCEPTION = '08000'
    ER_CLIENT_UNABLE_ESTABLISH_CONN = '08001'
    ER_CONN_NOT_EXIST = '08003'
    ER_REJECTED_SQL_CONN = '08004'
    ER_CONN_FAILURE = '08006'
    ER_TRANSAC_RESOL_UNKN = '08007'
    ER_PROTOCOL_VIOLATION = '08P01'
    ER_TRIG_ACTION_EXCEPTION = '09000'
    ER_FEATURE_NOT_SUPPORTED = '0A000'
    ER_INVALID_TRANSAC_INIT = '0B000'
    ER_LOCATOR_EXCEPTION = '0F000'
    ER_INVALID_LOCATOR_SPEC = '0F001'
    ER_INVALID_GRANTOR = '0L000'
    ER_INVALID_GRANT_OP = '0LP01'
    ER_INVALID_ROLE_SPEC = '0P000'
    ER_DIAG_EXCEPTION = '0Z000'
    ER_STACKED_DIAG_ACCESS_WO_ACTIVE_HANDLER = '0Z002'
    ER_CASE_NOT_FOUND = '20000'
    ER_CARDINALITY_VIOLATION = '21000'
    ER_DATA_EXCEPTION = '22000'
    ER_STR_DATA_RIGHT_TRUNC = '22001'
    ER_NULL_NO_INDICATOR_PARAM = '22002'
    ER_NUM_VAL_OUT_OR_RANGE = '22003'
    ER_NULL_VAL_NOT_ALLOWED = '22004'
    ER_ERR_IN_ASSIGNMENT = '22005'
    ER_INVALID_DATETIME_FORMAT = '22007'
    ER_DATETIME_FIELD_OVERFLOW = '22008'
    ER_INVALID_TZ_DISPLACEMENT_VAL = '22009'
    ER_ESC_CHAR_CONFLICT = '2200B'
    ER_INVALID_USE_OF_ESC_CHAR = '2200C'
    ER_INVALID_ESC_OCTET = '2200D'
    ER_ZERO_LENGTH_CHAR_STR = '2200F'
    ER_MOST_SPECIFIC_TYPE_MISMATCH = '2200G'
    ER_SEQ_GEN_LIMIT_EXCEEDED = '2200H'
    ER_NOT_AN_XML_DOC = '2200L'
    ER_INVALID_XML_DOC = '2200M'
    ER_INVALID_XML_CONTENT = '2200N'
    ER_INVALID_XML_COMMENT = '2200S'
    ER_INVALID_XML_PROC_INSTRUC = '2200T'
    ER_INVALID_INDICATOR_PARAM_VAL = '22010'
    ER_SUBSTR_ERR = '22011'
    ER_DIV_BY_ZERO = '22012'
    ER_INVALID_PREC_OR_FOLL_SIZE = '22013'
    ER_INVALID_ARG_FOR_NTILE_FUNC = '22014'
    ER_INTERVAL_FIELD_OVERFLOW = '22015'
    ER_INVALID_ARG_FOR_NTH_VAL_FUNC = '22016'
    ER_INVALID_CHAR_VAL_FOR_CAST = '22018'
    ER_INVALID_ESC_CHAR = '22019'
    ER_INVALID_REG_EXP = '2201B'
    ER_INVALID_ARG_FOR_LOG = '2201E'
    ER_INVALID_ARG_FOR_POW_FUNC = '2201F'
    ER_INVALID_ARG_FOR_WIDTH_BUCKET_FUNC = '2201G'
    ER_INVALID_ROW_CNT_IN_LIMIT_CLAUSE = '2201W'
    ER_INVALID_ROW_CNT_IN_RES_OFFSET_CLAUSE = '2201X'
    ER_CHAR_NOT_IN_REPERTOIRE = '22021'
    ER_INDICATOR_OVERFLOW = '22022'
    ER_INVALID_PARAM_VAL = '22023'
    ER_UNTERMINATED_CSTR = '22024'
    ER_INVALID_ESC_SEQ = '22025'
    ER_STR_DATA_LENGTH_MISMATCH = '22026'
    ER_TRIM_ERR = '22027'
    ER_ARR_SUBSCRIPT_ERR = '2202E'
    ER_INVALID_TABLESAMPLE_REPEAT = '2202G'
    ER_INVALID_TABLESAMPLE_ARG = '2202H'
    ER_DUPE_JSON_OBJ_KEY_VAL = '22030'
    ER_INVALID_ARG_FOR_SQL_JSON_DATETIME_FUNC = '22031'
    ER_INVALID_JSON_TEXT = '22032'
    ER_INVALID_JSON_SUBSCRIPT = '22033'
    ER_MORE_THAN_ONE_SQL_JSON_ITEM = '22034'
    ER_NO_SQL_JSON_ITEM = '22035'
    ER_NON_NUM_SQL_JSON_ITEM = '22036'
    ER_NON_UNIQUE_KEYS_IN_JSON_OBJ = '22037'
    ER_SINGLETON_SQL_JSON_ITEM_REQ = '22038'
    ER_SQL_JSON_ARR_NOT_FOUND = '22039'
    ER_SQL_JSON_MEMBER_NOT_FOUND = '2203A'
    ER_SQL_JSON_NUMBER_NOT_FOUND = '2203B'
    ER_SQL_JSON_OBJ_NOT_FOUND = '2203C'
    ER_TOO_MANY_JSON_ARR_ELEMS = '2203D'
    ER_TOO_MANY_JSON_OBJ_MEMBERS = '2203E'
    ER_SQL_JSON_SCALAR_REQ = '2203F'
    ER_FLOATING_POINT_EXCEPTION = '22P01'
    ER_INVALID_TEXT_REPR = '22P02'
    ER_INVALID_BINARY_REPR = '22P03'
    ER_BAD_COPY_FILE_FORMAT = '22P04'
    ER_UNTRANSLATABLE_CHAR = '22P05'
    ER_NONSTD_USE_OF_ESC_CHAR = '22P06'
    ER_INTEGRITY_CONSTRAINT_VIOLATION = '23000'
    ER_RESTRICT_VIOLATION = '23001'
    ER_NOT_NULL_VIOLATION = '23502'
    ER_FOREIGN_KEY_VIOLATION = '23503'
    ER_UNIQUE_VIOLATION = '23505'
    ER_CHECK_VIOLATION = '23514'
    ER_EXCLUSION_VIOLATION = '23P01'
    ER_INVALID_CURSOR_STATE = '24000'
    ER_INVALID_TRANSAC_STATE = '25000'
    ER_ACTIVE_SQL_TRANSAC = '25001'
    ER_BRANCH_TRANSAC_ALREADY_ACTIVE = '25002'
    ER_INAPPROPRIATE_ACCESS_MODE_FOR_BRANCH_TRANSAC = '25003'
    ER_INAPPROPRIATE_ISOLATION_LVL_FOR_BRANCH_TRANSAC = '25004'
    ER_NO_ACTIVE_SQL_TRANSAC_FOR_BRANCH_TRANSAC = '25005'
    ER_READONLY_SQL_TRANSAC = '25006'
    ER_SCHEMA_AND_DATA_STMT_MIXING_NOT_SUPPORTED = '25007'
    ER_HELD_CURSOR_REQUIRES_SAME_ISOLATION_LVL = '25008'
    ER_NO_ACTIVE_SQL_TRANSAC = '25P01'
    ER_IN_FAILED_SQL_TRANSAC = '25P02'
    ER_IDLE_IN_TRANSAC_SESS_TIMEOUT = '25P03'
    ER_INVALID_SQL_STMT_NAME = '26000'
    ER_TRIGGERED_DATA_CHANGE_VIOLATION = '27000'
    ER_INVALID_AUTHORIZATION_SPEC = '28000'
    ER_INVALID_PASSWORD = '28P01'
    ER_DEPENDENT_PRIVILEGE_DESCRIPTORS_STILL_EXIST = '2B000'
    ER_DEPENDENT_OBJS_STILL_EXIST = '2BP01'
    ER_INVALID_TRANSAC_TERMINATION = '2D000'
    ER_SQL_ROUTINE_EXCEPTION = '2F000'
    ER_MODIFYING_SQL_DATA_NOT_PERMITTED = '2F002'
    ER_PROHIBITED_SQL_STMT_ATTEMPTED = '2F003'
    ER_READING_SQL_DATA_NOT_PERMITTED = '2F004'
    ER_FUNC_EXECUTED_NO_RETURN_STMT = '2F005'
    ER_INVALID_CURSOR_NAME = '34000'
    ER_EXT_ROUTINE_EXCEPTION = '38000'
    ER_CONTAINING_SQL_NOT_PERMITTED = '38001'
    ER_MODIFYING_SQL_DATA_NOT_PERMITTED_EXT = '38002'
    ER_PROHIBITED_SQL_STMT_ATTEMPTED_EXT = '38003'
    ER_READING_SQL_DATA_NOT_PERMITTED_EXT = '38004'
    ER_EXT_ROUTINE_INVOCATION_EXCEPTION = '39000'
    ER_INVALID_SQL_STATE_RETURNED = '39001'
    ER_NULL_VAL_NOT_ALLOWED_EXT = '39004'
    ER_TRIGGER_PROTOCOL_VIOLATED = '39P01'
    ER_SRF_PROTOCOL_VIOLATED = '39P02'
    ER_EVENT_TRIGGER_PROTOCOL_VIOLATE = '39P03'
    ER_SAVEPOINT_EXCEPTION = '3B000'
    ER_INVALID_SAVEPOINT_SPEC = '3B001'
    ER_INVALID_CATALOG_NAME = '3D000'
    ER_INVALID_SCHEMA_NAME = '3F000'
    ER_TRANSAC_ROLLBACK = '40000'
    ER_SERIALIZATION_FAILURE = '40001'
    ER_TRANSAC_INTEGRITY_CONSTRAINT_VIOLATION = '40002'
    ER_STMT_COMPLETION_UNKNOWN = '40003'
    ER_DEADLOCK_DETECTED = '40P01'
    ER_SYNTAX_ERR_OR_ACCESS_RULE_VIOLATION = '42000'
    ER_INSUFFICIENT_PRIVILEGE = '42501'
    ER_SYNTAX_ERR = '42601'
    ER_INVALID_NAME = '42602'
    ER_INVALID_COL_DEF = '42611'
    ER_NAME_TOO_LONG = '42622'
    ER_DUP_COL = '42701'
    ER_AMBIGUOUS_COL = '42702'
    ER_UNDEF_COL = '42703'
    ER_UNDEF_OBJ = '42704'
    ER_DUP_OBJ = '42710'
    ER_DUP_ALIAS = '42712'
    ER_DUP_FUNC = '42723'
    ER_AMBIGUOUS_FUNC = '42725'
    ER_GROUPING_ERR = '42803'
    ER_DATATYPE_MISMATCH = '42804'
    ER_WRONG_OBJ_TYPE = '42809'
    ER_INVALID_FOREIGN_KEY = '42830'
    ER_CANNOT_COERCE = '42846'
    ER_UNDEF_FUNC = '42883'
    ER_GENERATED_ALWAYS = '428C9'
    ER_RESERVED_NAME = '42939'
    ER_UNDEF_TABLE = '42P01'
    ER_UNDEF_PARAM = '42P02'
    ER_DUP_CURSOR = '42P03'
    ER_DUP_DATABASE = '42P04'
    ER_DUP_PREPARED_STMT = '42P05'
    ER_DUP_SCHEMA = '42P06'
    ER_DUP_TABLE = '42P07'
    ER_AMBIGUOUS_PARAM = '42P08'
    ER_AMBIGUOUS_ALIAS = '42P09'
    ER_INVALID_COL_REF = '42P10'
    ER_INVALID_CURSOR_DEF = '42P11'
    ER_INVALID_DATABASE_DEF = '42P12'
    ER_INVALID_FUNC_DEF = '42P13'
    ER_INVALID_PREPARED_STMT_DEF = '42P14'
    ER_INVALID_SCHEMA_DEF = '42P15'
    ER_INVALID_TABLE_DEF = '42P16'
    ER_INVALID_OBJ_DEF = '42P17'
    ER_INDETERMINATE_DATATYPE = '42P18'
    ER_INVALID_RECURSION = '42P19'
    ER_WINDOWING_ERR = '42P20'
    ER_COLLATION_MISMATCH = '42P21'
    ER_INDETERMINATE_COLLATION = '42P22'
    ER_WITH_CHECK_OPTION_VIOLATION = '44000'
    ER_INSSUFICIENT_RESOURCES = '53000'
    ER_DISK_FULL = '53100'
    ER_OUT_OF_MEMORY = '53200'
    ER_TOO_MANY_CONNS = '53300'
    ER_CONFIG_LIMIT_EXCEEDED = '53400'
    ER_PROGRAM_LIMIT_EXCEEDED = '54000'
    ER_STMT_TOO_COMPLEX = '54001'
    ER_TOO_MANY_COLS = '54011'
    ER_TOO_MANY_ARGS = '54023'
    ER_OBJ_NOT_INT_PREREQUISITE_STATE = '55000'
    ER_OBJ_IN_USE = '55006'
    ER_CANT_CHANGE_RUNTIME_PARAM = '55P02'
    ER_LOCK_NOT_AVAILABLE = '55P03'
    ER_UNSAFE_NEW_ENUM_VAL_USAGE = '55P04'
    ER_OPERATOR_INTERVENTION = '57000'
    ER_QUERY_CANCELLED = '57014'
    ER_ADMIN_SHUTDOWN = '57P01'
    ER_CRASH_SHUTDOWN = '57P02'
    ER_CANNOT_CONNECT_NOW = '57P03'
    ER_DATABASE_DROPPED = '57P04'
    ER_IDLE_SESS_TIMEOUT = '57P05'
    ER_SYS_ERR = '58000'
    ER_IO_ERR = '58030'
    ER_UNDEF_FILE = '58P01'
    ER_DUP_FILE = '58P02'
    ER_SNAPSHOT_TOO_OLD = '72000'
    ER_CONFIG_FILE_ERR = 'F0000'
    ER_LOCK_FILE_EXISTS = 'F0001'
    ER_FDW_ERR = 'HV000'
    ER_FDW_OUT_OF_MEMORY = 'HV001'
    ER_FDW_DYNAMIC_PARAM_VAL_NEEDED = 'HV002'
    ER_FDW_INVALID_DATATYPE = 'HV004'
    ER_FDW_CO_NAME_NOT_FOUND = 'HV005'
    ER_FDW_INVALID_DATATYPE_DESCRIPTORS = 'HV006'
    ER_FDW_INVALID_COL_NAME = 'HV007'
    ER_FDW_INVALID_COL_NUMBER = 'HV008'
    ER_FDW_INVALID_USE_OF_NULL_POINTER = 'HV009'
    ER_FDW_INVALID_STR_FORMAT = 'HV00A'
    ER_FDW_INVALID_HANDLE = 'HV00B'
    ER_FDW_INVALID_OPTION_INDEX = 'HV00C'
    ER_FDW_INVALID_OPTION_NAME = 'HV00D'
    ER_FDW_OPTION_NAME_NOT_FOUND = 'HV00J'
    ER_FDW_REPLY_HANDLE = 'HV00K'
    ER_FDW_UNABLE_TO_CREATE_EXECUTION = 'HV00L'
    ER_FDW_UNABLE_TO_CREATE_REPLY = 'HV00M'
    ER_FDW_UNABLE_TO_ESTABLISH_CONN = 'HV00N'
    ER_FDW_NO_SCHEMAS = 'HV00P'
    ER_FDW_SCHEMA_NOT_FOUND = 'HV00Q'
    ER_FDW_TABLE_NOT_FOUND = 'HV00R'
    ER_FDW_FUNC_SEQ_ERR = 'HV010'
    ER_FDW_TOO_MANY_HANDLES = 'HV014'
    ER_FDW_INCONSISTENT_DESCRIPTOR_INFO = 'HV021'
    ER_FDW_INVALID_ATTR_VAL = 'HV024'
    ER_FDW_INVALID_STR_LENGTH_OR_BUFF_LENGTH = 'HV090'
    ER_FDW_INVALID_DESCRIPTOR_FIELD_IDENTIFIER = 'HV091'
    ER_PLPGSQL_ERR = 'P0000'
    ER_RAISE_EXCEPTION = 'P0001'
    ER_NO_DATA_FOUND = 'P0002'
    ER_TOO_MANY_ROWS = 'P0003'
    ER_ASSERT_FAILURE = 'P0004'
    ER_INTERNAL_ERROR = 'XX000'
    ER_DATA_CORRUPTED = 'XX001'
    ER_INDEX_CORRUPTED = 'XX002'
