# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-09-20 09:54
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import djangocms_attributes_field.fields
import filer.fields.file
import filer.fields.image


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('cms', '0016_auto_20160608_1535'),
        ('filer', '0007_auto_20161016_1055'),
    ]

    operations = [
        migrations.CreateModel(
            name='HostingVideoPlayer',
            fields=[
                ('label', models.CharField(blank=True, max_length=255, verbose_name='Label')),
                ('width', models.IntegerField(blank=True, help_text='Leave it blank to make a video player of the default width of video source', null=True, verbose_name='Width')),
                ('height', models.IntegerField(blank=True, help_text='Leave it blank to make a video player of the default width of video source', null=True, verbose_name='Height')),
                ('controls', models.BooleanField(default=True, verbose_name='Show controls')),
                ('autoplay', models.BooleanField(default=False, verbose_name='Autoplay')),
                ('loop', models.BooleanField(default=False, verbose_name='Loop')),
                ('other_attributes', djangocms_attributes_field.fields.AttributesField(blank=True, default=dict, verbose_name='Other attributes')),
                ('cmsplugin_ptr', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='cms_qe_video_hostingvideoplayer', serialize=False, to='cms.CMSPlugin')),
                ('video_hosting_service', models.IntegerField(choices=[(1, 'YouTube'), (2, 'Vimeo'), (3, 'Others')], default=3, verbose_name='Video hosting service')),
                ('video_url', models.URLField(help_text='Use this field to embed videos from external services such as YouTube, Vimeo or others.', max_length=255, verbose_name='Embed link')),
                ('poster', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='filer.Image', verbose_name='Poster')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='SourceFileVideoPlayer',
            fields=[
                ('label', models.CharField(blank=True, max_length=255, verbose_name='Label')),
                ('width', models.IntegerField(blank=True, help_text='Leave it blank to make a video player of the default width of video source', null=True, verbose_name='Width')),
                ('height', models.IntegerField(blank=True, help_text='Leave it blank to make a video player of the default width of video source', null=True, verbose_name='Height')),
                ('controls', models.BooleanField(default=True, verbose_name='Show controls')),
                ('autoplay', models.BooleanField(default=False, verbose_name='Autoplay')),
                ('loop', models.BooleanField(default=False, verbose_name='Loop')),
                ('other_attributes', djangocms_attributes_field.fields.AttributesField(blank=True, default=dict, verbose_name='Other attributes')),
                ('cmsplugin_ptr', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='cms_qe_video_sourcefilevideoplayer', serialize=False, to='cms.CMSPlugin')),
                ('text_title', models.CharField(blank=True, max_length=255, verbose_name='Title')),
                ('text_description', models.TextField(blank=True, verbose_name='Description')),
                ('attributes', djangocms_attributes_field.fields.AttributesField(blank=True, default=dict, verbose_name='Attributes')),
                ('muted', models.BooleanField(default=False, verbose_name='Mute')),
                ('poster', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='filer.Image', verbose_name='Poster')),
                ('source_file', filer.fields.file.FilerFileField(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='filer.File', verbose_name='Source')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='VideoTrack',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='cms_qe_video_videotrack', serialize=False, to='cms.CMSPlugin')),
                ('kind', models.CharField(choices=[('subtitles', 'Subtitles'), ('captions', 'Captions'), ('descriptions', 'Descriptions'), ('chapters', 'Chapters')], max_length=255, verbose_name='Kind')),
                ('srclang', models.CharField(blank=True, help_text='Examples: "en" or "de" etc.', max_length=255, verbose_name='Source language')),
                ('label', models.CharField(blank=True, max_length=255, verbose_name='Label')),
                ('attributes', djangocms_attributes_field.fields.AttributesField(blank=True, default=dict, verbose_name='Attributes')),
                ('src', filer.fields.file.FilerFileField(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='filer.File', verbose_name='Source file')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
    ]
