import pytest

from about_time import HumanThroughput


@pytest.mark.parametrize('count, duration, expected', [
    (1, 1., '1X/s'),
    (10, 1., '10X/s'),
    (1, 2., '30X/m'),
    (10, 2., '5X/s'),
    (11, 2., '5.5X/s'),
    (11, 1.981981981981982, '5.5X/s'),
    (10, 100., '6X/m'),
    (3, 100., '1.8X/m'),
    (8, 110., '4.4X/m'),
    (3, 1600., '6.8X/h'),
    (5432737542, 67587655435., '4.8X/m'),
    (543273754, 67587655435., '28.9X/h'),
    (543273754271, 67587655435., '8X/s'),
    (1, .99, '1X/s'),
    (1, 1.0001, '1X/s'),
    (123, 1165263., '9.12X/d'),
    (1, 3599., '1X/h'),
    (1, 3601., '23.99X/d'),
    (1, 3608., '23.95X/d'),
    (2, 80000., '2.16X/d'),
])
def test_throughput_human(count, duration, expected):
    assert HumanThroughput(count / duration, 'X') == expected
    assert HumanThroughput(count / duration, '!').unit('X') == expected


@pytest.mark.parametrize('count, duration, prec, expected', [
    (1, 1., 1, '1.0X/s'),
    (1, 1., 2, '1.00X/s'),
    (10, 1., 1, '10.0X/s'),
    (10, 1., 2, '10.00X/s'),
    (1, 2., 1, '30.0X/m'),
    (1, 2., 2, '30.00X/m'),
    (10, 2., 1, '5.0X/s'),
    (10, 2., 2, '5.00X/s'),
    (11, 2., 1, '5.5X/s'),
    (11, 2., 2, '5.50X/s'),
    (11, 1.981981981981982, 1, '5.5X/s'),
    (11, 1.981981981981982, 2, '5.55X/s'),
    (10, 100., 1, '6.0X/m'),
    (10, 100., 2, '6.00X/m'),
    (3, 100., 1, '1.8X/m'),
    (3, 100., 2, '1.80X/m'),
    (8, 110., 1, '4.4X/m'),
    (8, 110., 2, '4.36X/m'),
    (3, 1600., 1, '6.8X/h'),
    (3, 1600., 2, '6.75X/h'),
    (5432737542, 67587655435., 1, '4.8X/m'),
    (5432737542, 67587655435., 2, '4.82X/m'),
    (543273754, 67587655435., 1, '28.9X/h'),
    (543273754, 67587655435., 2, '28.94X/h'),
    (543273754271, 67587655435., 1, '8.0X/s'),
    (543273754271, 67587655435., 2, '8.04X/s'),
    (1, .99, 1, '1.0X/s'),
    (1, .99, 2, '1.01X/s'),
    (1, 1.0001, 1, '1.0X/s'),
    (1, 1.0001, 2, '1.00X/s'),
    (123, 1165263., 1, '9.1X/d'),
    (123, 1165263., 2, '9.12X/d'),
    (1, 3599., 1, '1.0X/h'),
    (1, 3599., 2, '1.00X/h'),
    (1, 3601., 1, '24.0X/d'),
    (1, 3601., 2, '23.99X/d'),
    (1, 3608., 1, '23.9X/d'),
    (1, 3608., 2, '23.95X/d'),
    (2, 80000., 1, '2.2X/d'),
    (2, 80000., 2, '2.16X/d'),
])
def test_throughput_human_prec(count, duration, prec, expected):
    assert HumanThroughput(count / duration, 'X').as_human(prec) == expected
    assert HumanThroughput(count / duration, '!').unit('X').as_human(prec) == expected
