import pytest

from about_time import HumanCount


@pytest.mark.parametrize('count, expected', [
    (1.23, '1.2X'),
    (12.3, '12.3X'),
    (123., '123X'),
    (1230., '1.2kX'),
    (12300., '12.3kX'),
    (123000., '123kX'),
    (1230000., '1.2MX'),
    (12300000., '12.3MX'),
    (123000000., '123MX'),
    (1230000000., '1.23GX'),
    (12300000000., '12.3GX'),
    (123000000000., '123GX'),
    (1230000000000., '1.23TX'),
    (12300000000000., '12.3TX'),
    (123000000000000., '123TX'),
    (1230000000000000., '1.23PX'),
    (12300000000000000., '12.3PX'),
    (123000000000000000., '123PX'),
    (1230000000000000000., '1.23EX'),
    (12300000000000000000., '12.3EX'),
    (123000000000000000000., '123EX'),
    (1230000000000000000000., '1.23ZX'),
    (12300000000000000000000., '12.3ZX'),
    (123000000000000000000000., '123ZX'),
    (1230000000000000000000000., '1.23YX'),
    (12300000000000000000000000., '12.3YX'),
    (123000000000000000000000000., '123YX'),
    (1230000000000000000000000000., '1.23+X'),
    (2000., '2kX'),
    (2500., '2.5kX'),
    (1825000., '1.8MX'),
    (1825100., '1.8MX'),
    (1825000000., '1.82GX'),
    (1825100000., '1.83GX'),
])
def test_count_human(count, expected):
    assert HumanCount(count, 'X') == expected
    assert HumanCount(count, '!').unit('X') == expected


@pytest.mark.parametrize('count, prec, expected', [
    (1.23, 1, '1.2X'),
    (1.23, 2, '1.23X'),
    (12.3, 1, '12.3X'),
    (12.3, 2, '12.30X'),
    (123., 1, '123.0X'),
    (123., 2, '123.00X'),
    (1230., 1, '1.2kX'),
    (1230., 2, '1.23kX'),
    (12300., 1, '12.3kX'),
    (12300., 2, '12.30kX'),
    (123000., 1, '123.0kX'),
    (123000., 2, '123.00kX'),
    (1230000., 1, '1.2MX'),
    (1230000., 2, '1.23MX'),
    (12300000., 1, '12.3MX'),
    (12300000., 2, '12.30MX'),
    (123000000., 1, '123.0MX'),
    (123000000., 2, '123.00MX'),
    (1230000000., 1, '1.2GX'),
    (1230000000., 2, '1.23GX'),
    (12300000000., 1, '12.3GX'),
    (12300000000., 2, '12.30GX'),
    (123000000000., 1, '123.0GX'),
    (123000000000., 2, '123.00GX'),
    (1230000000000., 1, '1.2TX'),
    (1230000000000., 2, '1.23TX'),
    (12300000000000., 1, '12.3TX'),
    (12300000000000., 2, '12.30TX'),
    (123000000000000., 1, '123.0TX'),
    (123000000000000., 2, '123.00TX'),
    (1230000000000000., 1, '1.2PX'),
    (1230000000000000., 2, '1.23PX'),
    (12300000000000000., 1, '12.3PX'),
    (12300000000000000., 2, '12.30PX'),
    (123000000000000000., 1, '123.0PX'),
    (123000000000000000., 2, '123.00PX'),
    (1230000000000000000., 1, '1.2EX'),
    (1230000000000000000., 2, '1.23EX'),
    (12300000000000000000., 1, '12.3EX'),
    (12300000000000000000., 2, '12.30EX'),
    (123000000000000000000., 1, '123.0EX'),
    (123000000000000000000., 2, '123.00EX'),
    (1230000000000000000000., 1, '1.2ZX'),
    (1230000000000000000000., 2, '1.23ZX'),
    (12300000000000000000000., 1, '12.3ZX'),
    (12300000000000000000000., 2, '12.30ZX'),
    (123000000000000000000000., 1, '123.0ZX'),
    (123000000000000000000000., 2, '123.00ZX'),
    (1230000000000000000000000., 1, '1.2YX'),
    (1230000000000000000000000., 2, '1.23YX'),
    (12300000000000000000000000., 1, '12.3YX'),
    (12300000000000000000000000., 2, '12.30YX'),
    (123000000000000000000000000., 1, '123.0YX'),
    (123000000000000000000000000., 2, '123.00YX'),
    (1230000000000000000000000000., 1, '1.2+X'),
    (1230000000000000000000000000., 2, '1.23+X'),
    (2000., 1, '2.0kX'),
    (2000., 2, '2.00kX'),
    (2500., 1, '2.5kX'),
    (2500., 2, '2.50kX'),
    (1825000., 1, '1.8MX'),
    (1825000., 2, '1.82MX'),
    (1825100., 1, '1.8MX'),
    (1825100., 2, '1.83MX'),
    (1825000000., 1, '1.8GX'),
    (1825000000., 2, '1.82GX'),
    (1825100000., 1, '1.8GX'),
    (1825100000., 2, '1.83GX'),
])
def test_count_human_prec(count, prec, expected):
    assert HumanCount(count, 'X').as_human(prec) == expected
    assert HumanCount(count, '!').unit('X').as_human(prec) == expected
