# OpenI

> PYPI package for 启智AI协作平台。

# 使用说明安装

- 启智平台提供的Python工具包，使用户能在本地上传数据集。
- 用户可以获取镜像内存放代码，数据集，模型，输出结果的路径
- 可以使用公共函数实现数据集的拷贝，模型的上传等
- 使用说明：
  - 使用前请在平台个人设置中获取token：[点击跳转token获取界面](https://openi.pcl.ac.cn/user/settings/applications)
  - 当前版本为了解决用户上传数据集的需求，建议在本地使用。后续版本将适配代码仓配置、隐藏token及云脑任务。

## 安装

*适配python3.6及以上版本*

> PYPI package for 启智 AI 协作平台。

## 安装

_适配 python3.6 及以上版本_

```bash
pip3 install -U openi_test
pip install openi-test==0.5.1 -i https://pypi.tuna.tsinghua.edu.cn/simple
```

## 本地上传数据集示例

**dataset.upload_file(file, username, repository, token, cluster = "NPU")**

## 平台数据集的上传与下载

- 提供命令行与代码使用
- 具体请参考 [帮助文档-API参考](https://openi.pcl.ac.cn/docs/index.html#/api/intro)
- `file`        **str, 必填**：文件路径(包含文件名，支持linux与mac路径，也支持windows文件路径如d:\\xxx)
- `username`    **str, 必填**：上传数据集所属项目owner用户名，可以是用户或组织
- `repository`  **str, 必填**：数据集所属项目路径，此为仓库地址中的名字，更改过名称的项目需填写仓库地址中的路径
- `token`       **str, 必填**：用户启智上获取的令牌token，并对该数据集有权限
- `cluster`     **str, 选填, 默认"NPU"**：可填入GPU或NPU，上传至不同的存储集群

```python


from openi.dataset import upload_file
upload_file(
    file = "", # 必填，文件路径(包含文件名)
    username = "", # 必填，数据集所属项目用户名
    repository = "", # 必填，数据集所属项目名
    token = "", #必填，用户启智上获取的令牌token，并对该项目数据集有权限
  
    cluster = "", # 选填，可填入GPU或NPU，不填写后台默认为NPU
    app_url = "" #选填, 默认为平台地址，用户不用填写，开发测试用
    file = "", 
    username = "", 
    repository = "", 
    token = "", 
    cluster = ""
    )

```

界面

```python
from openi.dataset import download_file

download_file(
    file="my_data.zip",
    repo_id="user1/repo1",
    cluster="gpu",
    save_path="local_path/",
)

""" output
Complete( my_data.zip)(gpu): 100%|██████████████████████████████████████████| 22.0MB/22.0MB [00:01<00:00, 15.9MB/s]
"""
```

```bash
>>> openi
usage: openi {login, whoami, dataset, ...} [<args>] [-h]

OpenI command line tool 启智AI协作平台命令行工具

commands:
  {login,logout,whoami,dataset,d,model,m}
    login               使用令牌登录启智并保存到本机
    logout              登出当前用户并删除本地令牌文件
    whoami              查询当前登录用户
    dataset (d)         {upload,download} 上传/下载启智AI协作平台的数据集
    model (m)           {upload,download} 上传/下载启智AI协作平台的模型
```

```bash
>>> openi login


             ██████╗   ██████╗  ███████╗  ███╗   ██╗  ██████╗
            ██╔═══██╗  ██╔══██╗ ██╔════╝  ████╗  ██║    ██╔═╝
            ██║   ██║  ██████╔╝ █████╗    ██╔██╗ ██║    ██║
            ██║   ██║  ██╔═══╝  ██╔══╝    ██║╚██╗██║    ██║
            ╚██████╔╝  ██║      ███████╗  ██║ ╚████║  ██████╗
             ╚═════╝   ╚═╝      ╚══════╝  ╚═╝  ╚═══╝  ╚═════╝


点击链接获取令牌并复制粘贴到下列输入栏 https://openi.pcl.ac.cn/user/settings/applications

[WARNING] 若本机已存在登录令牌，本次输入的令牌会将其覆盖
          粘贴前请先按 退格键⇦ 删除多余空格

  🔒 token:

```

## 云脑资源初始化与上传，获取路径示例：

```
#导入包
from openi.context import prepare, upload_openi

#初始化导入数据集和预训练模型到容器内
openi_context = prepare()

#获取数据集路径，预训练模型路径，输出路径
dataset_path = openi_context.dataset_path
pretrain_model_path = openi_context.pretrain_model_path
you_must_save_here = openi_context.output_path

#回传结果到openi
upload_openi()
```
